/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddNodesNodeGroupRequest;
import com.google.cloud.compute.v1.AggregatedListNodeGroupsRequest;
import com.google.cloud.compute.v1.DeleteNodeGroupRequest;
import com.google.cloud.compute.v1.DeleteNodesNodeGroupRequest;
import com.google.cloud.compute.v1.GetIamPolicyNodeGroupRequest;
import com.google.cloud.compute.v1.GetNodeGroupRequest;
import com.google.cloud.compute.v1.InsertNodeGroupRequest;
import com.google.cloud.compute.v1.ListNodeGroupsRequest;
import com.google.cloud.compute.v1.ListNodesNodeGroupsRequest;
import com.google.cloud.compute.v1.NodeGroup;
import com.google.cloud.compute.v1.NodeGroupAggregatedList;
import com.google.cloud.compute.v1.NodeGroupList;
import com.google.cloud.compute.v1.NodeGroupNode;
import com.google.cloud.compute.v1.NodeGroupsAddNodesRequest;
import com.google.cloud.compute.v1.NodeGroupsDeleteNodesRequest;
import com.google.cloud.compute.v1.NodeGroupsListNodes;
import com.google.cloud.compute.v1.NodeGroupsScopedList;
import com.google.cloud.compute.v1.NodeGroupsSetNodeTemplateRequest;
import com.google.cloud.compute.v1.NodeGroupsSettings;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchNodeGroupRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicyNodeGroupRequest;
import com.google.cloud.compute.v1.SetNodeTemplateNodeGroupRequest;
import com.google.cloud.compute.v1.TestIamPermissionsNodeGroupRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.ZoneSetPolicyRequest;
import com.google.cloud.compute.v1.stub.NodeGroupsStub;
import com.google.cloud.compute.v1.stub.NodeGroupsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class NodeGroupsClient
implements BackgroundResource {
    private final NodeGroupsSettings settings;
    private final NodeGroupsStub stub;

    public static final NodeGroupsClient create() throws IOException {
        return NodeGroupsClient.create(NodeGroupsSettings.newBuilder().build());
    }

    public static final NodeGroupsClient create(NodeGroupsSettings settings) throws IOException {
        return new NodeGroupsClient(settings);
    }

    public static final NodeGroupsClient create(NodeGroupsStub stub) {
        return new NodeGroupsClient(stub);
    }

    protected NodeGroupsClient(NodeGroupsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NodeGroupsStubSettings)settings.getStubSettings()).createStub();
    }

    protected NodeGroupsClient(NodeGroupsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final NodeGroupsSettings getSettings() {
        return this.settings;
    }

    public NodeGroupsStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> addNodesAsync(String project, String zone, String nodeGroup, NodeGroupsAddNodesRequest nodeGroupsAddNodesRequestResource) {
        AddNodesNodeGroupRequest request = AddNodesNodeGroupRequest.newBuilder().setProject(project).setZone(zone).setNodeGroup(nodeGroup).setNodeGroupsAddNodesRequestResource(nodeGroupsAddNodesRequestResource).build();
        return this.addNodesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> addNodesAsync(AddNodesNodeGroupRequest request) {
        return this.addNodesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddNodesNodeGroupRequest, Operation, Operation> addNodesOperationCallable() {
        return this.stub.addNodesOperationCallable();
    }

    public final UnaryCallable<AddNodesNodeGroupRequest, Operation> addNodesCallable() {
        return this.stub.addNodesCallable();
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListNodeGroupsRequest request = AggregatedListNodeGroupsRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListNodeGroupsRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListNodeGroupsRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String zone, String nodeGroup) {
        DeleteNodeGroupRequest request = DeleteNodeGroupRequest.newBuilder().setProject(project).setZone(zone).setNodeGroup(nodeGroup).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteNodeGroupRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNodeGroupRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteNodeGroupRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final OperationFuture<Operation, Operation> deleteNodesAsync(String project, String zone, String nodeGroup, NodeGroupsDeleteNodesRequest nodeGroupsDeleteNodesRequestResource) {
        DeleteNodesNodeGroupRequest request = DeleteNodesNodeGroupRequest.newBuilder().setProject(project).setZone(zone).setNodeGroup(nodeGroup).setNodeGroupsDeleteNodesRequestResource(nodeGroupsDeleteNodesRequestResource).build();
        return this.deleteNodesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteNodesAsync(DeleteNodesNodeGroupRequest request) {
        return this.deleteNodesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNodesNodeGroupRequest, Operation, Operation> deleteNodesOperationCallable() {
        return this.stub.deleteNodesOperationCallable();
    }

    public final UnaryCallable<DeleteNodesNodeGroupRequest, Operation> deleteNodesCallable() {
        return this.stub.deleteNodesCallable();
    }

    public final NodeGroup get(String project, String zone, String nodeGroup) {
        GetNodeGroupRequest request = GetNodeGroupRequest.newBuilder().setProject(project).setZone(zone).setNodeGroup(nodeGroup).build();
        return this.get(request);
    }

    public final NodeGroup get(GetNodeGroupRequest request) {
        return (NodeGroup)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetNodeGroupRequest, NodeGroup> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String zone, String resource) {
        GetIamPolicyNodeGroupRequest request = GetIamPolicyNodeGroupRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyNodeGroupRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyNodeGroupRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String zone, int initialNodeCount, NodeGroup nodeGroupResource) {
        InsertNodeGroupRequest request = InsertNodeGroupRequest.newBuilder().setProject(project).setZone(zone).setInitialNodeCount(initialNodeCount).setNodeGroupResource(nodeGroupResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertNodeGroupRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertNodeGroupRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertNodeGroupRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String zone) {
        ListNodeGroupsRequest request = ListNodeGroupsRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListNodeGroupsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNodeGroupsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListNodeGroupsRequest, NodeGroupList> listCallable() {
        return this.stub.listCallable();
    }

    public final ListNodesPagedResponse listNodes(String project, String zone, String nodeGroup) {
        ListNodesNodeGroupsRequest request = ListNodesNodeGroupsRequest.newBuilder().setProject(project).setZone(zone).setNodeGroup(nodeGroup).build();
        return this.listNodes(request);
    }

    public final ListNodesPagedResponse listNodes(ListNodesNodeGroupsRequest request) {
        return (ListNodesPagedResponse)((Object)this.listNodesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNodesNodeGroupsRequest, ListNodesPagedResponse> listNodesPagedCallable() {
        return this.stub.listNodesPagedCallable();
    }

    public final UnaryCallable<ListNodesNodeGroupsRequest, NodeGroupsListNodes> listNodesCallable() {
        return this.stub.listNodesCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String zone, String nodeGroup, NodeGroup nodeGroupResource) {
        PatchNodeGroupRequest request = PatchNodeGroupRequest.newBuilder().setProject(project).setZone(zone).setNodeGroup(nodeGroup).setNodeGroupResource(nodeGroupResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchNodeGroupRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchNodeGroupRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchNodeGroupRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Policy setIamPolicy(String project, String zone, String resource, ZoneSetPolicyRequest zoneSetPolicyRequestResource) {
        SetIamPolicyNodeGroupRequest request = SetIamPolicyNodeGroupRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).setZoneSetPolicyRequestResource(zoneSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyNodeGroupRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyNodeGroupRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> setNodeTemplateAsync(String project, String zone, String nodeGroup, NodeGroupsSetNodeTemplateRequest nodeGroupsSetNodeTemplateRequestResource) {
        SetNodeTemplateNodeGroupRequest request = SetNodeTemplateNodeGroupRequest.newBuilder().setProject(project).setZone(zone).setNodeGroup(nodeGroup).setNodeGroupsSetNodeTemplateRequestResource(nodeGroupsSetNodeTemplateRequestResource).build();
        return this.setNodeTemplateAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setNodeTemplateAsync(SetNodeTemplateNodeGroupRequest request) {
        return this.setNodeTemplateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetNodeTemplateNodeGroupRequest, Operation, Operation> setNodeTemplateOperationCallable() {
        return this.stub.setNodeTemplateOperationCallable();
    }

    public final UnaryCallable<SetNodeTemplateNodeGroupRequest, Operation> setNodeTemplateCallable() {
        return this.stub.setNodeTemplateCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String zone, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsNodeGroupRequest request = TestIamPermissionsNodeGroupRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsNodeGroupRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsNodeGroupRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListNodesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNodesNodeGroupsRequest, NodeGroupsListNodes, NodeGroupNode, ListNodesPage, ListNodesFixedSizeCollection> {
        private ListNodesFixedSizeCollection(List<ListNodesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNodesFixedSizeCollection createEmptyCollection() {
            return new ListNodesFixedSizeCollection(null, 0);
        }

        protected ListNodesFixedSizeCollection createCollection(List<ListNodesPage> pages, int collectionSize) {
            return new ListNodesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNodesPage
    extends AbstractPage<ListNodesNodeGroupsRequest, NodeGroupsListNodes, NodeGroupNode, ListNodesPage> {
        private ListNodesPage(PageContext<ListNodesNodeGroupsRequest, NodeGroupsListNodes, NodeGroupNode> context, NodeGroupsListNodes response) {
            super(context, (Object)response);
        }

        private static ListNodesPage createEmptyPage() {
            return new ListNodesPage(null, null);
        }

        protected ListNodesPage createPage(PageContext<ListNodesNodeGroupsRequest, NodeGroupsListNodes, NodeGroupNode> context, NodeGroupsListNodes response) {
            return new ListNodesPage(context, response);
        }

        public ApiFuture<ListNodesPage> createPageAsync(PageContext<ListNodesNodeGroupsRequest, NodeGroupsListNodes, NodeGroupNode> context, ApiFuture<NodeGroupsListNodes> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNodesPagedResponse
    extends AbstractPagedListResponse<ListNodesNodeGroupsRequest, NodeGroupsListNodes, NodeGroupNode, ListNodesPage, ListNodesFixedSizeCollection> {
        public static ApiFuture<ListNodesPagedResponse> createAsync(PageContext<ListNodesNodeGroupsRequest, NodeGroupsListNodes, NodeGroupNode> context, ApiFuture<NodeGroupsListNodes> futureResponse) {
            ApiFuture<ListNodesPage> futurePage = ListNodesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNodesPagedResponse((ListNodesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNodesPagedResponse(ListNodesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNodesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNodeGroupsRequest, NodeGroupList, NodeGroup, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListNodeGroupsRequest, NodeGroupList, NodeGroup, ListPage> {
        private ListPage(PageContext<ListNodeGroupsRequest, NodeGroupList, NodeGroup> context, NodeGroupList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListNodeGroupsRequest, NodeGroupList, NodeGroup> context, NodeGroupList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListNodeGroupsRequest, NodeGroupList, NodeGroup> context, ApiFuture<NodeGroupList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListNodeGroupsRequest, NodeGroupList, NodeGroup, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListNodeGroupsRequest, NodeGroupList, NodeGroup> context, ApiFuture<NodeGroupList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, Map.Entry<String, NodeGroupsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, Map.Entry<String, NodeGroupsScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, Map.Entry<String, NodeGroupsScopedList>> context, NodeGroupAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, Map.Entry<String, NodeGroupsScopedList>> context, NodeGroupAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, Map.Entry<String, NodeGroupsScopedList>> context, ApiFuture<NodeGroupAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, Map.Entry<String, NodeGroupsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, Map.Entry<String, NodeGroupsScopedList>> context, ApiFuture<NodeGroupAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

