/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListRoutersRequest;
import com.google.cloud.compute.v1.DeleteRouterRequest;
import com.google.cloud.compute.v1.GetNatMappingInfoRoutersRequest;
import com.google.cloud.compute.v1.GetRouterRequest;
import com.google.cloud.compute.v1.GetRouterStatusRouterRequest;
import com.google.cloud.compute.v1.InsertRouterRequest;
import com.google.cloud.compute.v1.ListRoutersRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRouterRequest;
import com.google.cloud.compute.v1.PreviewRouterRequest;
import com.google.cloud.compute.v1.Router;
import com.google.cloud.compute.v1.RouterAggregatedList;
import com.google.cloud.compute.v1.RouterList;
import com.google.cloud.compute.v1.RouterStatusResponse;
import com.google.cloud.compute.v1.RoutersPreviewResponse;
import com.google.cloud.compute.v1.RoutersScopedList;
import com.google.cloud.compute.v1.RoutersSettings;
import com.google.cloud.compute.v1.UpdateRouterRequest;
import com.google.cloud.compute.v1.VmEndpointNatMappings;
import com.google.cloud.compute.v1.VmEndpointNatMappingsList;
import com.google.cloud.compute.v1.stub.RoutersStub;
import com.google.cloud.compute.v1.stub.RoutersStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RoutersClient
implements BackgroundResource {
    private final RoutersSettings settings;
    private final RoutersStub stub;

    public static final RoutersClient create() throws IOException {
        return RoutersClient.create(RoutersSettings.newBuilder().build());
    }

    public static final RoutersClient create(RoutersSettings settings) throws IOException {
        return new RoutersClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RoutersClient create(RoutersStub stub) {
        return new RoutersClient(stub);
    }

    protected RoutersClient(RoutersSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RoutersStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RoutersClient(RoutersStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RoutersSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RoutersStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListRoutersRequest request = AggregatedListRoutersRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListRoutersRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListRoutersRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListRoutersRequest, RouterAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation delete(String project, String region, String router) {
        DeleteRouterRequest request = DeleteRouterRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteRouterRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRouterRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Router get(String project, String region, String router) {
        GetRouterRequest request = GetRouterRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).build();
        return this.get(request);
    }

    public final Router get(GetRouterRequest request) {
        return (Router)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRouterRequest, Router> getCallable() {
        return this.stub.getCallable();
    }

    public final GetNatMappingInfoPagedResponse getNatMappingInfo(String project, String region, String router) {
        GetNatMappingInfoRoutersRequest request = GetNatMappingInfoRoutersRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).build();
        return this.getNatMappingInfo(request);
    }

    public final GetNatMappingInfoPagedResponse getNatMappingInfo(GetNatMappingInfoRoutersRequest request) {
        return (GetNatMappingInfoPagedResponse)((Object)this.getNatMappingInfoPagedCallable().call((Object)request));
    }

    public final UnaryCallable<GetNatMappingInfoRoutersRequest, GetNatMappingInfoPagedResponse> getNatMappingInfoPagedCallable() {
        return this.stub.getNatMappingInfoPagedCallable();
    }

    public final UnaryCallable<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList> getNatMappingInfoCallable() {
        return this.stub.getNatMappingInfoCallable();
    }

    public final RouterStatusResponse getRouterStatus(String project, String region, String router) {
        GetRouterStatusRouterRequest request = GetRouterStatusRouterRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).build();
        return this.getRouterStatus(request);
    }

    public final RouterStatusResponse getRouterStatus(GetRouterStatusRouterRequest request) {
        return (RouterStatusResponse)this.getRouterStatusCallable().call((Object)request);
    }

    public final UnaryCallable<GetRouterStatusRouterRequest, RouterStatusResponse> getRouterStatusCallable() {
        return this.stub.getRouterStatusCallable();
    }

    public final Operation insert(String project, String region, Router routerResource) {
        InsertRouterRequest request = InsertRouterRequest.newBuilder().setProject(project).setRegion(region).setRouterResource(routerResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertRouterRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertRouterRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRoutersRequest request = ListRoutersRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRoutersRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRoutersRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRoutersRequest, RouterList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation patch(String project, String region, String router, Router routerResource) {
        PatchRouterRequest request = PatchRouterRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).setRouterResource(routerResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchRouterRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchRouterRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final RoutersPreviewResponse preview(String project, String region, String router, Router routerResource) {
        PreviewRouterRequest request = PreviewRouterRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).setRouterResource(routerResource).build();
        return this.preview(request);
    }

    public final RoutersPreviewResponse preview(PreviewRouterRequest request) {
        return (RoutersPreviewResponse)this.previewCallable().call((Object)request);
    }

    public final UnaryCallable<PreviewRouterRequest, RoutersPreviewResponse> previewCallable() {
        return this.stub.previewCallable();
    }

    public final Operation update(String project, String region, String router, Router routerResource) {
        UpdateRouterRequest request = UpdateRouterRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).setRouterResource(routerResource).build();
        return this.update(request);
    }

    public final Operation update(UpdateRouterRequest request) {
        return (Operation)this.updateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateRouterRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRoutersRequest, RouterList, Router, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRoutersRequest, RouterList, Router, ListPage> {
        private ListPage(PageContext<ListRoutersRequest, RouterList, Router> context, RouterList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRoutersRequest, RouterList, Router> context, RouterList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRoutersRequest, RouterList, Router> context, ApiFuture<RouterList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRoutersRequest, RouterList, Router, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRoutersRequest, RouterList, Router> context, ApiFuture<RouterList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class GetNatMappingInfoFixedSizeCollection
    extends AbstractFixedSizeCollection<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, VmEndpointNatMappings, GetNatMappingInfoPage, GetNatMappingInfoFixedSizeCollection> {
        private GetNatMappingInfoFixedSizeCollection(List<GetNatMappingInfoPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static GetNatMappingInfoFixedSizeCollection createEmptyCollection() {
            return new GetNatMappingInfoFixedSizeCollection(null, 0);
        }

        protected GetNatMappingInfoFixedSizeCollection createCollection(List<GetNatMappingInfoPage> pages, int collectionSize) {
            return new GetNatMappingInfoFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class GetNatMappingInfoPage
    extends AbstractPage<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, VmEndpointNatMappings, GetNatMappingInfoPage> {
        private GetNatMappingInfoPage(PageContext<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, VmEndpointNatMappings> context, VmEndpointNatMappingsList response) {
            super(context, (Object)response);
        }

        private static GetNatMappingInfoPage createEmptyPage() {
            return new GetNatMappingInfoPage(null, null);
        }

        protected GetNatMappingInfoPage createPage(PageContext<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, VmEndpointNatMappings> context, VmEndpointNatMappingsList response) {
            return new GetNatMappingInfoPage(context, response);
        }

        public ApiFuture<GetNatMappingInfoPage> createPageAsync(PageContext<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, VmEndpointNatMappings> context, ApiFuture<VmEndpointNatMappingsList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class GetNatMappingInfoPagedResponse
    extends AbstractPagedListResponse<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, VmEndpointNatMappings, GetNatMappingInfoPage, GetNatMappingInfoFixedSizeCollection> {
        public static ApiFuture<GetNatMappingInfoPagedResponse> createAsync(PageContext<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, VmEndpointNatMappings> context, ApiFuture<VmEndpointNatMappingsList> futureResponse) {
            ApiFuture<GetNatMappingInfoPage> futurePage = GetNatMappingInfoPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<GetNatMappingInfoPage, GetNatMappingInfoPagedResponse>(){

                public GetNatMappingInfoPagedResponse apply(GetNatMappingInfoPage input) {
                    return new GetNatMappingInfoPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private GetNatMappingInfoPagedResponse(GetNatMappingInfoPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)GetNatMappingInfoFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListRoutersRequest, RouterAggregatedList, Map.Entry<String, RoutersScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListRoutersRequest, RouterAggregatedList, Map.Entry<String, RoutersScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListRoutersRequest, RouterAggregatedList, Map.Entry<String, RoutersScopedList>> context, RouterAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListRoutersRequest, RouterAggregatedList, Map.Entry<String, RoutersScopedList>> context, RouterAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListRoutersRequest, RouterAggregatedList, Map.Entry<String, RoutersScopedList>> context, ApiFuture<RouterAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListRoutersRequest, RouterAggregatedList, Map.Entry<String, RoutersScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListRoutersRequest, RouterAggregatedList, Map.Entry<String, RoutersScopedList>> context, ApiFuture<RouterAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListPage, AggregatedListPagedResponse>(){

                public AggregatedListPagedResponse apply(AggregatedListPage input) {
                    return new AggregatedListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

