/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.BackendService;
import com.google.cloud.compute.v1.BackendServiceGroupHealth;
import com.google.cloud.compute.v1.BackendServiceList;
import com.google.cloud.compute.v1.DeleteRegionBackendServiceRequest;
import com.google.cloud.compute.v1.GetHealthRegionBackendServiceRequest;
import com.google.cloud.compute.v1.GetRegionBackendServiceRequest;
import com.google.cloud.compute.v1.InsertRegionBackendServiceRequest;
import com.google.cloud.compute.v1.ListRegionBackendServicesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionBackendServiceRequest;
import com.google.cloud.compute.v1.RegionBackendServicesSettings;
import com.google.cloud.compute.v1.ResourceGroupReference;
import com.google.cloud.compute.v1.UpdateRegionBackendServiceRequest;
import com.google.cloud.compute.v1.stub.RegionBackendServicesStub;
import com.google.cloud.compute.v1.stub.RegionBackendServicesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionBackendServicesClient
implements BackgroundResource {
    private final RegionBackendServicesSettings settings;
    private final RegionBackendServicesStub stub;

    public static final RegionBackendServicesClient create() throws IOException {
        return RegionBackendServicesClient.create(RegionBackendServicesSettings.newBuilder().build());
    }

    public static final RegionBackendServicesClient create(RegionBackendServicesSettings settings) throws IOException {
        return new RegionBackendServicesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionBackendServicesClient create(RegionBackendServicesStub stub) {
        return new RegionBackendServicesClient(stub);
    }

    protected RegionBackendServicesClient(RegionBackendServicesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionBackendServicesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionBackendServicesClient(RegionBackendServicesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionBackendServicesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionBackendServicesStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String region, String backendService) {
        DeleteRegionBackendServiceRequest request = DeleteRegionBackendServiceRequest.newBuilder().setProject(project).setRegion(region).setBackendService(backendService).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteRegionBackendServiceRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRegionBackendServiceRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final BackendService get(String project, String region, String backendService) {
        GetRegionBackendServiceRequest request = GetRegionBackendServiceRequest.newBuilder().setProject(project).setRegion(region).setBackendService(backendService).build();
        return this.get(request);
    }

    public final BackendService get(GetRegionBackendServiceRequest request) {
        return (BackendService)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionBackendServiceRequest, BackendService> getCallable() {
        return this.stub.getCallable();
    }

    public final BackendServiceGroupHealth getHealth(String project, String region, String backendService, ResourceGroupReference resourceGroupReferenceResource) {
        GetHealthRegionBackendServiceRequest request = GetHealthRegionBackendServiceRequest.newBuilder().setProject(project).setRegion(region).setBackendService(backendService).setResourceGroupReferenceResource(resourceGroupReferenceResource).build();
        return this.getHealth(request);
    }

    public final BackendServiceGroupHealth getHealth(GetHealthRegionBackendServiceRequest request) {
        return (BackendServiceGroupHealth)this.getHealthCallable().call((Object)request);
    }

    public final UnaryCallable<GetHealthRegionBackendServiceRequest, BackendServiceGroupHealth> getHealthCallable() {
        return this.stub.getHealthCallable();
    }

    public final Operation insert(String project, String region, BackendService backendServiceResource) {
        InsertRegionBackendServiceRequest request = InsertRegionBackendServiceRequest.newBuilder().setProject(project).setRegion(region).setBackendServiceResource(backendServiceResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertRegionBackendServiceRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertRegionBackendServiceRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionBackendServicesRequest request = ListRegionBackendServicesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionBackendServicesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionBackendServicesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionBackendServicesRequest, BackendServiceList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation patch(String project, String region, String backendService, BackendService backendServiceResource) {
        PatchRegionBackendServiceRequest request = PatchRegionBackendServiceRequest.newBuilder().setProject(project).setRegion(region).setBackendService(backendService).setBackendServiceResource(backendServiceResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchRegionBackendServiceRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchRegionBackendServiceRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Operation update(String project, String region, String backendService, BackendService backendServiceResource) {
        UpdateRegionBackendServiceRequest request = UpdateRegionBackendServiceRequest.newBuilder().setProject(project).setRegion(region).setBackendService(backendService).setBackendServiceResource(backendServiceResource).build();
        return this.update(request);
    }

    public final Operation update(UpdateRegionBackendServiceRequest request) {
        return (Operation)this.updateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateRegionBackendServiceRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionBackendServicesRequest, BackendServiceList, BackendService, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionBackendServicesRequest, BackendServiceList, BackendService, ListPage> {
        private ListPage(PageContext<ListRegionBackendServicesRequest, BackendServiceList, BackendService> context, BackendServiceList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionBackendServicesRequest, BackendServiceList, BackendService> context, BackendServiceList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionBackendServicesRequest, BackendServiceList, BackendService> context, ApiFuture<BackendServiceList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionBackendServicesRequest, BackendServiceList, BackendService, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionBackendServicesRequest, BackendServiceList, BackendService> context, ApiFuture<BackendServiceList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

