/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalAddressName
implements ResourceName {
    private final String address;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/addresses/{address}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalAddressName(Builder builder) {
        this.address = (String)Preconditions.checkNotNull((Object)builder.getAddress());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalAddressName of(String address, String project) {
        return ProjectGlobalAddressName.newBuilder().setAddress(address).setProject(project).build();
    }

    public static String format(String address, String project) {
        return ProjectGlobalAddressName.of(address, project).toString();
    }

    public String getAddress() {
        return this.address;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalAddressName projectGlobalAddressName = this;
            synchronized (projectGlobalAddressName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"address", (Object)this.address);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalAddressName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalAddressName>(){

            public ProjectGlobalAddressName parse(String formattedString) {
                return ProjectGlobalAddressName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalAddressName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalAddressName.parse: formattedString not in valid format");
        return ProjectGlobalAddressName.of((String)matchMap.get("address"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"address", this.address, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalAddressName) {
            ProjectGlobalAddressName that = (ProjectGlobalAddressName)o;
            return Objects.equals(this.address, that.getAddress()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.address, this.project);
    }

    public static class Builder {
        private String address;
        private String project;

        public String getAddress() {
            return this.address;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalAddressName projectGlobalAddressName) {
            this.address = projectGlobalAddressName.address;
            this.project = projectGlobalAddressName.project;
        }

        public ProjectGlobalAddressName build() {
            return new ProjectGlobalAddressName(this);
        }
    }
}

