/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionTargetVpnGatewayName
implements ResourceName {
    private final String project;
    private final String region;
    private final String targetVpnGateway;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/targetVpnGateways/{targetVpnGateway}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionTargetVpnGatewayName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.targetVpnGateway = (String)Preconditions.checkNotNull((Object)builder.getTargetVpnGateway());
    }

    public static ProjectRegionTargetVpnGatewayName of(String project, String region, String targetVpnGateway) {
        return ProjectRegionTargetVpnGatewayName.newBuilder().setProject(project).setRegion(region).setTargetVpnGateway(targetVpnGateway).build();
    }

    public static String format(String project, String region, String targetVpnGateway) {
        return ProjectRegionTargetVpnGatewayName.of(project, region, targetVpnGateway).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getTargetVpnGateway() {
        return this.targetVpnGateway;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionTargetVpnGatewayName projectRegionTargetVpnGatewayName = this;
            synchronized (projectRegionTargetVpnGatewayName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    fieldMapBuilder.put((Object)"targetVpnGateway", (Object)this.targetVpnGateway);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionTargetVpnGatewayName> newFactory() {
        return new ResourceNameFactory<ProjectRegionTargetVpnGatewayName>(){

            public ProjectRegionTargetVpnGatewayName parse(String formattedString) {
                return ProjectRegionTargetVpnGatewayName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionTargetVpnGatewayName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionTargetVpnGatewayName.parse: formattedString not in valid format");
        return ProjectRegionTargetVpnGatewayName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("targetVpnGateway"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "region", this.region, "targetVpnGateway", this.targetVpnGateway});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionTargetVpnGatewayName) {
            ProjectRegionTargetVpnGatewayName that = (ProjectRegionTargetVpnGatewayName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.targetVpnGateway, that.getTargetVpnGateway());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.region, this.targetVpnGateway);
    }

    public static class Builder {
        private String project;
        private String region;
        private String targetVpnGateway;

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getTargetVpnGateway() {
            return this.targetVpnGateway;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setTargetVpnGateway(String targetVpnGateway) {
            this.targetVpnGateway = targetVpnGateway;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionTargetVpnGatewayName projectRegionTargetVpnGatewayName) {
            this.project = projectRegionTargetVpnGatewayName.project;
            this.region = projectRegionTargetVpnGatewayName.region;
            this.targetVpnGateway = projectRegionTargetVpnGatewayName.targetVpnGateway;
        }

        public ProjectRegionTargetVpnGatewayName build() {
            return new ProjectRegionTargetVpnGatewayName(this);
        }
    }
}

