/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectName
implements ResourceName {
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectName of(String project) {
        return ProjectName.newBuilder().setProject(project).build();
    }

    public static String format(String project) {
        return ProjectName.of(project).toString();
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectName projectName = this;
            synchronized (projectName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectName> newFactory() {
        return new ResourceNameFactory<ProjectName>(){

            public ProjectName parse(String formattedString) {
                return ProjectName.parse(formattedString);
            }
        };
    }

    public static ProjectName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectName.parse: formattedString not in valid format");
        return ProjectName.of((String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectName) {
            ProjectName that = (ProjectName)o;
            return Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project);
    }

    public static class Builder {
        private String project;

        public String getProject() {
            return this.project;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectName projectName) {
            this.project = projectName.project;
        }

        public ProjectName build() {
            return new ProjectName(this);
        }
    }
}

