/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteFirewallHttpRequest;
import com.google.cloud.compute.v1.Firewall;
import com.google.cloud.compute.v1.FirewallClient;
import com.google.cloud.compute.v1.FirewallList;
import com.google.cloud.compute.v1.GetFirewallHttpRequest;
import com.google.cloud.compute.v1.InsertFirewallHttpRequest;
import com.google.cloud.compute.v1.ListFirewallsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchFirewallHttpRequest;
import com.google.cloud.compute.v1.UpdateFirewallHttpRequest;
import com.google.cloud.compute.v1.stub.FirewallStub;
import com.google.cloud.compute.v1.stub.HttpJsonFirewallStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class FirewallStubSettings
extends StubSettings<FirewallStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteFirewallHttpRequest, Operation> deleteFirewallSettings;
    private final UnaryCallSettings<GetFirewallHttpRequest, Firewall> getFirewallSettings;
    private final UnaryCallSettings<InsertFirewallHttpRequest, Operation> insertFirewallSettings;
    private final PagedCallSettings<ListFirewallsHttpRequest, FirewallList, FirewallClient.ListFirewallsPagedResponse> listFirewallsSettings;
    private final UnaryCallSettings<PatchFirewallHttpRequest, Operation> patchFirewallSettings;
    private final UnaryCallSettings<UpdateFirewallHttpRequest, Operation> updateFirewallSettings;
    private static final PagedListDescriptor<ListFirewallsHttpRequest, FirewallList, Firewall> LIST_FIREWALLS_PAGE_STR_DESC = new PagedListDescriptor<ListFirewallsHttpRequest, FirewallList, Firewall>(){

        public String emptyToken() {
            return "";
        }

        public ListFirewallsHttpRequest injectToken(ListFirewallsHttpRequest payload, String token) {
            return ListFirewallsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListFirewallsHttpRequest injectPageSize(ListFirewallsHttpRequest payload, int pageSize) {
            return ListFirewallsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListFirewallsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(FirewallList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Firewall> extractResources(FirewallList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListFirewallsHttpRequest, FirewallList, FirewallClient.ListFirewallsPagedResponse> LIST_FIREWALLS_PAGE_STR_FACT = new PagedListResponseFactory<ListFirewallsHttpRequest, FirewallList, FirewallClient.ListFirewallsPagedResponse>(){

        public ApiFuture<FirewallClient.ListFirewallsPagedResponse> getFuturePagedResponse(UnaryCallable<ListFirewallsHttpRequest, FirewallList> callable, ListFirewallsHttpRequest request, ApiCallContext context, ApiFuture<FirewallList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FIREWALLS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FirewallClient.ListFirewallsPagedResponse.createAsync((PageContext<ListFirewallsHttpRequest, FirewallList, Firewall>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteFirewallHttpRequest, Operation> deleteFirewallSettings() {
        return this.deleteFirewallSettings;
    }

    public UnaryCallSettings<GetFirewallHttpRequest, Firewall> getFirewallSettings() {
        return this.getFirewallSettings;
    }

    public UnaryCallSettings<InsertFirewallHttpRequest, Operation> insertFirewallSettings() {
        return this.insertFirewallSettings;
    }

    public PagedCallSettings<ListFirewallsHttpRequest, FirewallList, FirewallClient.ListFirewallsPagedResponse> listFirewallsSettings() {
        return this.listFirewallsSettings;
    }

    public UnaryCallSettings<PatchFirewallHttpRequest, Operation> patchFirewallSettings() {
        return this.patchFirewallSettings;
    }

    public UnaryCallSettings<UpdateFirewallHttpRequest, Operation> updateFirewallSettings() {
        return this.updateFirewallSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public FirewallStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonFirewallStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return FirewallStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FirewallStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected FirewallStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteFirewallSettings = settingsBuilder.deleteFirewallSettings().build();
        this.getFirewallSettings = settingsBuilder.getFirewallSettings().build();
        this.insertFirewallSettings = settingsBuilder.insertFirewallSettings().build();
        this.listFirewallsSettings = settingsBuilder.listFirewallsSettings().build();
        this.patchFirewallSettings = settingsBuilder.patchFirewallSettings().build();
        this.updateFirewallSettings = settingsBuilder.updateFirewallSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<FirewallStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteFirewallHttpRequest, Operation> deleteFirewallSettings;
        private final UnaryCallSettings.Builder<GetFirewallHttpRequest, Firewall> getFirewallSettings;
        private final UnaryCallSettings.Builder<InsertFirewallHttpRequest, Operation> insertFirewallSettings;
        private final PagedCallSettings.Builder<ListFirewallsHttpRequest, FirewallList, FirewallClient.ListFirewallsPagedResponse> listFirewallsSettings;
        private final UnaryCallSettings.Builder<PatchFirewallHttpRequest, Operation> patchFirewallSettings;
        private final UnaryCallSettings.Builder<UpdateFirewallHttpRequest, Operation> updateFirewallSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteFirewallSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getFirewallSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertFirewallSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listFirewallsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FIREWALLS_PAGE_STR_FACT);
            this.patchFirewallSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFirewallSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteFirewallSettings, this.getFirewallSettings, this.insertFirewallSettings, this.listFirewallsSettings, this.patchFirewallSettings, this.updateFirewallSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(FirewallStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)FirewallStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)FirewallStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(FirewallStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteFirewallSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getFirewallSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertFirewallSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listFirewallsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchFirewallSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateFirewallSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(FirewallStubSettings settings) {
            super((StubSettings)settings);
            this.deleteFirewallSettings = settings.deleteFirewallSettings.toBuilder();
            this.getFirewallSettings = settings.getFirewallSettings.toBuilder();
            this.insertFirewallSettings = settings.insertFirewallSettings.toBuilder();
            this.listFirewallsSettings = settings.listFirewallsSettings.toBuilder();
            this.patchFirewallSettings = settings.patchFirewallSettings.toBuilder();
            this.updateFirewallSettings = settings.updateFirewallSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteFirewallSettings, this.getFirewallSettings, this.insertFirewallSettings, this.listFirewallsSettings, this.patchFirewallSettings, this.updateFirewallSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteFirewallHttpRequest, Operation> deleteFirewallSettings() {
            return this.deleteFirewallSettings;
        }

        public UnaryCallSettings.Builder<GetFirewallHttpRequest, Firewall> getFirewallSettings() {
            return this.getFirewallSettings;
        }

        public UnaryCallSettings.Builder<InsertFirewallHttpRequest, Operation> insertFirewallSettings() {
            return this.insertFirewallSettings;
        }

        public PagedCallSettings.Builder<ListFirewallsHttpRequest, FirewallList, FirewallClient.ListFirewallsPagedResponse> listFirewallsSettings() {
            return this.listFirewallsSettings;
        }

        public UnaryCallSettings.Builder<PatchFirewallHttpRequest, Operation> patchFirewallSettings() {
            return this.patchFirewallSettings;
        }

        public UnaryCallSettings.Builder<UpdateFirewallHttpRequest, Operation> updateFirewallSettings() {
            return this.updateFirewallSettings;
        }

        public FirewallStubSettings build() throws IOException {
            return new FirewallStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

