/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionInterconnectAttachmentName
implements ResourceName {
    private final String interconnectAttachment;
    private final String project;
    private final String region;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/interconnectAttachments/{interconnectAttachment}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionInterconnectAttachmentName(Builder builder) {
        this.interconnectAttachment = (String)Preconditions.checkNotNull((Object)builder.getInterconnectAttachment());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
    }

    public static ProjectRegionInterconnectAttachmentName of(String interconnectAttachment, String project, String region) {
        return ProjectRegionInterconnectAttachmentName.newBuilder().setInterconnectAttachment(interconnectAttachment).setProject(project).setRegion(region).build();
    }

    public static String format(String interconnectAttachment, String project, String region) {
        return ProjectRegionInterconnectAttachmentName.of(interconnectAttachment, project, region).toString();
    }

    public String getInterconnectAttachment() {
        return this.interconnectAttachment;
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionInterconnectAttachmentName projectRegionInterconnectAttachmentName = this;
            synchronized (projectRegionInterconnectAttachmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"interconnectAttachment", (Object)this.interconnectAttachment);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionInterconnectAttachmentName> newFactory() {
        return new ResourceNameFactory<ProjectRegionInterconnectAttachmentName>(){

            public ProjectRegionInterconnectAttachmentName parse(String formattedString) {
                return ProjectRegionInterconnectAttachmentName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionInterconnectAttachmentName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionInterconnectAttachmentName.parse: formattedString not in valid format");
        return ProjectRegionInterconnectAttachmentName.of((String)matchMap.get("interconnectAttachment"), (String)matchMap.get("project"), (String)matchMap.get("region"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"interconnectAttachment", this.interconnectAttachment, "project", this.project, "region", this.region});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionInterconnectAttachmentName) {
            ProjectRegionInterconnectAttachmentName that = (ProjectRegionInterconnectAttachmentName)o;
            return Objects.equals(this.interconnectAttachment, that.getInterconnectAttachment()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.interconnectAttachment, this.project, this.region);
    }

    public static class Builder {
        private String interconnectAttachment;
        private String project;
        private String region;

        public String getInterconnectAttachment() {
            return this.interconnectAttachment;
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setInterconnectAttachment(String interconnectAttachment) {
            this.interconnectAttachment = interconnectAttachment;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionInterconnectAttachmentName projectRegionInterconnectAttachmentName) {
            this.interconnectAttachment = projectRegionInterconnectAttachmentName.interconnectAttachment;
            this.project = projectRegionInterconnectAttachmentName.project;
            this.region = projectRegionInterconnectAttachmentName.region;
        }

        public ProjectRegionInterconnectAttachmentName build() {
            return new ProjectRegionInterconnectAttachmentName(this);
        }
    }
}

