/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListAutoscalersHttpRequest;
import com.google.cloud.compute.v1.Autoscaler;
import com.google.cloud.compute.v1.AutoscalerAggregatedList;
import com.google.cloud.compute.v1.AutoscalerList;
import com.google.cloud.compute.v1.AutoscalerSettings;
import com.google.cloud.compute.v1.AutoscalersScopedList;
import com.google.cloud.compute.v1.DeleteAutoscalerHttpRequest;
import com.google.cloud.compute.v1.GetAutoscalerHttpRequest;
import com.google.cloud.compute.v1.InsertAutoscalerHttpRequest;
import com.google.cloud.compute.v1.ListAutoscalersHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchAutoscalerHttpRequest;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneAutoscalerName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.UpdateAutoscalerHttpRequest;
import com.google.cloud.compute.v1.stub.AutoscalerStub;
import com.google.cloud.compute.v1.stub.AutoscalerStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AutoscalerClient
implements BackgroundResource {
    private final AutoscalerSettings settings;
    private final AutoscalerStub stub;

    public static final AutoscalerClient create() throws IOException {
        return AutoscalerClient.create(AutoscalerSettings.newBuilder().build());
    }

    public static final AutoscalerClient create(AutoscalerSettings settings) throws IOException {
        return new AutoscalerClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AutoscalerClient create(AutoscalerStub stub) {
        return new AutoscalerClient(stub);
    }

    protected AutoscalerClient(AutoscalerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AutoscalerStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AutoscalerClient(AutoscalerStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AutoscalerSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AutoscalerStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListAutoscalersPagedResponse aggregatedListAutoscalers(ProjectName project) {
        AggregatedListAutoscalersHttpRequest request = AggregatedListAutoscalersHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListAutoscalers(request);
    }

    @BetaApi
    public final AggregatedListAutoscalersPagedResponse aggregatedListAutoscalers(String project) {
        AggregatedListAutoscalersHttpRequest request = AggregatedListAutoscalersHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListAutoscalers(request);
    }

    @BetaApi
    public final AggregatedListAutoscalersPagedResponse aggregatedListAutoscalers(AggregatedListAutoscalersHttpRequest request) {
        return (AggregatedListAutoscalersPagedResponse)((Object)this.aggregatedListAutoscalersPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListAutoscalersHttpRequest, AggregatedListAutoscalersPagedResponse> aggregatedListAutoscalersPagedCallable() {
        return this.stub.aggregatedListAutoscalersPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList> aggregatedListAutoscalersCallable() {
        return this.stub.aggregatedListAutoscalersCallable();
    }

    @BetaApi
    public final Operation deleteAutoscaler(ProjectZoneAutoscalerName autoscaler) {
        DeleteAutoscalerHttpRequest request = DeleteAutoscalerHttpRequest.newBuilder().setAutoscaler(autoscaler == null ? null : autoscaler.toString()).build();
        return this.deleteAutoscaler(request);
    }

    @BetaApi
    public final Operation deleteAutoscaler(String autoscaler) {
        DeleteAutoscalerHttpRequest request = DeleteAutoscalerHttpRequest.newBuilder().setAutoscaler(autoscaler).build();
        return this.deleteAutoscaler(request);
    }

    @BetaApi
    public final Operation deleteAutoscaler(DeleteAutoscalerHttpRequest request) {
        return (Operation)this.deleteAutoscalerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteAutoscalerHttpRequest, Operation> deleteAutoscalerCallable() {
        return this.stub.deleteAutoscalerCallable();
    }

    @BetaApi
    public final Autoscaler getAutoscaler(ProjectZoneAutoscalerName autoscaler) {
        GetAutoscalerHttpRequest request = GetAutoscalerHttpRequest.newBuilder().setAutoscaler(autoscaler == null ? null : autoscaler.toString()).build();
        return this.getAutoscaler(request);
    }

    @BetaApi
    public final Autoscaler getAutoscaler(String autoscaler) {
        GetAutoscalerHttpRequest request = GetAutoscalerHttpRequest.newBuilder().setAutoscaler(autoscaler).build();
        return this.getAutoscaler(request);
    }

    @BetaApi
    public final Autoscaler getAutoscaler(GetAutoscalerHttpRequest request) {
        return (Autoscaler)this.getAutoscalerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetAutoscalerHttpRequest, Autoscaler> getAutoscalerCallable() {
        return this.stub.getAutoscalerCallable();
    }

    @BetaApi
    public final Operation insertAutoscaler(ProjectZoneName zone, Autoscaler autoscalerResource) {
        InsertAutoscalerHttpRequest request = InsertAutoscalerHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).setAutoscalerResource(autoscalerResource).build();
        return this.insertAutoscaler(request);
    }

    @BetaApi
    public final Operation insertAutoscaler(String zone, Autoscaler autoscalerResource) {
        InsertAutoscalerHttpRequest request = InsertAutoscalerHttpRequest.newBuilder().setZone(zone).setAutoscalerResource(autoscalerResource).build();
        return this.insertAutoscaler(request);
    }

    @BetaApi
    public final Operation insertAutoscaler(InsertAutoscalerHttpRequest request) {
        return (Operation)this.insertAutoscalerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertAutoscalerHttpRequest, Operation> insertAutoscalerCallable() {
        return this.stub.insertAutoscalerCallable();
    }

    @BetaApi
    public final ListAutoscalersPagedResponse listAutoscalers(ProjectZoneName zone) {
        ListAutoscalersHttpRequest request = ListAutoscalersHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).build();
        return this.listAutoscalers(request);
    }

    @BetaApi
    public final ListAutoscalersPagedResponse listAutoscalers(String zone) {
        ListAutoscalersHttpRequest request = ListAutoscalersHttpRequest.newBuilder().setZone(zone).build();
        return this.listAutoscalers(request);
    }

    @BetaApi
    public final ListAutoscalersPagedResponse listAutoscalers(ListAutoscalersHttpRequest request) {
        return (ListAutoscalersPagedResponse)((Object)this.listAutoscalersPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListAutoscalersHttpRequest, ListAutoscalersPagedResponse> listAutoscalersPagedCallable() {
        return this.stub.listAutoscalersPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListAutoscalersHttpRequest, AutoscalerList> listAutoscalersCallable() {
        return this.stub.listAutoscalersCallable();
    }

    @BetaApi
    public final Operation patchAutoscaler(String autoscaler, ProjectZoneName zone, Autoscaler autoscalerResource, List<String> fieldMask) {
        PatchAutoscalerHttpRequest request = PatchAutoscalerHttpRequest.newBuilder().setAutoscaler(autoscaler).setZone(zone == null ? null : zone.toString()).setAutoscalerResource(autoscalerResource).addAllFieldMask(fieldMask).build();
        return this.patchAutoscaler(request);
    }

    @BetaApi
    public final Operation patchAutoscaler(String autoscaler, String zone, Autoscaler autoscalerResource, List<String> fieldMask) {
        PatchAutoscalerHttpRequest request = PatchAutoscalerHttpRequest.newBuilder().setAutoscaler(autoscaler).setZone(zone).setAutoscalerResource(autoscalerResource).addAllFieldMask(fieldMask).build();
        return this.patchAutoscaler(request);
    }

    @BetaApi
    public final Operation patchAutoscaler(PatchAutoscalerHttpRequest request) {
        return (Operation)this.patchAutoscalerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchAutoscalerHttpRequest, Operation> patchAutoscalerCallable() {
        return this.stub.patchAutoscalerCallable();
    }

    @BetaApi
    public final Operation updateAutoscaler(String autoscaler, ProjectZoneName zone, Autoscaler autoscalerResource, List<String> fieldMask) {
        UpdateAutoscalerHttpRequest request = UpdateAutoscalerHttpRequest.newBuilder().setAutoscaler(autoscaler).setZone(zone == null ? null : zone.toString()).setAutoscalerResource(autoscalerResource).addAllFieldMask(fieldMask).build();
        return this.updateAutoscaler(request);
    }

    @BetaApi
    public final Operation updateAutoscaler(String autoscaler, String zone, Autoscaler autoscalerResource, List<String> fieldMask) {
        UpdateAutoscalerHttpRequest request = UpdateAutoscalerHttpRequest.newBuilder().setAutoscaler(autoscaler).setZone(zone).setAutoscalerResource(autoscalerResource).addAllFieldMask(fieldMask).build();
        return this.updateAutoscaler(request);
    }

    @BetaApi
    public final Operation updateAutoscaler(UpdateAutoscalerHttpRequest request) {
        return (Operation)this.updateAutoscalerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<UpdateAutoscalerHttpRequest, Operation> updateAutoscalerCallable() {
        return this.stub.updateAutoscalerCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAutoscalersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAutoscalersHttpRequest, AutoscalerList, Autoscaler, ListAutoscalersPage, ListAutoscalersFixedSizeCollection> {
        private ListAutoscalersFixedSizeCollection(List<ListAutoscalersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAutoscalersFixedSizeCollection createEmptyCollection() {
            return new ListAutoscalersFixedSizeCollection(null, 0);
        }

        protected ListAutoscalersFixedSizeCollection createCollection(List<ListAutoscalersPage> pages, int collectionSize) {
            return new ListAutoscalersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAutoscalersPage
    extends AbstractPage<ListAutoscalersHttpRequest, AutoscalerList, Autoscaler, ListAutoscalersPage> {
        private ListAutoscalersPage(PageContext<ListAutoscalersHttpRequest, AutoscalerList, Autoscaler> context, AutoscalerList response) {
            super(context, (Object)response);
        }

        private static ListAutoscalersPage createEmptyPage() {
            return new ListAutoscalersPage(null, null);
        }

        protected ListAutoscalersPage createPage(PageContext<ListAutoscalersHttpRequest, AutoscalerList, Autoscaler> context, AutoscalerList response) {
            return new ListAutoscalersPage(context, response);
        }

        public ApiFuture<ListAutoscalersPage> createPageAsync(PageContext<ListAutoscalersHttpRequest, AutoscalerList, Autoscaler> context, ApiFuture<AutoscalerList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAutoscalersPagedResponse
    extends AbstractPagedListResponse<ListAutoscalersHttpRequest, AutoscalerList, Autoscaler, ListAutoscalersPage, ListAutoscalersFixedSizeCollection> {
        public static ApiFuture<ListAutoscalersPagedResponse> createAsync(PageContext<ListAutoscalersHttpRequest, AutoscalerList, Autoscaler> context, ApiFuture<AutoscalerList> futureResponse) {
            ApiFuture<ListAutoscalersPage> futurePage = ListAutoscalersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListAutoscalersPage, ListAutoscalersPagedResponse>(){

                public ListAutoscalersPagedResponse apply(ListAutoscalersPage input) {
                    return new ListAutoscalersPagedResponse(input);
                }
            });
        }

        private ListAutoscalersPagedResponse(ListAutoscalersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAutoscalersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListAutoscalersFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList, AutoscalersScopedList, AggregatedListAutoscalersPage, AggregatedListAutoscalersFixedSizeCollection> {
        private AggregatedListAutoscalersFixedSizeCollection(List<AggregatedListAutoscalersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListAutoscalersFixedSizeCollection createEmptyCollection() {
            return new AggregatedListAutoscalersFixedSizeCollection(null, 0);
        }

        protected AggregatedListAutoscalersFixedSizeCollection createCollection(List<AggregatedListAutoscalersPage> pages, int collectionSize) {
            return new AggregatedListAutoscalersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListAutoscalersPage
    extends AbstractPage<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList, AutoscalersScopedList, AggregatedListAutoscalersPage> {
        private AggregatedListAutoscalersPage(PageContext<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList, AutoscalersScopedList> context, AutoscalerAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListAutoscalersPage createEmptyPage() {
            return new AggregatedListAutoscalersPage(null, null);
        }

        protected AggregatedListAutoscalersPage createPage(PageContext<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList, AutoscalersScopedList> context, AutoscalerAggregatedList response) {
            return new AggregatedListAutoscalersPage(context, response);
        }

        public ApiFuture<AggregatedListAutoscalersPage> createPageAsync(PageContext<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList, AutoscalersScopedList> context, ApiFuture<AutoscalerAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListAutoscalersPagedResponse
    extends AbstractPagedListResponse<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList, AutoscalersScopedList, AggregatedListAutoscalersPage, AggregatedListAutoscalersFixedSizeCollection> {
        public static ApiFuture<AggregatedListAutoscalersPagedResponse> createAsync(PageContext<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList, AutoscalersScopedList> context, ApiFuture<AutoscalerAggregatedList> futureResponse) {
            ApiFuture<AggregatedListAutoscalersPage> futurePage = AggregatedListAutoscalersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListAutoscalersPage, AggregatedListAutoscalersPagedResponse>(){

                public AggregatedListAutoscalersPagedResponse apply(AggregatedListAutoscalersPage input) {
                    return new AggregatedListAutoscalersPagedResponse(input);
                }
            });
        }

        private AggregatedListAutoscalersPagedResponse(AggregatedListAutoscalersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListAutoscalersFixedSizeCollection.createEmptyCollection());
        }
    }
}

