/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.AuditConfig;
import com.google.cloud.compute.v1.Binding;
import com.google.cloud.compute.v1.Rule;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Policy
implements ApiMessage {
    private final List<AuditConfig> auditConfigs;
    private final List<Binding> bindings;
    private final String etag;
    private final Boolean iamOwned;
    private final List<Rule> rules;
    private final Integer version;
    private static final Policy DEFAULT_INSTANCE = new Policy();

    private Policy() {
        this.auditConfigs = null;
        this.bindings = null;
        this.etag = null;
        this.iamOwned = null;
        this.rules = null;
        this.version = null;
    }

    private Policy(List<AuditConfig> auditConfigs, List<Binding> bindings, String etag, Boolean iamOwned, List<Rule> rules, Integer version) {
        this.auditConfigs = auditConfigs;
        this.bindings = bindings;
        this.etag = etag;
        this.iamOwned = iamOwned;
        this.rules = rules;
        this.version = version;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("auditConfigs")) {
            return this.auditConfigs;
        }
        if (fieldName.equals("bindings")) {
            return this.bindings;
        }
        if (fieldName.equals("etag")) {
            return this.etag;
        }
        if (fieldName.equals("iamOwned")) {
            return this.iamOwned;
        }
        if (fieldName.equals("rules")) {
            return this.rules;
        }
        if (fieldName.equals("version")) {
            return this.version;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<AuditConfig> getAuditConfigsList() {
        return this.auditConfigs;
    }

    public List<Binding> getBindingsList() {
        return this.bindings;
    }

    public String getEtag() {
        return this.etag;
    }

    public Boolean getIamOwned() {
        return this.iamOwned;
    }

    public List<Rule> getRulesList() {
        return this.rules;
    }

    public Integer getVersion() {
        return this.version;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Policy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Policy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Policy{auditConfigs=" + this.auditConfigs + ", bindings=" + this.bindings + ", etag=" + this.etag + ", iamOwned=" + this.iamOwned + ", rules=" + this.rules + ", version=" + this.version + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Policy) {
            Policy that = (Policy)o;
            return Objects.equals(this.auditConfigs, that.getAuditConfigsList()) && Objects.equals(this.bindings, that.getBindingsList()) && Objects.equals(this.etag, that.getEtag()) && Objects.equals(this.iamOwned, that.getIamOwned()) && Objects.equals(this.rules, that.getRulesList()) && Objects.equals(this.version, that.getVersion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.auditConfigs, this.bindings, this.etag, this.iamOwned, this.rules, this.version);
    }

    public static class Builder {
        private List<AuditConfig> auditConfigs;
        private List<Binding> bindings;
        private String etag;
        private Boolean iamOwned;
        private List<Rule> rules;
        private Integer version;

        Builder() {
        }

        public Builder mergeFrom(Policy other) {
            if (other == Policy.getDefaultInstance()) {
                return this;
            }
            if (other.getAuditConfigsList() != null) {
                this.auditConfigs = other.auditConfigs;
            }
            if (other.getBindingsList() != null) {
                this.bindings = other.bindings;
            }
            if (other.getEtag() != null) {
                this.etag = other.etag;
            }
            if (other.getIamOwned() != null) {
                this.iamOwned = other.iamOwned;
            }
            if (other.getRulesList() != null) {
                this.rules = other.rules;
            }
            if (other.getVersion() != null) {
                this.version = other.version;
            }
            return this;
        }

        Builder(Policy source) {
            this.auditConfigs = source.auditConfigs;
            this.bindings = source.bindings;
            this.etag = source.etag;
            this.iamOwned = source.iamOwned;
            this.rules = source.rules;
            this.version = source.version;
        }

        public List<AuditConfig> getAuditConfigsList() {
            return this.auditConfigs;
        }

        public Builder addAllAuditConfigs(List<AuditConfig> auditConfigs) {
            if (this.auditConfigs == null) {
                this.auditConfigs = new LinkedList<AuditConfig>();
            }
            this.auditConfigs.addAll(auditConfigs);
            return this;
        }

        public Builder addAuditConfigs(AuditConfig auditConfigs) {
            if (this.auditConfigs == null) {
                this.auditConfigs = new LinkedList<AuditConfig>();
            }
            this.auditConfigs.add(auditConfigs);
            return this;
        }

        public List<Binding> getBindingsList() {
            return this.bindings;
        }

        public Builder addAllBindings(List<Binding> bindings) {
            if (this.bindings == null) {
                this.bindings = new LinkedList<Binding>();
            }
            this.bindings.addAll(bindings);
            return this;
        }

        public Builder addBindings(Binding bindings) {
            if (this.bindings == null) {
                this.bindings = new LinkedList<Binding>();
            }
            this.bindings.add(bindings);
            return this;
        }

        public String getEtag() {
            return this.etag;
        }

        public Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        public Boolean getIamOwned() {
            return this.iamOwned;
        }

        public Builder setIamOwned(Boolean iamOwned) {
            this.iamOwned = iamOwned;
            return this;
        }

        public List<Rule> getRulesList() {
            return this.rules;
        }

        public Builder addAllRules(List<Rule> rules) {
            if (this.rules == null) {
                this.rules = new LinkedList<Rule>();
            }
            this.rules.addAll(rules);
            return this;
        }

        public Builder addRules(Rule rules) {
            if (this.rules == null) {
                this.rules = new LinkedList<Rule>();
            }
            this.rules.add(rules);
            return this;
        }

        public Integer getVersion() {
            return this.version;
        }

        public Builder setVersion(Integer version) {
            this.version = version;
            return this;
        }

        public Policy build() {
            return new Policy(this.auditConfigs, this.bindings, this.etag, this.iamOwned, this.rules, this.version);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllAuditConfigs(this.auditConfigs);
            newBuilder.addAllBindings(this.bindings);
            newBuilder.setEtag(this.etag);
            newBuilder.setIamOwned(this.iamOwned);
            newBuilder.addAllRules(this.rules);
            newBuilder.setVersion(this.version);
            return newBuilder;
        }
    }
}

