/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Warnings;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Route
implements ApiMessage {
    private final String creationTimestamp;
    private final String description;
    private final String destRange;
    private final String id;
    private final String kind;
    private final String name;
    private final String network;
    private final String nextHopGateway;
    private final String nextHopInstance;
    private final String nextHopIp;
    private final String nextHopNetwork;
    private final String nextHopPeering;
    private final String nextHopVpnTunnel;
    private final Integer priority;
    private final String selfLink;
    private final List<String> tags;
    private final List<Warnings> warnings;
    private static final Route DEFAULT_INSTANCE = new Route();

    private Route() {
        this.creationTimestamp = null;
        this.description = null;
        this.destRange = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.network = null;
        this.nextHopGateway = null;
        this.nextHopInstance = null;
        this.nextHopIp = null;
        this.nextHopNetwork = null;
        this.nextHopPeering = null;
        this.nextHopVpnTunnel = null;
        this.priority = null;
        this.selfLink = null;
        this.tags = null;
        this.warnings = null;
    }

    private Route(String creationTimestamp, String description, String destRange, String id, String kind, String name, String network, String nextHopGateway, String nextHopInstance, String nextHopIp, String nextHopNetwork, String nextHopPeering, String nextHopVpnTunnel, Integer priority, String selfLink, List<String> tags, List<Warnings> warnings) {
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.destRange = destRange;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.network = network;
        this.nextHopGateway = nextHopGateway;
        this.nextHopInstance = nextHopInstance;
        this.nextHopIp = nextHopIp;
        this.nextHopNetwork = nextHopNetwork;
        this.nextHopPeering = nextHopPeering;
        this.nextHopVpnTunnel = nextHopVpnTunnel;
        this.priority = priority;
        this.selfLink = selfLink;
        this.tags = tags;
        this.warnings = warnings;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("creationTimestamp")) {
            return this.creationTimestamp;
        }
        if (fieldName.equals("description")) {
            return this.description;
        }
        if (fieldName.equals("destRange")) {
            return this.destRange;
        }
        if (fieldName.equals("id")) {
            return this.id;
        }
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("network")) {
            return this.network;
        }
        if (fieldName.equals("nextHopGateway")) {
            return this.nextHopGateway;
        }
        if (fieldName.equals("nextHopInstance")) {
            return this.nextHopInstance;
        }
        if (fieldName.equals("nextHopIp")) {
            return this.nextHopIp;
        }
        if (fieldName.equals("nextHopNetwork")) {
            return this.nextHopNetwork;
        }
        if (fieldName.equals("nextHopPeering")) {
            return this.nextHopPeering;
        }
        if (fieldName.equals("nextHopVpnTunnel")) {
            return this.nextHopVpnTunnel;
        }
        if (fieldName.equals("priority")) {
            return this.priority;
        }
        if (fieldName.equals("selfLink")) {
            return this.selfLink;
        }
        if (fieldName.equals("tags")) {
            return this.tags;
        }
        if (fieldName.equals("warnings")) {
            return this.warnings;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDestRange() {
        return this.destRange;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getNextHopGateway() {
        return this.nextHopGateway;
    }

    public String getNextHopInstance() {
        return this.nextHopInstance;
    }

    public String getNextHopIp() {
        return this.nextHopIp;
    }

    public String getNextHopNetwork() {
        return this.nextHopNetwork;
    }

    public String getNextHopPeering() {
        return this.nextHopPeering;
    }

    public String getNextHopVpnTunnel() {
        return this.nextHopVpnTunnel;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public List<String> getTagsList() {
        return this.tags;
    }

    public List<Warnings> getWarningsList() {
        return this.warnings;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Route prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Route getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Route{creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", destRange=" + this.destRange + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", network=" + this.network + ", nextHopGateway=" + this.nextHopGateway + ", nextHopInstance=" + this.nextHopInstance + ", nextHopIp=" + this.nextHopIp + ", nextHopNetwork=" + this.nextHopNetwork + ", nextHopPeering=" + this.nextHopPeering + ", nextHopVpnTunnel=" + this.nextHopVpnTunnel + ", priority=" + this.priority + ", selfLink=" + this.selfLink + ", tags=" + this.tags + ", warnings=" + this.warnings + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Route) {
            Route that = (Route)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.destRange, that.getDestRange()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.network, that.getNetwork()) && Objects.equals(this.nextHopGateway, that.getNextHopGateway()) && Objects.equals(this.nextHopInstance, that.getNextHopInstance()) && Objects.equals(this.nextHopIp, that.getNextHopIp()) && Objects.equals(this.nextHopNetwork, that.getNextHopNetwork()) && Objects.equals(this.nextHopPeering, that.getNextHopPeering()) && Objects.equals(this.nextHopVpnTunnel, that.getNextHopVpnTunnel()) && Objects.equals(this.priority, that.getPriority()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.tags, that.getTagsList()) && Objects.equals(this.warnings, that.getWarningsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.description, this.destRange, this.id, this.kind, this.name, this.network, this.nextHopGateway, this.nextHopInstance, this.nextHopIp, this.nextHopNetwork, this.nextHopPeering, this.nextHopVpnTunnel, this.priority, this.selfLink, this.tags, this.warnings);
    }

    public static class Builder {
        private String creationTimestamp;
        private String description;
        private String destRange;
        private String id;
        private String kind;
        private String name;
        private String network;
        private String nextHopGateway;
        private String nextHopInstance;
        private String nextHopIp;
        private String nextHopNetwork;
        private String nextHopPeering;
        private String nextHopVpnTunnel;
        private Integer priority;
        private String selfLink;
        private List<String> tags;
        private List<Warnings> warnings;

        Builder() {
        }

        public Builder mergeFrom(Route other) {
            if (other == Route.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getDestRange() != null) {
                this.destRange = other.destRange;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNetwork() != null) {
                this.network = other.network;
            }
            if (other.getNextHopGateway() != null) {
                this.nextHopGateway = other.nextHopGateway;
            }
            if (other.getNextHopInstance() != null) {
                this.nextHopInstance = other.nextHopInstance;
            }
            if (other.getNextHopIp() != null) {
                this.nextHopIp = other.nextHopIp;
            }
            if (other.getNextHopNetwork() != null) {
                this.nextHopNetwork = other.nextHopNetwork;
            }
            if (other.getNextHopPeering() != null) {
                this.nextHopPeering = other.nextHopPeering;
            }
            if (other.getNextHopVpnTunnel() != null) {
                this.nextHopVpnTunnel = other.nextHopVpnTunnel;
            }
            if (other.getPriority() != null) {
                this.priority = other.priority;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getTagsList() != null) {
                this.tags = other.tags;
            }
            if (other.getWarningsList() != null) {
                this.warnings = other.warnings;
            }
            return this;
        }

        Builder(Route source) {
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.destRange = source.destRange;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.network = source.network;
            this.nextHopGateway = source.nextHopGateway;
            this.nextHopInstance = source.nextHopInstance;
            this.nextHopIp = source.nextHopIp;
            this.nextHopNetwork = source.nextHopNetwork;
            this.nextHopPeering = source.nextHopPeering;
            this.nextHopVpnTunnel = source.nextHopVpnTunnel;
            this.priority = source.priority;
            this.selfLink = source.selfLink;
            this.tags = source.tags;
            this.warnings = source.warnings;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getDestRange() {
            return this.destRange;
        }

        public Builder setDestRange(String destRange) {
            this.destRange = destRange;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getNetwork() {
            return this.network;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        public String getNextHopGateway() {
            return this.nextHopGateway;
        }

        public Builder setNextHopGateway(String nextHopGateway) {
            this.nextHopGateway = nextHopGateway;
            return this;
        }

        public String getNextHopInstance() {
            return this.nextHopInstance;
        }

        public Builder setNextHopInstance(String nextHopInstance) {
            this.nextHopInstance = nextHopInstance;
            return this;
        }

        public String getNextHopIp() {
            return this.nextHopIp;
        }

        public Builder setNextHopIp(String nextHopIp) {
            this.nextHopIp = nextHopIp;
            return this;
        }

        public String getNextHopNetwork() {
            return this.nextHopNetwork;
        }

        public Builder setNextHopNetwork(String nextHopNetwork) {
            this.nextHopNetwork = nextHopNetwork;
            return this;
        }

        public String getNextHopPeering() {
            return this.nextHopPeering;
        }

        public Builder setNextHopPeering(String nextHopPeering) {
            this.nextHopPeering = nextHopPeering;
            return this;
        }

        public String getNextHopVpnTunnel() {
            return this.nextHopVpnTunnel;
        }

        public Builder setNextHopVpnTunnel(String nextHopVpnTunnel) {
            this.nextHopVpnTunnel = nextHopVpnTunnel;
            return this;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public Builder setPriority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public List<String> getTagsList() {
            return this.tags;
        }

        public Builder addAllTags(List<String> tags) {
            if (this.tags == null) {
                this.tags = new LinkedList<String>();
            }
            this.tags.addAll(tags);
            return this;
        }

        public Builder addTags(String tags) {
            if (this.tags == null) {
                this.tags = new LinkedList<String>();
            }
            this.tags.add(tags);
            return this;
        }

        public List<Warnings> getWarningsList() {
            return this.warnings;
        }

        public Builder addAllWarnings(List<Warnings> warnings) {
            if (this.warnings == null) {
                this.warnings = new LinkedList<Warnings>();
            }
            this.warnings.addAll(warnings);
            return this;
        }

        public Builder addWarnings(Warnings warnings) {
            if (this.warnings == null) {
                this.warnings = new LinkedList<Warnings>();
            }
            this.warnings.add(warnings);
            return this;
        }

        public Route build() {
            return new Route(this.creationTimestamp, this.description, this.destRange, this.id, this.kind, this.name, this.network, this.nextHopGateway, this.nextHopInstance, this.nextHopIp, this.nextHopNetwork, this.nextHopPeering, this.nextHopVpnTunnel, this.priority, this.selfLink, this.tags, this.warnings);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setDestRange(this.destRange);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setNetwork(this.network);
            newBuilder.setNextHopGateway(this.nextHopGateway);
            newBuilder.setNextHopInstance(this.nextHopInstance);
            newBuilder.setNextHopIp(this.nextHopIp);
            newBuilder.setNextHopNetwork(this.nextHopNetwork);
            newBuilder.setNextHopPeering(this.nextHopPeering);
            newBuilder.setNextHopVpnTunnel(this.nextHopVpnTunnel);
            newBuilder.setPriority(this.priority);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.addAllTags(this.tags);
            newBuilder.addAllWarnings(this.warnings);
            return newBuilder;
        }
    }
}

