/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class AccessConfig
implements ApiMessage {
    private final String kind;
    private final String name;
    private final String natIP;
    private final String networkTier;
    private final String publicPtrDomainName;
    private final Boolean setPublicPtr;
    private final String type;
    private static final AccessConfig DEFAULT_INSTANCE = new AccessConfig();

    private AccessConfig() {
        this.kind = null;
        this.name = null;
        this.natIP = null;
        this.networkTier = null;
        this.publicPtrDomainName = null;
        this.setPublicPtr = null;
        this.type = null;
    }

    private AccessConfig(String kind, String name, String natIP, String networkTier, String publicPtrDomainName, Boolean setPublicPtr, String type) {
        this.kind = kind;
        this.name = name;
        this.natIP = natIP;
        this.networkTier = networkTier;
        this.publicPtrDomainName = publicPtrDomainName;
        this.setPublicPtr = setPublicPtr;
        this.type = type;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("natIP")) {
            return this.natIP;
        }
        if (fieldName.equals("networkTier")) {
            return this.networkTier;
        }
        if (fieldName.equals("publicPtrDomainName")) {
            return this.publicPtrDomainName;
        }
        if (fieldName.equals("setPublicPtr")) {
            return this.setPublicPtr;
        }
        if (fieldName.equals("type")) {
            return this.type;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getNatIP() {
        return this.natIP;
    }

    public String getNetworkTier() {
        return this.networkTier;
    }

    public String getPublicPtrDomainName() {
        return this.publicPtrDomainName;
    }

    public Boolean getSetPublicPtr() {
        return this.setPublicPtr;
    }

    public String getType() {
        return this.type;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AccessConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static AccessConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "AccessConfig{kind=" + this.kind + ", name=" + this.name + ", natIP=" + this.natIP + ", networkTier=" + this.networkTier + ", publicPtrDomainName=" + this.publicPtrDomainName + ", setPublicPtr=" + this.setPublicPtr + ", type=" + this.type + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AccessConfig) {
            AccessConfig that = (AccessConfig)o;
            return Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.natIP, that.getNatIP()) && Objects.equals(this.networkTier, that.getNetworkTier()) && Objects.equals(this.publicPtrDomainName, that.getPublicPtrDomainName()) && Objects.equals(this.setPublicPtr, that.getSetPublicPtr()) && Objects.equals(this.type, that.getType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.name, this.natIP, this.networkTier, this.publicPtrDomainName, this.setPublicPtr, this.type);
    }

    public static class Builder {
        private String kind;
        private String name;
        private String natIP;
        private String networkTier;
        private String publicPtrDomainName;
        private Boolean setPublicPtr;
        private String type;

        Builder() {
        }

        public Builder mergeFrom(AccessConfig other) {
            if (other == AccessConfig.getDefaultInstance()) {
                return this;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNatIP() != null) {
                this.natIP = other.natIP;
            }
            if (other.getNetworkTier() != null) {
                this.networkTier = other.networkTier;
            }
            if (other.getPublicPtrDomainName() != null) {
                this.publicPtrDomainName = other.publicPtrDomainName;
            }
            if (other.getSetPublicPtr() != null) {
                this.setPublicPtr = other.setPublicPtr;
            }
            if (other.getType() != null) {
                this.type = other.type;
            }
            return this;
        }

        Builder(AccessConfig source) {
            this.kind = source.kind;
            this.name = source.name;
            this.natIP = source.natIP;
            this.networkTier = source.networkTier;
            this.publicPtrDomainName = source.publicPtrDomainName;
            this.setPublicPtr = source.setPublicPtr;
            this.type = source.type;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getNatIP() {
            return this.natIP;
        }

        public Builder setNatIP(String natIP) {
            this.natIP = natIP;
            return this;
        }

        public String getNetworkTier() {
            return this.networkTier;
        }

        public Builder setNetworkTier(String networkTier) {
            this.networkTier = networkTier;
            return this;
        }

        public String getPublicPtrDomainName() {
            return this.publicPtrDomainName;
        }

        public Builder setPublicPtrDomainName(String publicPtrDomainName) {
            this.publicPtrDomainName = publicPtrDomainName;
            return this;
        }

        public Boolean getSetPublicPtr() {
            return this.setPublicPtr;
        }

        public Builder setSetPublicPtr(Boolean setPublicPtr) {
            this.setPublicPtr = setPublicPtr;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public AccessConfig build() {
            return new AccessConfig(this.kind, this.name, this.natIP, this.networkTier, this.publicPtrDomainName, this.setPublicPtr, this.type);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setNatIP(this.natIP);
            newBuilder.setNetworkTier(this.networkTier);
            newBuilder.setPublicPtrDomainName(this.publicPtrDomainName);
            newBuilder.setSetPublicPtr(this.setPublicPtr);
            newBuilder.setType(this.type);
            return newBuilder;
        }
    }
}

