/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Items;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Metadata
implements ApiMessage {
    private final String fingerprint;
    private final List<Items> items;
    private final String kind;
    private static final Metadata DEFAULT_INSTANCE = new Metadata();

    private Metadata() {
        this.fingerprint = null;
        this.items = null;
        this.kind = null;
    }

    private Metadata(String fingerprint, List<Items> items, String kind) {
        this.fingerprint = fingerprint;
        this.items = items;
        this.kind = kind;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("fingerprint")) {
            return this.fingerprint;
        }
        if (fieldName.equals("items")) {
            return this.items;
        }
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public List<Items> getItemsList() {
        return this.items;
    }

    public String getKind() {
        return this.kind;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Metadata prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Metadata getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Metadata{fingerprint=" + this.fingerprint + ", items=" + this.items + ", kind=" + this.kind + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Metadata) {
            Metadata that = (Metadata)o;
            return Objects.equals(this.fingerprint, that.getFingerprint()) && Objects.equals(this.items, that.getItemsList()) && Objects.equals(this.kind, that.getKind());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.fingerprint, this.items, this.kind);
    }

    public static class Builder {
        private String fingerprint;
        private List<Items> items;
        private String kind;

        Builder() {
        }

        public Builder mergeFrom(Metadata other) {
            if (other == Metadata.getDefaultInstance()) {
                return this;
            }
            if (other.getFingerprint() != null) {
                this.fingerprint = other.fingerprint;
            }
            if (other.getItemsList() != null) {
                this.items = other.items;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            return this;
        }

        Builder(Metadata source) {
            this.fingerprint = source.fingerprint;
            this.items = source.items;
            this.kind = source.kind;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public Builder setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public List<Items> getItemsList() {
            return this.items;
        }

        public Builder addAllItems(List<Items> items) {
            if (this.items == null) {
                this.items = new LinkedList<Items>();
            }
            this.items.addAll(items);
            return this;
        }

        public Builder addItems(Items items) {
            if (this.items == null) {
                this.items = new LinkedList<Items>();
            }
            this.items.add(items);
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public Metadata build() {
            return new Metadata(this.fingerprint, this.items, this.kind);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setFingerprint(this.fingerprint);
            newBuilder.addAllItems(this.items);
            newBuilder.setKind(this.kind);
            return newBuilder;
        }
    }
}

