/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.DeleteHealthCheckHttpRequest;
import com.google.cloud.compute.v1.GetHealthCheckHttpRequest;
import com.google.cloud.compute.v1.HealthCheck;
import com.google.cloud.compute.v1.HealthCheckClient;
import com.google.cloud.compute.v1.HealthCheckList;
import com.google.cloud.compute.v1.InsertHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ListHealthChecksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalHealthCheckName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.UpdateHealthCheckHttpRequest;
import com.google.cloud.compute.v1.stub.HealthCheckStub;
import com.google.cloud.compute.v1.stub.HealthCheckStubSettings;
import com.google.cloud.compute.v1.stub.HttpJsonHealthCheckCallableFactory;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonHealthCheckStub
extends HealthCheckStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteHealthCheckHttpRequest, Operation> deleteHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.healthChecks.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/healthChecks/{healthCheck}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalHealthCheckName.newFactory()).setResourceNameField("healthCheck").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetHealthCheckHttpRequest, HealthCheck> getHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.healthChecks.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/healthChecks/{healthCheck}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalHealthCheckName.newFactory()).setResourceNameField("healthCheck").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)HealthCheck.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertHealthCheckHttpRequest, Operation> insertHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.healthChecks.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/healthChecks")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListHealthChecksHttpRequest, HealthCheckList> listHealthChecksMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.healthChecks.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/healthChecks")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)HealthCheckList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<PatchHealthCheckHttpRequest, Operation> patchHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.healthChecks.patch").setHttpMethod("PATCH").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/healthChecks/{healthCheck}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalHealthCheckName.newFactory()).setResourceNameField("healthCheck").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<UpdateHealthCheckHttpRequest, Operation> updateHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.healthChecks.update").setHttpMethod("PUT").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/healthChecks/{healthCheck}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalHealthCheckName.newFactory()).setResourceNameField("healthCheck").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteHealthCheckHttpRequest, Operation> deleteHealthCheckCallable;
    private final UnaryCallable<GetHealthCheckHttpRequest, HealthCheck> getHealthCheckCallable;
    private final UnaryCallable<InsertHealthCheckHttpRequest, Operation> insertHealthCheckCallable;
    private final UnaryCallable<ListHealthChecksHttpRequest, HealthCheckList> listHealthChecksCallable;
    private final UnaryCallable<ListHealthChecksHttpRequest, HealthCheckClient.ListHealthChecksPagedResponse> listHealthChecksPagedCallable;
    private final UnaryCallable<PatchHealthCheckHttpRequest, Operation> patchHealthCheckCallable;
    private final UnaryCallable<UpdateHealthCheckHttpRequest, Operation> updateHealthCheckCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonHealthCheckStub create(HealthCheckStubSettings settings) throws IOException {
        return new HttpJsonHealthCheckStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonHealthCheckStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonHealthCheckStub(HealthCheckStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonHealthCheckStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonHealthCheckStub(HealthCheckStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonHealthCheckStub(HealthCheckStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonHealthCheckCallableFactory());
    }

    protected HttpJsonHealthCheckStub(HealthCheckStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteHealthCheckMethodDescriptor).build();
        HttpJsonCallSettings getHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getHealthCheckMethodDescriptor).build();
        HttpJsonCallSettings insertHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertHealthCheckMethodDescriptor).build();
        HttpJsonCallSettings listHealthChecksTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listHealthChecksMethodDescriptor).build();
        HttpJsonCallSettings patchHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchHealthCheckMethodDescriptor).build();
        HttpJsonCallSettings updateHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateHealthCheckMethodDescriptor).build();
        this.deleteHealthCheckCallable = callableFactory.createUnaryCallable(deleteHealthCheckTransportSettings, settings.deleteHealthCheckSettings(), clientContext);
        this.getHealthCheckCallable = callableFactory.createUnaryCallable(getHealthCheckTransportSettings, settings.getHealthCheckSettings(), clientContext);
        this.insertHealthCheckCallable = callableFactory.createUnaryCallable(insertHealthCheckTransportSettings, settings.insertHealthCheckSettings(), clientContext);
        this.listHealthChecksCallable = callableFactory.createUnaryCallable(listHealthChecksTransportSettings, settings.listHealthChecksSettings(), clientContext);
        this.listHealthChecksPagedCallable = callableFactory.createPagedCallable(listHealthChecksTransportSettings, settings.listHealthChecksSettings(), clientContext);
        this.patchHealthCheckCallable = callableFactory.createUnaryCallable(patchHealthCheckTransportSettings, settings.patchHealthCheckSettings(), clientContext);
        this.updateHealthCheckCallable = callableFactory.createUnaryCallable(updateHealthCheckTransportSettings, settings.updateHealthCheckSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteHealthCheckHttpRequest, Operation> deleteHealthCheckCallable() {
        return this.deleteHealthCheckCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetHealthCheckHttpRequest, HealthCheck> getHealthCheckCallable() {
        return this.getHealthCheckCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertHealthCheckHttpRequest, Operation> insertHealthCheckCallable() {
        return this.insertHealthCheckCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListHealthChecksHttpRequest, HealthCheckClient.ListHealthChecksPagedResponse> listHealthChecksPagedCallable() {
        return this.listHealthChecksPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListHealthChecksHttpRequest, HealthCheckList> listHealthChecksCallable() {
        return this.listHealthChecksCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<PatchHealthCheckHttpRequest, Operation> patchHealthCheckCallable() {
        return this.patchHealthCheckCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<UpdateHealthCheckHttpRequest, Operation> updateHealthCheckCallable() {
        return this.updateHealthCheckCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

