/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.api.services.compute.model.Image;
import com.google.cloud.compute.deprecated.DiskImageConfiguration;
import com.google.cloud.compute.deprecated.StorageImageConfiguration;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;

public abstract class ImageConfiguration
implements Serializable {
    private static final long serialVersionUID = -9154332316597745316L;
    private final Type type;
    private final SourceType sourceType;
    private final Long archiveSizeBytes;

    ImageConfiguration(Builder builder) {
        this.type = builder.type;
        this.sourceType = builder.sourceType;
        this.archiveSizeBytes = builder.archiveSizeBytes;
    }

    public Type getType() {
        return this.type;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public Long getArchiveSizeBytes() {
        return this.archiveSizeBytes;
    }

    public abstract Builder toBuilder();

    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("sourceType", (Object)this.sourceType).add("archiveSizeBytes", (Object)this.archiveSizeBytes);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    final int baseHashCode() {
        return Objects.hash(new Object[]{this.type, this.sourceType, this.archiveSizeBytes});
    }

    final boolean baseEquals(ImageConfiguration imageConfiguration) {
        return imageConfiguration != null && this.getClass().equals(imageConfiguration.getClass()) && Objects.equals(this.toPb(), imageConfiguration.toPb());
    }

    abstract ImageConfiguration setProjectId(String var1);

    Image toPb() {
        Image imagePb = new Image();
        if (this.sourceType != null) {
            imagePb.setSourceType(this.sourceType.name());
        }
        imagePb.setArchiveSizeBytes(this.archiveSizeBytes);
        return imagePb;
    }

    static <T extends ImageConfiguration> T fromPb(Image imagePb) {
        if (imagePb.getSourceDisk() != null) {
            return (T)DiskImageConfiguration.fromPb(imagePb);
        }
        return (T)StorageImageConfiguration.fromPb(imagePb);
    }

    public static abstract class Builder<T extends ImageConfiguration, B extends Builder<T, B>> {
        private Type type;
        private SourceType sourceType;
        private Long archiveSizeBytes;

        Builder(Type type) {
            this.type = type;
        }

        Builder(ImageConfiguration imageConfiguration) {
            this.type = imageConfiguration.type;
            this.sourceType = imageConfiguration.sourceType;
            this.archiveSizeBytes = imageConfiguration.archiveSizeBytes;
        }

        Builder(Type type, Image imagePb) {
            this.type = type;
            if (imagePb.getSourceType() != null) {
                this.sourceType = SourceType.valueOf(imagePb.getSourceType());
            }
            this.archiveSizeBytes = imagePb.getArchiveSizeBytes();
        }

        B self() {
            return (B)this;
        }

        B setType(Type type) {
            this.type = type;
            return this.self();
        }

        B setSourceType(SourceType sourceType) {
            this.sourceType = sourceType;
            return this.self();
        }

        B setArchiveSizeBytes(Long archiveSizeBytes) {
            this.archiveSizeBytes = archiveSizeBytes;
            return this.self();
        }

        public abstract T build();
    }

    public static enum SourceType {
        RAW;

    }

    public static enum Type {
        DISK,
        STORAGE;

    }
}

