/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.RegionId;
import com.google.cloud.compute.ResourceId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SubnetworkId
extends ResourceId {
    static final Function<String, SubnetworkId> FROM_URL_FUNCTION = new Function<String, SubnetworkId>(){

        public SubnetworkId apply(String pb) {
            return SubnetworkId.fromUrl(pb);
        }
    };
    static final Function<SubnetworkId, String> TO_URL_FUNCTION = new Function<SubnetworkId, String>(){

        public String apply(SubnetworkId zoneId) {
            return zoneId.getSelfLink();
        }
    };
    private static final String REGEX = ".*?projects/([^/]+)/regions/([^/]+)/subnetworks/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/regions/([^/]+)/subnetworks/([^/]+)");
    private static final long serialVersionUID = -5451054513760540282L;
    private final String region;
    private final String subnetwork;

    private SubnetworkId(String project, String region, String subnetwork) {
        super(project);
        this.region = (String)Preconditions.checkNotNull((Object)region);
        this.subnetwork = (String)Preconditions.checkNotNull((Object)subnetwork);
    }

    @Deprecated
    public String region() {
        return this.getRegion();
    }

    public String getRegion() {
        return this.region;
    }

    @Deprecated
    public RegionId regionId() {
        return this.getRegionId();
    }

    public RegionId getRegionId() {
        return RegionId.of(this.getProject(), this.region);
    }

    @Deprecated
    public String subnetwork() {
        return this.getSubnetwork();
    }

    public String getSubnetwork() {
        return this.subnetwork;
    }

    @Override
    @Deprecated
    public String selfLink() {
        return this.getSelfLink();
    }

    @Override
    public String getSelfLink() {
        return super.getSelfLink() + "/regions/" + this.region + "/subnetworks/" + this.subnetwork;
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("region", (Object)this.region).add("subnetwork", (Object)this.subnetwork);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.region, this.subnetwork);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SubnetworkId)) {
            return false;
        }
        SubnetworkId other = (SubnetworkId)obj;
        return this.baseEquals(other) && Objects.equals(this.region, other.region) && Objects.equals(this.subnetwork, other.subnetwork);
    }

    @Override
    SubnetworkId setProjectId(String projectId) {
        if (this.getProject() != null) {
            return this;
        }
        return SubnetworkId.of(projectId, this.getRegion(), this.subnetwork);
    }

    public static SubnetworkId of(RegionId regionId, String subnetwork) {
        return new SubnetworkId(regionId.getProject(), regionId.getRegion(), subnetwork);
    }

    public static SubnetworkId of(String region, String subnetwork) {
        return new SubnetworkId(null, region, subnetwork);
    }

    public static SubnetworkId of(String project, String region, String subnetwork) {
        return new SubnetworkId(project, region, subnetwork);
    }

    static boolean matchesUrl(String url) {
        return PATTERN.matcher(url).matches();
    }

    static SubnetworkId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(url + " is not a valid subnetwork URL");
        }
        return SubnetworkId.of(matcher.group(1), matcher.group(2), matcher.group(3));
    }
}

