/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListSubnetworksHttpRequest;
import com.google.cloud.compute.v1.DeleteSubnetworkHttpRequest;
import com.google.cloud.compute.v1.ExpandIpCidrRangeSubnetworkHttpRequest;
import com.google.cloud.compute.v1.GetSubnetworkHttpRequest;
import com.google.cloud.compute.v1.InsertSubnetworkHttpRequest;
import com.google.cloud.compute.v1.ListSubnetworksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchSubnetworkHttpRequest;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionSubnetworkName;
import com.google.cloud.compute.v1.SetPrivateIpGoogleAccessSubnetworkHttpRequest;
import com.google.cloud.compute.v1.Subnetwork;
import com.google.cloud.compute.v1.SubnetworkAggregatedList;
import com.google.cloud.compute.v1.SubnetworkList;
import com.google.cloud.compute.v1.SubnetworkSettings;
import com.google.cloud.compute.v1.SubnetworksExpandIpCidrRangeRequest;
import com.google.cloud.compute.v1.SubnetworksScopedList;
import com.google.cloud.compute.v1.SubnetworksSetPrivateIpGoogleAccessRequest;
import com.google.cloud.compute.v1.stub.SubnetworkStub;
import com.google.cloud.compute.v1.stub.SubnetworkStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SubnetworkClient
implements BackgroundResource {
    private final SubnetworkSettings settings;
    private final SubnetworkStub stub;

    public static final SubnetworkClient create() throws IOException {
        return SubnetworkClient.create(SubnetworkSettings.newBuilder().build());
    }

    public static final SubnetworkClient create(SubnetworkSettings settings) throws IOException {
        return new SubnetworkClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SubnetworkClient create(SubnetworkStub stub) {
        return new SubnetworkClient(stub);
    }

    protected SubnetworkClient(SubnetworkSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SubnetworkStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SubnetworkClient(SubnetworkStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SubnetworkSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SubnetworkStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListSubnetworksPagedResponse aggregatedListSubnetworks(ProjectName project) {
        AggregatedListSubnetworksHttpRequest request = AggregatedListSubnetworksHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListSubnetworks(request);
    }

    @BetaApi
    public final AggregatedListSubnetworksPagedResponse aggregatedListSubnetworks(String project) {
        AggregatedListSubnetworksHttpRequest request = AggregatedListSubnetworksHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListSubnetworks(request);
    }

    @BetaApi
    public final AggregatedListSubnetworksPagedResponse aggregatedListSubnetworks(AggregatedListSubnetworksHttpRequest request) {
        return (AggregatedListSubnetworksPagedResponse)((Object)this.aggregatedListSubnetworksPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListSubnetworksHttpRequest, AggregatedListSubnetworksPagedResponse> aggregatedListSubnetworksPagedCallable() {
        return this.stub.aggregatedListSubnetworksPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList> aggregatedListSubnetworksCallable() {
        return this.stub.aggregatedListSubnetworksCallable();
    }

    @BetaApi
    public final Operation deleteSubnetwork(ProjectRegionSubnetworkName subnetwork) {
        DeleteSubnetworkHttpRequest request = DeleteSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork == null ? null : subnetwork.toString()).build();
        return this.deleteSubnetwork(request);
    }

    @BetaApi
    public final Operation deleteSubnetwork(String subnetwork) {
        DeleteSubnetworkHttpRequest request = DeleteSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork).build();
        return this.deleteSubnetwork(request);
    }

    @BetaApi
    public final Operation deleteSubnetwork(DeleteSubnetworkHttpRequest request) {
        return (Operation)this.deleteSubnetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteSubnetworkHttpRequest, Operation> deleteSubnetworkCallable() {
        return this.stub.deleteSubnetworkCallable();
    }

    @BetaApi
    public final Operation expandIpCidrRangeSubnetwork(ProjectRegionSubnetworkName subnetwork, SubnetworksExpandIpCidrRangeRequest subnetworksExpandIpCidrRangeRequestResource) {
        ExpandIpCidrRangeSubnetworkHttpRequest request = ExpandIpCidrRangeSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork == null ? null : subnetwork.toString()).setSubnetworksExpandIpCidrRangeRequestResource(subnetworksExpandIpCidrRangeRequestResource).build();
        return this.expandIpCidrRangeSubnetwork(request);
    }

    @BetaApi
    public final Operation expandIpCidrRangeSubnetwork(String subnetwork, SubnetworksExpandIpCidrRangeRequest subnetworksExpandIpCidrRangeRequestResource) {
        ExpandIpCidrRangeSubnetworkHttpRequest request = ExpandIpCidrRangeSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork).setSubnetworksExpandIpCidrRangeRequestResource(subnetworksExpandIpCidrRangeRequestResource).build();
        return this.expandIpCidrRangeSubnetwork(request);
    }

    @BetaApi
    public final Operation expandIpCidrRangeSubnetwork(ExpandIpCidrRangeSubnetworkHttpRequest request) {
        return (Operation)this.expandIpCidrRangeSubnetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<ExpandIpCidrRangeSubnetworkHttpRequest, Operation> expandIpCidrRangeSubnetworkCallable() {
        return this.stub.expandIpCidrRangeSubnetworkCallable();
    }

    @BetaApi
    public final Subnetwork getSubnetwork(ProjectRegionSubnetworkName subnetwork) {
        GetSubnetworkHttpRequest request = GetSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork == null ? null : subnetwork.toString()).build();
        return this.getSubnetwork(request);
    }

    @BetaApi
    public final Subnetwork getSubnetwork(String subnetwork) {
        GetSubnetworkHttpRequest request = GetSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork).build();
        return this.getSubnetwork(request);
    }

    @BetaApi
    public final Subnetwork getSubnetwork(GetSubnetworkHttpRequest request) {
        return (Subnetwork)this.getSubnetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetSubnetworkHttpRequest, Subnetwork> getSubnetworkCallable() {
        return this.stub.getSubnetworkCallable();
    }

    @BetaApi
    public final Operation insertSubnetwork(ProjectRegionName region, Subnetwork subnetworkResource) {
        InsertSubnetworkHttpRequest request = InsertSubnetworkHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setSubnetworkResource(subnetworkResource).build();
        return this.insertSubnetwork(request);
    }

    @BetaApi
    public final Operation insertSubnetwork(String region, Subnetwork subnetworkResource) {
        InsertSubnetworkHttpRequest request = InsertSubnetworkHttpRequest.newBuilder().setRegion(region).setSubnetworkResource(subnetworkResource).build();
        return this.insertSubnetwork(request);
    }

    @BetaApi
    public final Operation insertSubnetwork(InsertSubnetworkHttpRequest request) {
        return (Operation)this.insertSubnetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertSubnetworkHttpRequest, Operation> insertSubnetworkCallable() {
        return this.stub.insertSubnetworkCallable();
    }

    @BetaApi
    public final ListSubnetworksPagedResponse listSubnetworks(ProjectRegionName region) {
        ListSubnetworksHttpRequest request = ListSubnetworksHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listSubnetworks(request);
    }

    @BetaApi
    public final ListSubnetworksPagedResponse listSubnetworks(String region) {
        ListSubnetworksHttpRequest request = ListSubnetworksHttpRequest.newBuilder().setRegion(region).build();
        return this.listSubnetworks(request);
    }

    @BetaApi
    public final ListSubnetworksPagedResponse listSubnetworks(ListSubnetworksHttpRequest request) {
        return (ListSubnetworksPagedResponse)((Object)this.listSubnetworksPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListSubnetworksHttpRequest, ListSubnetworksPagedResponse> listSubnetworksPagedCallable() {
        return this.stub.listSubnetworksPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListSubnetworksHttpRequest, SubnetworkList> listSubnetworksCallable() {
        return this.stub.listSubnetworksCallable();
    }

    @BetaApi
    public final Operation patchSubnetwork(ProjectRegionSubnetworkName subnetwork, Subnetwork subnetworkResource) {
        PatchSubnetworkHttpRequest request = PatchSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork == null ? null : subnetwork.toString()).setSubnetworkResource(subnetworkResource).build();
        return this.patchSubnetwork(request);
    }

    @BetaApi
    public final Operation patchSubnetwork(String subnetwork, Subnetwork subnetworkResource) {
        PatchSubnetworkHttpRequest request = PatchSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork).setSubnetworkResource(subnetworkResource).build();
        return this.patchSubnetwork(request);
    }

    @BetaApi
    public final Operation patchSubnetwork(PatchSubnetworkHttpRequest request) {
        return (Operation)this.patchSubnetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchSubnetworkHttpRequest, Operation> patchSubnetworkCallable() {
        return this.stub.patchSubnetworkCallable();
    }

    @BetaApi
    public final Operation setPrivateIpGoogleAccessSubnetwork(ProjectRegionSubnetworkName subnetwork, SubnetworksSetPrivateIpGoogleAccessRequest subnetworksSetPrivateIpGoogleAccessRequestResource) {
        SetPrivateIpGoogleAccessSubnetworkHttpRequest request = SetPrivateIpGoogleAccessSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork == null ? null : subnetwork.toString()).setSubnetworksSetPrivateIpGoogleAccessRequestResource(subnetworksSetPrivateIpGoogleAccessRequestResource).build();
        return this.setPrivateIpGoogleAccessSubnetwork(request);
    }

    @BetaApi
    public final Operation setPrivateIpGoogleAccessSubnetwork(String subnetwork, SubnetworksSetPrivateIpGoogleAccessRequest subnetworksSetPrivateIpGoogleAccessRequestResource) {
        SetPrivateIpGoogleAccessSubnetworkHttpRequest request = SetPrivateIpGoogleAccessSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork).setSubnetworksSetPrivateIpGoogleAccessRequestResource(subnetworksSetPrivateIpGoogleAccessRequestResource).build();
        return this.setPrivateIpGoogleAccessSubnetwork(request);
    }

    @BetaApi
    public final Operation setPrivateIpGoogleAccessSubnetwork(SetPrivateIpGoogleAccessSubnetworkHttpRequest request) {
        return (Operation)this.setPrivateIpGoogleAccessSubnetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetPrivateIpGoogleAccessSubnetworkHttpRequest, Operation> setPrivateIpGoogleAccessSubnetworkCallable() {
        return this.stub.setPrivateIpGoogleAccessSubnetworkCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSubnetworksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSubnetworksHttpRequest, SubnetworkList, Subnetwork, ListSubnetworksPage, ListSubnetworksFixedSizeCollection> {
        private ListSubnetworksFixedSizeCollection(List<ListSubnetworksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSubnetworksFixedSizeCollection createEmptyCollection() {
            return new ListSubnetworksFixedSizeCollection(null, 0);
        }

        protected ListSubnetworksFixedSizeCollection createCollection(List<ListSubnetworksPage> pages, int collectionSize) {
            return new ListSubnetworksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSubnetworksPage
    extends AbstractPage<ListSubnetworksHttpRequest, SubnetworkList, Subnetwork, ListSubnetworksPage> {
        private ListSubnetworksPage(PageContext<ListSubnetworksHttpRequest, SubnetworkList, Subnetwork> context, SubnetworkList response) {
            super(context, (Object)response);
        }

        private static ListSubnetworksPage createEmptyPage() {
            return new ListSubnetworksPage(null, null);
        }

        protected ListSubnetworksPage createPage(PageContext<ListSubnetworksHttpRequest, SubnetworkList, Subnetwork> context, SubnetworkList response) {
            return new ListSubnetworksPage(context, response);
        }

        public ApiFuture<ListSubnetworksPage> createPageAsync(PageContext<ListSubnetworksHttpRequest, SubnetworkList, Subnetwork> context, ApiFuture<SubnetworkList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSubnetworksPagedResponse
    extends AbstractPagedListResponse<ListSubnetworksHttpRequest, SubnetworkList, Subnetwork, ListSubnetworksPage, ListSubnetworksFixedSizeCollection> {
        public static ApiFuture<ListSubnetworksPagedResponse> createAsync(PageContext<ListSubnetworksHttpRequest, SubnetworkList, Subnetwork> context, ApiFuture<SubnetworkList> futureResponse) {
            ApiFuture<ListSubnetworksPage> futurePage = ListSubnetworksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListSubnetworksPage, ListSubnetworksPagedResponse>(){

                public ListSubnetworksPagedResponse apply(ListSubnetworksPage input) {
                    return new ListSubnetworksPagedResponse(input);
                }
            });
        }

        private ListSubnetworksPagedResponse(ListSubnetworksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSubnetworksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListSubnetworksFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworksScopedList, AggregatedListSubnetworksPage, AggregatedListSubnetworksFixedSizeCollection> {
        private AggregatedListSubnetworksFixedSizeCollection(List<AggregatedListSubnetworksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListSubnetworksFixedSizeCollection createEmptyCollection() {
            return new AggregatedListSubnetworksFixedSizeCollection(null, 0);
        }

        protected AggregatedListSubnetworksFixedSizeCollection createCollection(List<AggregatedListSubnetworksPage> pages, int collectionSize) {
            return new AggregatedListSubnetworksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListSubnetworksPage
    extends AbstractPage<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworksScopedList, AggregatedListSubnetworksPage> {
        private AggregatedListSubnetworksPage(PageContext<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworksScopedList> context, SubnetworkAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListSubnetworksPage createEmptyPage() {
            return new AggregatedListSubnetworksPage(null, null);
        }

        protected AggregatedListSubnetworksPage createPage(PageContext<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworksScopedList> context, SubnetworkAggregatedList response) {
            return new AggregatedListSubnetworksPage(context, response);
        }

        public ApiFuture<AggregatedListSubnetworksPage> createPageAsync(PageContext<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworksScopedList> context, ApiFuture<SubnetworkAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListSubnetworksPagedResponse
    extends AbstractPagedListResponse<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworksScopedList, AggregatedListSubnetworksPage, AggregatedListSubnetworksFixedSizeCollection> {
        public static ApiFuture<AggregatedListSubnetworksPagedResponse> createAsync(PageContext<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworksScopedList> context, ApiFuture<SubnetworkAggregatedList> futureResponse) {
            ApiFuture<AggregatedListSubnetworksPage> futurePage = AggregatedListSubnetworksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListSubnetworksPage, AggregatedListSubnetworksPagedResponse>(){

                public AggregatedListSubnetworksPagedResponse apply(AggregatedListSubnetworksPage input) {
                    return new AggregatedListSubnetworksPagedResponse(input);
                }
            });
        }

        private AggregatedListSubnetworksPagedResponse(AggregatedListSubnetworksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListSubnetworksFixedSizeCollection.createEmptyCollection());
        }
    }
}

