/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddPeeringNetworkHttpRequest;
import com.google.cloud.compute.v1.DeleteNetworkHttpRequest;
import com.google.cloud.compute.v1.GetNetworkHttpRequest;
import com.google.cloud.compute.v1.InsertNetworkHttpRequest;
import com.google.cloud.compute.v1.ListNetworksHttpRequest;
import com.google.cloud.compute.v1.Network;
import com.google.cloud.compute.v1.NetworkList;
import com.google.cloud.compute.v1.NetworkSettings;
import com.google.cloud.compute.v1.NetworksAddPeeringRequest;
import com.google.cloud.compute.v1.NetworksRemovePeeringRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchNetworkHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalNetworkName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.RemovePeeringNetworkHttpRequest;
import com.google.cloud.compute.v1.SwitchToCustomModeNetworkHttpRequest;
import com.google.cloud.compute.v1.stub.NetworkStub;
import com.google.cloud.compute.v1.stub.NetworkStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class NetworkClient
implements BackgroundResource {
    private final NetworkSettings settings;
    private final NetworkStub stub;

    public static final NetworkClient create() throws IOException {
        return NetworkClient.create(NetworkSettings.newBuilder().build());
    }

    public static final NetworkClient create(NetworkSettings settings) throws IOException {
        return new NetworkClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final NetworkClient create(NetworkStub stub) {
        return new NetworkClient(stub);
    }

    protected NetworkClient(NetworkSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NetworkStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected NetworkClient(NetworkStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final NetworkSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NetworkStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation addPeeringNetwork(ProjectGlobalNetworkName network, NetworksAddPeeringRequest networksAddPeeringRequestResource) {
        AddPeeringNetworkHttpRequest request = AddPeeringNetworkHttpRequest.newBuilder().setNetwork(network == null ? null : network.toString()).setNetworksAddPeeringRequestResource(networksAddPeeringRequestResource).build();
        return this.addPeeringNetwork(request);
    }

    @BetaApi
    public final Operation addPeeringNetwork(String network, NetworksAddPeeringRequest networksAddPeeringRequestResource) {
        AddPeeringNetworkHttpRequest request = AddPeeringNetworkHttpRequest.newBuilder().setNetwork(network).setNetworksAddPeeringRequestResource(networksAddPeeringRequestResource).build();
        return this.addPeeringNetwork(request);
    }

    @BetaApi
    public final Operation addPeeringNetwork(AddPeeringNetworkHttpRequest request) {
        return (Operation)this.addPeeringNetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<AddPeeringNetworkHttpRequest, Operation> addPeeringNetworkCallable() {
        return this.stub.addPeeringNetworkCallable();
    }

    @BetaApi
    public final Operation deleteNetwork(ProjectGlobalNetworkName network) {
        DeleteNetworkHttpRequest request = DeleteNetworkHttpRequest.newBuilder().setNetwork(network == null ? null : network.toString()).build();
        return this.deleteNetwork(request);
    }

    @BetaApi
    public final Operation deleteNetwork(String network) {
        DeleteNetworkHttpRequest request = DeleteNetworkHttpRequest.newBuilder().setNetwork(network).build();
        return this.deleteNetwork(request);
    }

    @BetaApi
    public final Operation deleteNetwork(DeleteNetworkHttpRequest request) {
        return (Operation)this.deleteNetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteNetworkHttpRequest, Operation> deleteNetworkCallable() {
        return this.stub.deleteNetworkCallable();
    }

    @BetaApi
    public final Network getNetwork(ProjectGlobalNetworkName network) {
        GetNetworkHttpRequest request = GetNetworkHttpRequest.newBuilder().setNetwork(network == null ? null : network.toString()).build();
        return this.getNetwork(request);
    }

    @BetaApi
    public final Network getNetwork(String network) {
        GetNetworkHttpRequest request = GetNetworkHttpRequest.newBuilder().setNetwork(network).build();
        return this.getNetwork(request);
    }

    @BetaApi
    public final Network getNetwork(GetNetworkHttpRequest request) {
        return (Network)this.getNetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetNetworkHttpRequest, Network> getNetworkCallable() {
        return this.stub.getNetworkCallable();
    }

    @BetaApi
    public final Operation insertNetwork(ProjectName project, Network networkResource) {
        InsertNetworkHttpRequest request = InsertNetworkHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setNetworkResource(networkResource).build();
        return this.insertNetwork(request);
    }

    @BetaApi
    public final Operation insertNetwork(String project, Network networkResource) {
        InsertNetworkHttpRequest request = InsertNetworkHttpRequest.newBuilder().setProject(project).setNetworkResource(networkResource).build();
        return this.insertNetwork(request);
    }

    @BetaApi
    public final Operation insertNetwork(InsertNetworkHttpRequest request) {
        return (Operation)this.insertNetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertNetworkHttpRequest, Operation> insertNetworkCallable() {
        return this.stub.insertNetworkCallable();
    }

    @BetaApi
    public final ListNetworksPagedResponse listNetworks(ProjectName project) {
        ListNetworksHttpRequest request = ListNetworksHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listNetworks(request);
    }

    @BetaApi
    public final ListNetworksPagedResponse listNetworks(String project) {
        ListNetworksHttpRequest request = ListNetworksHttpRequest.newBuilder().setProject(project).build();
        return this.listNetworks(request);
    }

    @BetaApi
    public final ListNetworksPagedResponse listNetworks(ListNetworksHttpRequest request) {
        return (ListNetworksPagedResponse)((Object)this.listNetworksPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListNetworksHttpRequest, ListNetworksPagedResponse> listNetworksPagedCallable() {
        return this.stub.listNetworksPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListNetworksHttpRequest, NetworkList> listNetworksCallable() {
        return this.stub.listNetworksCallable();
    }

    @BetaApi
    public final Operation patchNetwork(ProjectGlobalNetworkName network, Network networkResource) {
        PatchNetworkHttpRequest request = PatchNetworkHttpRequest.newBuilder().setNetwork(network == null ? null : network.toString()).setNetworkResource(networkResource).build();
        return this.patchNetwork(request);
    }

    @BetaApi
    public final Operation patchNetwork(String network, Network networkResource) {
        PatchNetworkHttpRequest request = PatchNetworkHttpRequest.newBuilder().setNetwork(network).setNetworkResource(networkResource).build();
        return this.patchNetwork(request);
    }

    @BetaApi
    public final Operation patchNetwork(PatchNetworkHttpRequest request) {
        return (Operation)this.patchNetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchNetworkHttpRequest, Operation> patchNetworkCallable() {
        return this.stub.patchNetworkCallable();
    }

    @BetaApi
    public final Operation removePeeringNetwork(ProjectGlobalNetworkName network, NetworksRemovePeeringRequest networksRemovePeeringRequestResource) {
        RemovePeeringNetworkHttpRequest request = RemovePeeringNetworkHttpRequest.newBuilder().setNetwork(network == null ? null : network.toString()).setNetworksRemovePeeringRequestResource(networksRemovePeeringRequestResource).build();
        return this.removePeeringNetwork(request);
    }

    @BetaApi
    public final Operation removePeeringNetwork(String network, NetworksRemovePeeringRequest networksRemovePeeringRequestResource) {
        RemovePeeringNetworkHttpRequest request = RemovePeeringNetworkHttpRequest.newBuilder().setNetwork(network).setNetworksRemovePeeringRequestResource(networksRemovePeeringRequestResource).build();
        return this.removePeeringNetwork(request);
    }

    @BetaApi
    public final Operation removePeeringNetwork(RemovePeeringNetworkHttpRequest request) {
        return (Operation)this.removePeeringNetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<RemovePeeringNetworkHttpRequest, Operation> removePeeringNetworkCallable() {
        return this.stub.removePeeringNetworkCallable();
    }

    @BetaApi
    public final Operation switchToCustomModeNetwork(ProjectGlobalNetworkName network) {
        SwitchToCustomModeNetworkHttpRequest request = SwitchToCustomModeNetworkHttpRequest.newBuilder().setNetwork(network == null ? null : network.toString()).build();
        return this.switchToCustomModeNetwork(request);
    }

    @BetaApi
    public final Operation switchToCustomModeNetwork(String network) {
        SwitchToCustomModeNetworkHttpRequest request = SwitchToCustomModeNetworkHttpRequest.newBuilder().setNetwork(network).build();
        return this.switchToCustomModeNetwork(request);
    }

    @BetaApi
    public final Operation switchToCustomModeNetwork(SwitchToCustomModeNetworkHttpRequest request) {
        return (Operation)this.switchToCustomModeNetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SwitchToCustomModeNetworkHttpRequest, Operation> switchToCustomModeNetworkCallable() {
        return this.stub.switchToCustomModeNetworkCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListNetworksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNetworksHttpRequest, NetworkList, Network, ListNetworksPage, ListNetworksFixedSizeCollection> {
        private ListNetworksFixedSizeCollection(List<ListNetworksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNetworksFixedSizeCollection createEmptyCollection() {
            return new ListNetworksFixedSizeCollection(null, 0);
        }

        protected ListNetworksFixedSizeCollection createCollection(List<ListNetworksPage> pages, int collectionSize) {
            return new ListNetworksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNetworksPage
    extends AbstractPage<ListNetworksHttpRequest, NetworkList, Network, ListNetworksPage> {
        private ListNetworksPage(PageContext<ListNetworksHttpRequest, NetworkList, Network> context, NetworkList response) {
            super(context, (Object)response);
        }

        private static ListNetworksPage createEmptyPage() {
            return new ListNetworksPage(null, null);
        }

        protected ListNetworksPage createPage(PageContext<ListNetworksHttpRequest, NetworkList, Network> context, NetworkList response) {
            return new ListNetworksPage(context, response);
        }

        public ApiFuture<ListNetworksPage> createPageAsync(PageContext<ListNetworksHttpRequest, NetworkList, Network> context, ApiFuture<NetworkList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNetworksPagedResponse
    extends AbstractPagedListResponse<ListNetworksHttpRequest, NetworkList, Network, ListNetworksPage, ListNetworksFixedSizeCollection> {
        public static ApiFuture<ListNetworksPagedResponse> createAsync(PageContext<ListNetworksHttpRequest, NetworkList, Network> context, ApiFuture<NetworkList> futureResponse) {
            ApiFuture<ListNetworksPage> futurePage = ListNetworksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListNetworksPage, ListNetworksPagedResponse>(){

                public ListNetworksPagedResponse apply(ListNetworksPage input) {
                    return new ListNetworksPagedResponse(input);
                }
            });
        }

        private ListNetworksPagedResponse(ListNetworksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNetworksFixedSizeCollection.createEmptyCollection());
        }
    }
}

