/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Route;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class RouterStatusBgpPeerStatus
implements ApiMessage {
    private final List<Route> advertisedRoutes;
    private final String ipAddress;
    private final String linkedVpnTunnel;
    private final String name;
    private final Integer numLearnedRoutes;
    private final String peerIpAddress;
    private final String state;
    private final String status;
    private final String uptime;
    private final String uptimeSeconds;
    private static final RouterStatusBgpPeerStatus DEFAULT_INSTANCE = new RouterStatusBgpPeerStatus();

    private RouterStatusBgpPeerStatus() {
        this.advertisedRoutes = null;
        this.ipAddress = null;
        this.linkedVpnTunnel = null;
        this.name = null;
        this.numLearnedRoutes = null;
        this.peerIpAddress = null;
        this.state = null;
        this.status = null;
        this.uptime = null;
        this.uptimeSeconds = null;
    }

    private RouterStatusBgpPeerStatus(List<Route> advertisedRoutes, String ipAddress, String linkedVpnTunnel, String name, Integer numLearnedRoutes, String peerIpAddress, String state, String status, String uptime, String uptimeSeconds) {
        this.advertisedRoutes = advertisedRoutes;
        this.ipAddress = ipAddress;
        this.linkedVpnTunnel = linkedVpnTunnel;
        this.name = name;
        this.numLearnedRoutes = numLearnedRoutes;
        this.peerIpAddress = peerIpAddress;
        this.state = state;
        this.status = status;
        this.uptime = uptime;
        this.uptimeSeconds = uptimeSeconds;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("advertisedRoutes")) {
            return this.advertisedRoutes;
        }
        if (fieldName.equals("ipAddress")) {
            return this.ipAddress;
        }
        if (fieldName.equals("linkedVpnTunnel")) {
            return this.linkedVpnTunnel;
        }
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("numLearnedRoutes")) {
            return this.numLearnedRoutes;
        }
        if (fieldName.equals("peerIpAddress")) {
            return this.peerIpAddress;
        }
        if (fieldName.equals("state")) {
            return this.state;
        }
        if (fieldName.equals("status")) {
            return this.status;
        }
        if (fieldName.equals("uptime")) {
            return this.uptime;
        }
        if (fieldName.equals("uptimeSeconds")) {
            return this.uptimeSeconds;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<Route> getAdvertisedRoutesList() {
        return this.advertisedRoutes;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getLinkedVpnTunnel() {
        return this.linkedVpnTunnel;
    }

    public String getName() {
        return this.name;
    }

    public Integer getNumLearnedRoutes() {
        return this.numLearnedRoutes;
    }

    public String getPeerIpAddress() {
        return this.peerIpAddress;
    }

    public String getState() {
        return this.state;
    }

    public String getStatus() {
        return this.status;
    }

    public String getUptime() {
        return this.uptime;
    }

    public String getUptimeSeconds() {
        return this.uptimeSeconds;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(RouterStatusBgpPeerStatus prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static RouterStatusBgpPeerStatus getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "RouterStatusBgpPeerStatus{advertisedRoutes=" + this.advertisedRoutes + ", ipAddress=" + this.ipAddress + ", linkedVpnTunnel=" + this.linkedVpnTunnel + ", name=" + this.name + ", numLearnedRoutes=" + this.numLearnedRoutes + ", peerIpAddress=" + this.peerIpAddress + ", state=" + this.state + ", status=" + this.status + ", uptime=" + this.uptime + ", uptimeSeconds=" + this.uptimeSeconds + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RouterStatusBgpPeerStatus) {
            RouterStatusBgpPeerStatus that = (RouterStatusBgpPeerStatus)o;
            return Objects.equals(this.advertisedRoutes, that.getAdvertisedRoutesList()) && Objects.equals(this.ipAddress, that.getIpAddress()) && Objects.equals(this.linkedVpnTunnel, that.getLinkedVpnTunnel()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.numLearnedRoutes, that.getNumLearnedRoutes()) && Objects.equals(this.peerIpAddress, that.getPeerIpAddress()) && Objects.equals(this.state, that.getState()) && Objects.equals(this.status, that.getStatus()) && Objects.equals(this.uptime, that.getUptime()) && Objects.equals(this.uptimeSeconds, that.getUptimeSeconds());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.advertisedRoutes, this.ipAddress, this.linkedVpnTunnel, this.name, this.numLearnedRoutes, this.peerIpAddress, this.state, this.status, this.uptime, this.uptimeSeconds);
    }

    public static class Builder {
        private List<Route> advertisedRoutes;
        private String ipAddress;
        private String linkedVpnTunnel;
        private String name;
        private Integer numLearnedRoutes;
        private String peerIpAddress;
        private String state;
        private String status;
        private String uptime;
        private String uptimeSeconds;

        Builder() {
        }

        public Builder mergeFrom(RouterStatusBgpPeerStatus other) {
            if (other == RouterStatusBgpPeerStatus.getDefaultInstance()) {
                return this;
            }
            if (other.getAdvertisedRoutesList() != null) {
                this.advertisedRoutes = other.advertisedRoutes;
            }
            if (other.getIpAddress() != null) {
                this.ipAddress = other.ipAddress;
            }
            if (other.getLinkedVpnTunnel() != null) {
                this.linkedVpnTunnel = other.linkedVpnTunnel;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNumLearnedRoutes() != null) {
                this.numLearnedRoutes = other.numLearnedRoutes;
            }
            if (other.getPeerIpAddress() != null) {
                this.peerIpAddress = other.peerIpAddress;
            }
            if (other.getState() != null) {
                this.state = other.state;
            }
            if (other.getStatus() != null) {
                this.status = other.status;
            }
            if (other.getUptime() != null) {
                this.uptime = other.uptime;
            }
            if (other.getUptimeSeconds() != null) {
                this.uptimeSeconds = other.uptimeSeconds;
            }
            return this;
        }

        Builder(RouterStatusBgpPeerStatus source) {
            this.advertisedRoutes = source.advertisedRoutes;
            this.ipAddress = source.ipAddress;
            this.linkedVpnTunnel = source.linkedVpnTunnel;
            this.name = source.name;
            this.numLearnedRoutes = source.numLearnedRoutes;
            this.peerIpAddress = source.peerIpAddress;
            this.state = source.state;
            this.status = source.status;
            this.uptime = source.uptime;
            this.uptimeSeconds = source.uptimeSeconds;
        }

        public List<Route> getAdvertisedRoutesList() {
            return this.advertisedRoutes;
        }

        public Builder addAllAdvertisedRoutes(List<Route> advertisedRoutes) {
            if (this.advertisedRoutes == null) {
                this.advertisedRoutes = new ArrayList<Route>(advertisedRoutes.size());
            }
            this.advertisedRoutes.addAll(advertisedRoutes);
            return this;
        }

        public Builder addAdvertisedRoutes(Route advertisedRoutes) {
            this.advertisedRoutes.add(advertisedRoutes);
            return this;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public Builder setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public String getLinkedVpnTunnel() {
            return this.linkedVpnTunnel;
        }

        public Builder setLinkedVpnTunnel(String linkedVpnTunnel) {
            this.linkedVpnTunnel = linkedVpnTunnel;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Integer getNumLearnedRoutes() {
            return this.numLearnedRoutes;
        }

        public Builder setNumLearnedRoutes(Integer numLearnedRoutes) {
            this.numLearnedRoutes = numLearnedRoutes;
            return this;
        }

        public String getPeerIpAddress() {
            return this.peerIpAddress;
        }

        public Builder setPeerIpAddress(String peerIpAddress) {
            this.peerIpAddress = peerIpAddress;
            return this;
        }

        public String getState() {
            return this.state;
        }

        public Builder setState(String state) {
            this.state = state;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public String getUptime() {
            return this.uptime;
        }

        public Builder setUptime(String uptime) {
            this.uptime = uptime;
            return this;
        }

        public String getUptimeSeconds() {
            return this.uptimeSeconds;
        }

        public Builder setUptimeSeconds(String uptimeSeconds) {
            this.uptimeSeconds = uptimeSeconds;
            return this;
        }

        public RouterStatusBgpPeerStatus build() {
            return new RouterStatusBgpPeerStatus(this.advertisedRoutes, this.ipAddress, this.linkedVpnTunnel, this.name, this.numLearnedRoutes, this.peerIpAddress, this.state, this.status, this.uptime, this.uptimeSeconds);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllAdvertisedRoutes(this.advertisedRoutes);
            newBuilder.setIpAddress(this.ipAddress);
            newBuilder.setLinkedVpnTunnel(this.linkedVpnTunnel);
            newBuilder.setName(this.name);
            newBuilder.setNumLearnedRoutes(this.numLearnedRoutes);
            newBuilder.setPeerIpAddress(this.peerIpAddress);
            newBuilder.setState(this.state);
            newBuilder.setStatus(this.status);
            newBuilder.setUptime(this.uptime);
            newBuilder.setUptimeSeconds(this.uptimeSeconds);
            return newBuilder;
        }
    }
}

