/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.RouterAdvertisedIpRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class RouterBgp
implements ApiMessage {
    private final String advertiseMode;
    private final List<String> advertisedGroups;
    private final List<RouterAdvertisedIpRange> advertisedIpRanges;
    private final Integer asn;
    private static final RouterBgp DEFAULT_INSTANCE = new RouterBgp();

    private RouterBgp() {
        this.advertiseMode = null;
        this.advertisedGroups = null;
        this.advertisedIpRanges = null;
        this.asn = null;
    }

    private RouterBgp(String advertiseMode, List<String> advertisedGroups, List<RouterAdvertisedIpRange> advertisedIpRanges, Integer asn) {
        this.advertiseMode = advertiseMode;
        this.advertisedGroups = advertisedGroups;
        this.advertisedIpRanges = advertisedIpRanges;
        this.asn = asn;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("advertiseMode")) {
            return this.advertiseMode;
        }
        if (fieldName.equals("advertisedGroups")) {
            return this.advertisedGroups;
        }
        if (fieldName.equals("advertisedIpRanges")) {
            return this.advertisedIpRanges;
        }
        if (fieldName.equals("asn")) {
            return this.asn;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAdvertiseMode() {
        return this.advertiseMode;
    }

    public List<String> getAdvertisedGroupsList() {
        return this.advertisedGroups;
    }

    public List<RouterAdvertisedIpRange> getAdvertisedIpRangesList() {
        return this.advertisedIpRanges;
    }

    public Integer getAsn() {
        return this.asn;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(RouterBgp prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static RouterBgp getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "RouterBgp{advertiseMode=" + this.advertiseMode + ", advertisedGroups=" + this.advertisedGroups + ", advertisedIpRanges=" + this.advertisedIpRanges + ", asn=" + this.asn + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RouterBgp) {
            RouterBgp that = (RouterBgp)o;
            return Objects.equals(this.advertiseMode, that.getAdvertiseMode()) && Objects.equals(this.advertisedGroups, that.getAdvertisedGroupsList()) && Objects.equals(this.advertisedIpRanges, that.getAdvertisedIpRangesList()) && Objects.equals(this.asn, that.getAsn());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.advertiseMode, this.advertisedGroups, this.advertisedIpRanges, this.asn);
    }

    public static class Builder {
        private String advertiseMode;
        private List<String> advertisedGroups;
        private List<RouterAdvertisedIpRange> advertisedIpRanges;
        private Integer asn;

        Builder() {
        }

        public Builder mergeFrom(RouterBgp other) {
            if (other == RouterBgp.getDefaultInstance()) {
                return this;
            }
            if (other.getAdvertiseMode() != null) {
                this.advertiseMode = other.advertiseMode;
            }
            if (other.getAdvertisedGroupsList() != null) {
                this.advertisedGroups = other.advertisedGroups;
            }
            if (other.getAdvertisedIpRangesList() != null) {
                this.advertisedIpRanges = other.advertisedIpRanges;
            }
            if (other.getAsn() != null) {
                this.asn = other.asn;
            }
            return this;
        }

        Builder(RouterBgp source) {
            this.advertiseMode = source.advertiseMode;
            this.advertisedGroups = source.advertisedGroups;
            this.advertisedIpRanges = source.advertisedIpRanges;
            this.asn = source.asn;
        }

        public String getAdvertiseMode() {
            return this.advertiseMode;
        }

        public Builder setAdvertiseMode(String advertiseMode) {
            this.advertiseMode = advertiseMode;
            return this;
        }

        public List<String> getAdvertisedGroupsList() {
            return this.advertisedGroups;
        }

        public Builder addAllAdvertisedGroups(List<String> advertisedGroups) {
            if (this.advertisedGroups == null) {
                this.advertisedGroups = new ArrayList<String>(advertisedGroups.size());
            }
            this.advertisedGroups.addAll(advertisedGroups);
            return this;
        }

        public Builder addAdvertisedGroups(String advertisedGroups) {
            this.advertisedGroups.add(advertisedGroups);
            return this;
        }

        public List<RouterAdvertisedIpRange> getAdvertisedIpRangesList() {
            return this.advertisedIpRanges;
        }

        public Builder addAllAdvertisedIpRanges(List<RouterAdvertisedIpRange> advertisedIpRanges) {
            if (this.advertisedIpRanges == null) {
                this.advertisedIpRanges = new ArrayList<RouterAdvertisedIpRange>(advertisedIpRanges.size());
            }
            this.advertisedIpRanges.addAll(advertisedIpRanges);
            return this;
        }

        public Builder addAdvertisedIpRanges(RouterAdvertisedIpRange advertisedIpRanges) {
            this.advertisedIpRanges.add(advertisedIpRanges);
            return this;
        }

        public Integer getAsn() {
            return this.asn;
        }

        public Builder setAsn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public RouterBgp build() {
            return new RouterBgp(this.advertiseMode, this.advertisedGroups, this.advertisedIpRanges, this.asn);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAdvertiseMode(this.advertiseMode);
            newBuilder.addAllAdvertisedGroups(this.advertisedGroups);
            newBuilder.addAllAdvertisedIpRanges(this.advertisedIpRanges);
            newBuilder.setAsn(this.asn);
            return newBuilder;
        }
    }
}

