/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.cloud.compute.deprecated.Compute;
import com.google.cloud.compute.deprecated.ComputeOptions;
import com.google.cloud.compute.deprecated.NetworkConfiguration;
import com.google.cloud.compute.deprecated.NetworkId;
import com.google.cloud.compute.deprecated.NetworkInfo;
import com.google.cloud.compute.deprecated.Operation;
import com.google.cloud.compute.deprecated.SubnetworkId;
import com.google.cloud.compute.deprecated.SubnetworkInfo;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;

public class Network
extends NetworkInfo {
    private static final long serialVersionUID = 8608280908101278096L;
    private final ComputeOptions options;
    private transient Compute compute;

    Network(Compute compute, NetworkInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.compute = (Compute)Preconditions.checkNotNull((Object)compute);
        this.options = (ComputeOptions)compute.getOptions();
    }

    public boolean exists() {
        return this.reload(Compute.NetworkOption.fields(new Compute.NetworkField[0])) != null;
    }

    public Network reload(Compute.NetworkOption ... options) {
        return this.compute.getNetwork(this.getNetworkId().getNetwork(), options);
    }

    public Operation delete(Compute.OperationOption ... options) {
        return this.compute.deleteNetwork(this.getNetworkId().getNetwork(), options);
    }

    public Operation createSubnetwork(SubnetworkId subnetworkId, String ipRange, Compute.OperationOption ... options) {
        return this.compute.create(SubnetworkInfo.of(subnetworkId, this.getNetworkId(), ipRange), options);
    }

    public Compute getCompute() {
        return this.compute;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Network.class)) {
            return false;
        }
        Network other = (Network)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.compute = (Compute)this.options.getService();
    }

    static Network fromPb(Compute compute, com.google.api.services.compute.model.Network networkPb) {
        return new Network(compute, new NetworkInfo.BuilderImpl(networkPb));
    }

    public static class Builder
    extends NetworkInfo.Builder {
        private final Compute compute;
        private final NetworkInfo.BuilderImpl infoBuilder;

        Builder(Compute compute, NetworkId networkId, NetworkConfiguration configuration) {
            this.compute = compute;
            this.infoBuilder = new NetworkInfo.BuilderImpl(networkId, configuration);
            this.infoBuilder.setNetworkId(networkId);
            this.infoBuilder.setConfiguration(configuration);
        }

        Builder(Network subnetwork) {
            this.compute = subnetwork.compute;
            this.infoBuilder = new NetworkInfo.BuilderImpl(subnetwork);
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.infoBuilder.setGeneratedId(generatedId);
            return this;
        }

        @Override
        Builder setCreationTimestamp(Long creationTimestamp) {
            this.infoBuilder.setCreationTimestamp(creationTimestamp);
            return this;
        }

        @Override
        public Builder setNetworkId(NetworkId networkId) {
            this.infoBuilder.setNetworkId(networkId);
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.infoBuilder.setDescription(description);
            return this;
        }

        @Override
        public Builder setConfiguration(NetworkConfiguration configuration) {
            this.infoBuilder.setConfiguration(configuration);
            return this;
        }

        @Override
        public Network build() {
            return new Network(this.compute, this.infoBuilder);
        }
    }
}

