/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Network;
import com.google.cloud.compute.NetworkConfiguration;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class StandardNetworkConfiguration
extends NetworkConfiguration {
    private static final long serialVersionUID = -5143748459659467966L;
    private final String ipRange;
    private final String gatewayAddress;

    StandardNetworkConfiguration(String ipRange, String gatewayAddress) {
        super(NetworkConfiguration.Type.STANDARD);
        this.ipRange = (String)Preconditions.checkNotNull((Object)ipRange);
        this.gatewayAddress = gatewayAddress;
    }

    public String ipRange() {
        return this.ipRange;
    }

    public String gatewayAddress() {
        return this.gatewayAddress;
    }

    public final int hashCode() {
        return Objects.hash(super.baseHashCode(), this.ipRange, this.gatewayAddress);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(StandardNetworkConfiguration.class) && Objects.equals(this.toPb(), ((StandardNetworkConfiguration)obj).toPb());
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("ipRange", (Object)this.ipRange).add("gatewayAddress", (Object)this.gatewayAddress);
    }

    @Override
    Network toPb() {
        return new Network().setIPv4Range(this.ipRange).setGatewayIPv4(this.gatewayAddress);
    }

    public static StandardNetworkConfiguration of(String ipRange) {
        return new StandardNetworkConfiguration(ipRange, null);
    }

    static StandardNetworkConfiguration fromPb(Network networkPb) {
        return new StandardNetworkConfiguration(networkPb.getIPv4Range(), networkPb.getGatewayIPv4());
    }
}

