/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.testing;

import com.google.cloud.compute.AddressId;
import com.google.cloud.compute.Compute;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.ImageId;
import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.SnapshotId;
import com.google.cloud.compute.SubnetworkId;
import com.google.common.base.Function;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class ResourceCleaner {
    private final Compute compute;
    private final Map<Object, ManagedResource<?>> resources;

    private ResourceCleaner(Compute compute) {
        this.compute = compute;
        this.resources = new HashMap();
    }

    public static ResourceCleaner create(Compute compute) {
        return new ResourceCleaner(compute);
    }

    public void cleanUp() {
        for (Map.Entry<Object, ManagedResource<?>> r : this.resources.entrySet()) {
            r.getValue().delete();
        }
        this.resources.clear();
    }

    public void add(AddressId addressId) {
        ManagedResource r = new ManagedResource(addressId, (Function)new Function<AddressId, Void>(){

            public Void apply(AddressId addressId) {
                ResourceCleaner.this.compute.deleteAddress(addressId, new Compute.OperationOption[0]);
                return null;
            }
        });
        this.resources.put(addressId, r);
    }

    public void add(DiskId diskId) {
        ManagedResource r = new ManagedResource(diskId, (Function)new Function<DiskId, Void>(){

            public Void apply(DiskId diskId) {
                ResourceCleaner.this.compute.deleteDisk(diskId, new Compute.OperationOption[0]);
                return null;
            }
        });
        this.resources.put(diskId, r);
    }

    public void add(SnapshotId snapshotId) {
        ManagedResource r = new ManagedResource(snapshotId, (Function)new Function<SnapshotId, Void>(){

            public Void apply(SnapshotId snapshotId) {
                ResourceCleaner.this.compute.deleteSnapshot(snapshotId, new Compute.OperationOption[0]);
                return null;
            }
        });
        this.resources.put(snapshotId, r);
    }

    public void add(NetworkId networkId) {
        ManagedResource r = new ManagedResource(networkId, (Function)new Function<NetworkId, Void>(){

            public Void apply(NetworkId networkId) {
                ResourceCleaner.this.compute.deleteNetwork(networkId, new Compute.OperationOption[0]);
                return null;
            }
        });
        this.resources.put(networkId, r);
    }

    public void add(SubnetworkId subnetworkId) {
        ManagedResource r = new ManagedResource(subnetworkId, (Function)new Function<SubnetworkId, Void>(){

            public Void apply(SubnetworkId subnetworkId) {
                ResourceCleaner.this.compute.deleteSubnetwork(subnetworkId, new Compute.OperationOption[0]);
                return null;
            }
        });
        this.resources.put(subnetworkId, r);
    }

    public void add(ImageId imageId) {
        ManagedResource r = new ManagedResource(imageId, (Function)new Function<ImageId, Void>(){

            public Void apply(ImageId imageId) {
                ResourceCleaner.this.compute.deleteImage(imageId, new Compute.OperationOption[0]);
                return null;
            }
        });
        this.resources.put(imageId, r);
    }

    public void add(InstanceId instanceId) {
        ManagedResource r = new ManagedResource(instanceId, (Function)new Function<InstanceId, Void>(){

            public Void apply(InstanceId instanceId) {
                ResourceCleaner.this.compute.deleteInstance(instanceId, new Compute.OperationOption[0]);
                return null;
            }
        });
        this.resources.put(instanceId, r);
    }

    public ResourceCleaner remove(Object resourceId) {
        if (!this.resources.containsKey(resourceId)) {
            String string = String.valueOf(String.valueOf(resourceId));
            throw new NoSuchElementException(new StringBuilder(40 + string.length()).append(string).append(" has not been added to managed resources").toString());
        }
        this.resources.remove(resourceId);
        return this;
    }

    private class ManagedResource<T> {
        final T resourceId;
        Function<T, Void> deleteFunc;

        private ManagedResource(T resourceId, Function<T, Void> deleteFunc) {
            this.resourceId = resourceId;
            this.deleteFunc = deleteFunc;
        }

        public void delete() {
            this.deleteFunc.apply(this.resourceId);
        }
    }
}

