/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.spi.v1;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.Address;
import com.google.api.services.compute.model.AddressAggregatedList;
import com.google.api.services.compute.model.AddressList;
import com.google.api.services.compute.model.AddressesScopedList;
import com.google.api.services.compute.model.AttachedDisk;
import com.google.api.services.compute.model.DeprecationStatus;
import com.google.api.services.compute.model.Disk;
import com.google.api.services.compute.model.DiskAggregatedList;
import com.google.api.services.compute.model.DiskList;
import com.google.api.services.compute.model.DiskType;
import com.google.api.services.compute.model.DiskTypeAggregatedList;
import com.google.api.services.compute.model.DiskTypeList;
import com.google.api.services.compute.model.DiskTypesScopedList;
import com.google.api.services.compute.model.DisksResizeRequest;
import com.google.api.services.compute.model.DisksScopedList;
import com.google.api.services.compute.model.Image;
import com.google.api.services.compute.model.ImageList;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceAggregatedList;
import com.google.api.services.compute.model.InstanceList;
import com.google.api.services.compute.model.InstancesScopedList;
import com.google.api.services.compute.model.InstancesSetMachineTypeRequest;
import com.google.api.services.compute.model.License;
import com.google.api.services.compute.model.MachineType;
import com.google.api.services.compute.model.MachineTypeAggregatedList;
import com.google.api.services.compute.model.MachineTypeList;
import com.google.api.services.compute.model.MachineTypesScopedList;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.Network;
import com.google.api.services.compute.model.NetworkList;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.OperationList;
import com.google.api.services.compute.model.Region;
import com.google.api.services.compute.model.RegionList;
import com.google.api.services.compute.model.Scheduling;
import com.google.api.services.compute.model.SerialPortOutput;
import com.google.api.services.compute.model.Snapshot;
import com.google.api.services.compute.model.SnapshotList;
import com.google.api.services.compute.model.Subnetwork;
import com.google.api.services.compute.model.SubnetworkAggregatedList;
import com.google.api.services.compute.model.SubnetworkList;
import com.google.api.services.compute.model.SubnetworksScopedList;
import com.google.api.services.compute.model.Tags;
import com.google.api.services.compute.model.Zone;
import com.google.api.services.compute.model.ZoneList;
import com.google.cloud.ServiceOptions;
import com.google.cloud.compute.ComputeException;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.spi.v1.ComputeRpc;
import com.google.cloud.http.HttpTransportOptions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class HttpComputeRpc
implements ComputeRpc {
    private final ComputeOptions options;
    private final Compute compute;

    public HttpComputeRpc(ComputeOptions options) {
        HttpTransportOptions transportOptions = (HttpTransportOptions)options.getTransportOptions();
        HttpTransport transport = transportOptions.getHttpTransportFactory().create();
        HttpRequestInitializer initializer = transportOptions.getHttpRequestInitializer((ServiceOptions)options);
        this.options = options;
        this.compute = new Compute.Builder(transport, (JsonFactory)new JacksonFactory(), initializer).setRootUrl(options.getHost()).setApplicationName(options.getApplicationName()).build();
    }

    private static ComputeException translate(IOException exception) {
        return new ComputeException(exception);
    }

    @Override
    public DiskType getDiskType(String zone, String diskType, Map<ComputeRpc.Option, ?> options) {
        try {
            return (DiskType)this.compute.diskTypes().get(this.options.getProjectId(), zone, diskType).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (DiskType)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<DiskType>> listDiskTypes(String zone, Map<ComputeRpc.Option, ?> options) {
        try {
            DiskTypeList diskTypesList = (DiskTypeList)this.compute.diskTypes().list(this.options.getProjectId(), zone).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
            List diskTypes = diskTypesList.getItems();
            return ComputeRpc.Tuple.of(diskTypesList.getNextPageToken(), diskTypes);
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<DiskType>> listDiskTypes(Map<ComputeRpc.Option, ?> options) {
        try {
            DiskTypeAggregatedList aggregatedList = (DiskTypeAggregatedList)this.compute.diskTypes().aggregatedList(this.options.getProjectId()).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).execute();
            ImmutableList.Builder builder = ImmutableList.builder();
            Map scopedList = aggregatedList.getItems();
            if (scopedList != null) {
                for (DiskTypesScopedList diskTypesScopedList : scopedList.values()) {
                    if (diskTypesScopedList.getDiskTypes() == null) continue;
                    builder.addAll((Iterable)diskTypesScopedList.getDiskTypes());
                }
            }
            return ComputeRpc.Tuple.of(aggregatedList.getNextPageToken(), builder.build());
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public MachineType getMachineType(String zone, String machineType, Map<ComputeRpc.Option, ?> options) {
        try {
            return (MachineType)this.compute.machineTypes().get(this.options.getProjectId(), zone, machineType).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (MachineType)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<MachineType>> listMachineTypes(String zone, Map<ComputeRpc.Option, ?> options) {
        try {
            MachineTypeList machineTypesList = (MachineTypeList)this.compute.machineTypes().list(this.options.getProjectId(), zone).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
            List machineTypes = machineTypesList.getItems();
            return ComputeRpc.Tuple.of(machineTypesList.getNextPageToken(), machineTypes);
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<MachineType>> listMachineTypes(Map<ComputeRpc.Option, ?> options) {
        try {
            MachineTypeAggregatedList aggregatedList = (MachineTypeAggregatedList)this.compute.machineTypes().aggregatedList(this.options.getProjectId()).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).execute();
            ImmutableList.Builder builder = ImmutableList.builder();
            Map scopedList = aggregatedList.getItems();
            if (scopedList != null) {
                for (MachineTypesScopedList machineTypesScopedList : scopedList.values()) {
                    if (machineTypesScopedList.getMachineTypes() == null) continue;
                    builder.addAll((Iterable)machineTypesScopedList.getMachineTypes());
                }
            }
            return ComputeRpc.Tuple.of(aggregatedList.getNextPageToken(), builder.build());
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public Region getRegion(String region, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Region)this.compute.regions().get(this.options.getProjectId(), region).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Region)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<Region>> listRegions(Map<ComputeRpc.Option, ?> options) {
        try {
            RegionList regionsList = (RegionList)this.compute.regions().list(this.options.getProjectId()).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
            List regions = regionsList.getItems();
            return ComputeRpc.Tuple.of(regionsList.getNextPageToken(), regions);
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public Zone getZone(String zone, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Zone)this.compute.zones().get(this.options.getProjectId(), zone).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Zone)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<Zone>> listZones(Map<ComputeRpc.Option, ?> options) {
        try {
            ZoneList zonesList = (ZoneList)this.compute.zones().list(this.options.getProjectId()).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
            List zones = zonesList.getItems();
            return ComputeRpc.Tuple.of(zonesList.getNextPageToken(), zones);
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public License getLicense(String project, String license, Map<ComputeRpc.Option, ?> options) {
        try {
            return (License)this.compute.licenses().get(project, license).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (License)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation getGlobalOperation(String operation, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.globalOperations().get(this.options.getProjectId(), operation).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<Operation>> listGlobalOperations(Map<ComputeRpc.Option, ?> options) {
        try {
            OperationList operationsList = (OperationList)this.compute.globalOperations().list(this.options.getProjectId()).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
            List operations = operationsList.getItems();
            return ComputeRpc.Tuple.of(operationsList.getNextPageToken(), operations);
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public boolean deleteGlobalOperation(String operation) {
        try {
            this.compute.globalOperations().delete(this.options.getProjectId(), operation).execute();
            return true;
        }
        catch (IOException ex) {
            return HttpComputeRpc.falseForNotFound(ex);
        }
    }

    @Override
    public Operation getRegionOperation(String region, String operation, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.regionOperations().get(this.options.getProjectId(), region, operation).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<Operation>> listRegionOperations(String region, Map<ComputeRpc.Option, ?> options) {
        try {
            OperationList operationsList = (OperationList)this.compute.regionOperations().list(this.options.getProjectId(), region).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
            List operations = operationsList.getItems();
            return ComputeRpc.Tuple.of(operationsList.getNextPageToken(), operations);
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public boolean deleteRegionOperation(String region, String operation) {
        try {
            this.compute.regionOperations().delete(this.options.getProjectId(), region, operation).execute();
            return true;
        }
        catch (IOException ex) {
            return HttpComputeRpc.falseForNotFound(ex);
        }
    }

    @Override
    public Operation getZoneOperation(String zone, String operation, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.zoneOperations().get(this.options.getProjectId(), zone, operation).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<Operation>> listZoneOperations(String zone, Map<ComputeRpc.Option, ?> options) {
        try {
            OperationList operationsList = (OperationList)this.compute.zoneOperations().list(this.options.getProjectId(), zone).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
            List operations = operationsList.getItems();
            return ComputeRpc.Tuple.of(operationsList.getNextPageToken(), operations);
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public boolean deleteZoneOperation(String zone, String operation) {
        try {
            this.compute.zoneOperations().delete(this.options.getProjectId(), zone, operation).execute();
            return true;
        }
        catch (IOException ex) {
            return HttpComputeRpc.falseForNotFound(ex);
        }
    }

    @Override
    public Address getGlobalAddress(String address, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Address)this.compute.globalAddresses().get(this.options.getProjectId(), address).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Address)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation createGlobalAddress(Address address, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.globalAddresses().insert(this.options.getProjectId(), address).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<Address>> listGlobalAddresses(Map<ComputeRpc.Option, ?> options) {
        try {
            AddressList addressList = (AddressList)this.compute.globalAddresses().list(this.options.getProjectId()).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
            List operations = addressList.getItems();
            return ComputeRpc.Tuple.of(addressList.getNextPageToken(), operations);
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public Operation deleteGlobalAddress(String address, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.globalAddresses().delete(this.options.getProjectId(), address).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Address getRegionAddress(String region, String address, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Address)this.compute.addresses().get(this.options.getProjectId(), region, address).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Address)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation createRegionAddress(String region, Address address, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.addresses().insert(this.options.getProjectId(), region, address).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<Address>> listRegionAddresses(String region, Map<ComputeRpc.Option, ?> options) {
        try {
            AddressList addressList = (AddressList)this.compute.addresses().list(this.options.getProjectId(), region).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
            List operations = addressList.getItems();
            return ComputeRpc.Tuple.of(addressList.getNextPageToken(), operations);
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<Address>> listAddresses(Map<ComputeRpc.Option, ?> options) {
        try {
            AddressAggregatedList aggregatedList = (AddressAggregatedList)this.compute.addresses().aggregatedList(this.options.getProjectId()).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).execute();
            ImmutableList.Builder builder = ImmutableList.builder();
            Map scopedList = aggregatedList.getItems();
            if (scopedList != null) {
                for (AddressesScopedList addressesScopedList : scopedList.values()) {
                    if (addressesScopedList.getAddresses() == null) continue;
                    builder.addAll((Iterable)addressesScopedList.getAddresses());
                }
            }
            return ComputeRpc.Tuple.of(aggregatedList.getNextPageToken(), builder.build());
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public Operation deleteRegionAddress(String region, String address, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.addresses().delete(this.options.getProjectId(), region, address).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation createSnapshot(String zone, String disk, String snapshot, String description, Map<ComputeRpc.Option, ?> options) {
        Snapshot snapshotObject = new Snapshot().setName(snapshot).setDescription(description);
        try {
            return (Operation)this.compute.disks().createSnapshot(this.options.getProjectId(), zone, disk, snapshotObject).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public Snapshot getSnapshot(String snapshot, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Snapshot)this.compute.snapshots().get(this.options.getProjectId(), snapshot).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Snapshot)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<Snapshot>> listSnapshots(Map<ComputeRpc.Option, ?> options) {
        try {
            SnapshotList snapshotList = (SnapshotList)this.compute.snapshots().list(this.options.getProjectId()).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
            List snapshots = snapshotList.getItems();
            return ComputeRpc.Tuple.of(snapshotList.getNextPageToken(), snapshots);
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public Operation deleteSnapshot(String snapshot, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.snapshots().delete(this.options.getProjectId(), snapshot).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation createImage(Image image, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.images().insert(this.options.getProjectId(), image).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public Image getImage(String project, String image, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Image)this.compute.images().get(project, image).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Image)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<Image>> listImages(String project, Map<ComputeRpc.Option, ?> options) {
        try {
            ImageList imageList = (ImageList)this.compute.images().list(project).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
            List images = imageList.getItems();
            return ComputeRpc.Tuple.of(imageList.getNextPageToken(), images);
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public Operation deleteImage(String project, String image, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.images().delete(project, image).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation deprecateImage(String project, String image, DeprecationStatus deprecationStatus, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.images().deprecate(project, image, deprecationStatus).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Disk getDisk(String zone, String disk, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Disk)this.compute.disks().get(this.options.getProjectId(), zone, disk).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Disk)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation createDisk(String zone, Disk disk, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.disks().insert(this.options.getProjectId(), zone, disk).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<Disk>> listDisks(String zone, Map<ComputeRpc.Option, ?> options) {
        try {
            DiskList diskList = (DiskList)this.compute.disks().list(this.options.getProjectId(), zone).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
            List disks = diskList.getItems();
            return ComputeRpc.Tuple.of(diskList.getNextPageToken(), disks);
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<Disk>> listDisks(Map<ComputeRpc.Option, ?> options) {
        try {
            DiskAggregatedList aggregatedList = (DiskAggregatedList)this.compute.disks().aggregatedList(this.options.getProjectId()).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).execute();
            ImmutableList.Builder builder = ImmutableList.builder();
            Map scopedList = aggregatedList.getItems();
            if (scopedList != null) {
                for (DisksScopedList disksScopedList : scopedList.values()) {
                    if (disksScopedList.getDisks() == null) continue;
                    builder.addAll((Iterable)disksScopedList.getDisks());
                }
            }
            return ComputeRpc.Tuple.of(aggregatedList.getNextPageToken(), builder.build());
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public Operation deleteDisk(String zone, String disk, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.disks().delete(this.options.getProjectId(), zone, disk).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation resizeDisk(String zone, String disk, long sizeGb, Map<ComputeRpc.Option, ?> options) {
        try {
            DisksResizeRequest resizeRequest = new DisksResizeRequest().setSizeGb(Long.valueOf(sizeGb));
            return (Operation)this.compute.disks().resize(this.options.getProjectId(), zone, disk, resizeRequest).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation createSubnetwork(String region, Subnetwork subnetwork, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.subnetworks().insert(this.options.getProjectId(), region, subnetwork).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public Subnetwork getSubnetwork(String region, String subnetwork, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Subnetwork)this.compute.subnetworks().get(this.options.getProjectId(), region, subnetwork).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Subnetwork)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<Subnetwork>> listSubnetworks(String region, Map<ComputeRpc.Option, ?> options) {
        try {
            SubnetworkList subnetworkList = (SubnetworkList)this.compute.subnetworks().list(this.options.getProjectId(), region).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
            List subnetworks = subnetworkList.getItems();
            return ComputeRpc.Tuple.of(subnetworkList.getNextPageToken(), subnetworks);
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<Subnetwork>> listSubnetworks(Map<ComputeRpc.Option, ?> options) {
        try {
            SubnetworkAggregatedList aggregatedList = (SubnetworkAggregatedList)this.compute.subnetworks().aggregatedList(this.options.getProjectId()).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).execute();
            ImmutableList.Builder builder = ImmutableList.builder();
            Map scopedList = aggregatedList.getItems();
            if (scopedList != null) {
                for (SubnetworksScopedList subnetworksScopedList : scopedList.values()) {
                    if (subnetworksScopedList.getSubnetworks() == null) continue;
                    builder.addAll((Iterable)subnetworksScopedList.getSubnetworks());
                }
            }
            return ComputeRpc.Tuple.of(aggregatedList.getNextPageToken(), builder.build());
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public Operation deleteSubnetwork(String region, String subnetwork, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.subnetworks().delete(this.options.getProjectId(), region, subnetwork).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation createNetwork(Network network, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.networks().insert(this.options.getProjectId(), network).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public Network getNetwork(String network, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Network)this.compute.networks().get(this.options.getProjectId(), network).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Network)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<Network>> listNetworks(Map<ComputeRpc.Option, ?> options) {
        try {
            NetworkList networkList = (NetworkList)this.compute.networks().list(this.options.getProjectId()).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
            List networks = networkList.getItems();
            return ComputeRpc.Tuple.of(networkList.getNextPageToken(), networks);
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public Operation deleteNetwork(String network, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.networks().delete(this.options.getProjectId(), network).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation createInstance(String zone, Instance instance, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.instances().insert(this.options.getProjectId(), zone, instance).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public Instance getInstance(String zone, String instance, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Instance)this.compute.instances().get(this.options.getProjectId(), zone, instance).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Instance)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<Instance>> listInstances(String zone, Map<ComputeRpc.Option, ?> options) {
        try {
            InstanceList instanceList = (InstanceList)this.compute.instances().list(this.options.getProjectId(), zone).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
            List instances = instanceList.getItems();
            return ComputeRpc.Tuple.of(instanceList.getNextPageToken(), instances);
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public ComputeRpc.Tuple<String, Iterable<Instance>> listInstances(Map<ComputeRpc.Option, ?> options) {
        try {
            InstanceAggregatedList aggregatedList = (InstanceAggregatedList)this.compute.instances().aggregatedList(this.options.getProjectId()).setFilter(ComputeRpc.Option.FILTER.getString(options)).setMaxResults(ComputeRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(ComputeRpc.Option.PAGE_TOKEN.getString(options)).execute();
            ImmutableList.Builder builder = ImmutableList.builder();
            Map scopedList = aggregatedList.getItems();
            if (scopedList != null) {
                for (InstancesScopedList instancesScopedList : scopedList.values()) {
                    if (instancesScopedList.getInstances() == null) continue;
                    builder.addAll((Iterable)instancesScopedList.getInstances());
                }
            }
            return ComputeRpc.Tuple.of(aggregatedList.getNextPageToken(), builder.build());
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public Operation deleteInstance(String zone, String instance, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.instances().delete(this.options.getProjectId(), zone, instance).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation addAccessConfig(String zone, String instance, String networkInterface, AccessConfig accessConfig, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.instances().addAccessConfig(this.options.getProjectId(), zone, instance, networkInterface, accessConfig).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public Operation attachDisk(String zone, String instance, AttachedDisk attachedDisk, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.instances().attachDisk(this.options.getProjectId(), zone, instance, attachedDisk).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw HttpComputeRpc.translate(ex);
        }
    }

    @Override
    public Operation deleteAccessConfig(String zone, String instance, String networkInterface, String accessConfig, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.instances().deleteAccessConfig(this.options.getProjectId(), zone, instance, accessConfig, networkInterface).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation detachDisk(String zone, String instance, String deviceName, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.instances().detachDisk(this.options.getProjectId(), zone, instance, deviceName).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public String getSerialPortOutput(String zone, String instance, Integer port, Map<ComputeRpc.Option, ?> options) {
        try {
            SerialPortOutput portOutput = (SerialPortOutput)this.compute.instances().getSerialPortOutput(this.options.getProjectId(), zone, instance).setPort(port).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
            return portOutput != null ? portOutput.getContents() : null;
        }
        catch (IOException ex) {
            return (String)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation reset(String zone, String instance, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.instances().reset(this.options.getProjectId(), zone, instance).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation setDiskAutoDelete(String zone, String instance, String deviceName, boolean autoDelete, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.instances().setDiskAutoDelete(this.options.getProjectId(), zone, instance, Boolean.valueOf(autoDelete), deviceName).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation setMachineType(String zone, String instance, String machineTypeUrl, Map<ComputeRpc.Option, ?> options) {
        try {
            InstancesSetMachineTypeRequest request = new InstancesSetMachineTypeRequest().setMachineType(machineTypeUrl);
            return (Operation)this.compute.instances().setMachineType(this.options.getProjectId(), zone, instance, request).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation setMetadata(String zone, String instance, Metadata metadata, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.instances().setMetadata(this.options.getProjectId(), zone, instance, metadata).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation setScheduling(String zone, String instance, Scheduling scheduling, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.instances().setScheduling(this.options.getProjectId(), zone, instance, scheduling).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation setTags(String zone, String instance, Tags tags, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.instances().setTags(this.options.getProjectId(), zone, instance, tags).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation start(String zone, String instance, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.instances().start(this.options.getProjectId(), zone, instance).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    @Override
    public Operation stop(String zone, String instance, Map<ComputeRpc.Option, ?> options) {
        try {
            return (Operation)this.compute.instances().stop(this.options.getProjectId(), zone, instance).setFields(ComputeRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            return (Operation)HttpComputeRpc.nullForNotFound(ex);
        }
    }

    private static <T> T nullForNotFound(IOException exception) {
        ComputeException serviceException = HttpComputeRpc.translate(exception);
        if (serviceException.getCode() == 404) {
            return null;
        }
        throw serviceException;
    }

    private static boolean falseForNotFound(IOException exception) {
        ComputeException serviceException = HttpComputeRpc.translate(exception);
        if (serviceException.getCode() == 404) {
            return false;
        }
        throw serviceException;
    }
}

