/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionPacketMirroringName
implements ResourceName {
    private final String packetMirroring;
    private final String project;
    private final String region;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/packetMirrorings/{packetMirroring}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionPacketMirroringName(Builder builder) {
        this.packetMirroring = (String)Preconditions.checkNotNull((Object)builder.getPacketMirroring());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
    }

    public static ProjectRegionPacketMirroringName of(String packetMirroring, String project, String region) {
        return ProjectRegionPacketMirroringName.newBuilder().setPacketMirroring(packetMirroring).setProject(project).setRegion(region).build();
    }

    public static String format(String packetMirroring, String project, String region) {
        return ProjectRegionPacketMirroringName.of(packetMirroring, project, region).toString();
    }

    public String getPacketMirroring() {
        return this.packetMirroring;
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionPacketMirroringName projectRegionPacketMirroringName = this;
            synchronized (projectRegionPacketMirroringName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"packetMirroring", (Object)this.packetMirroring);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionPacketMirroringName> newFactory() {
        return new ResourceNameFactory<ProjectRegionPacketMirroringName>(){

            public ProjectRegionPacketMirroringName parse(String formattedString) {
                return ProjectRegionPacketMirroringName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionPacketMirroringName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionPacketMirroringName.parse: formattedString not in valid format");
        return ProjectRegionPacketMirroringName.of((String)matchMap.get("packetMirroring"), (String)matchMap.get("project"), (String)matchMap.get("region"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"packetMirroring", this.packetMirroring, "project", this.project, "region", this.region});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionPacketMirroringName) {
            ProjectRegionPacketMirroringName that = (ProjectRegionPacketMirroringName)o;
            return Objects.equals(this.packetMirroring, that.getPacketMirroring()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.packetMirroring, this.project, this.region);
    }

    public static class Builder {
        private String packetMirroring;
        private String project;
        private String region;

        public String getPacketMirroring() {
            return this.packetMirroring;
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setPacketMirroring(String packetMirroring) {
            this.packetMirroring = packetMirroring;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionPacketMirroringName projectRegionPacketMirroringName) {
            this.packetMirroring = projectRegionPacketMirroringName.packetMirroring;
            this.project = projectRegionPacketMirroringName.project;
            this.region = projectRegionPacketMirroringName.region;
        }

        public ProjectRegionPacketMirroringName build() {
            return new ProjectRegionPacketMirroringName(this);
        }
    }
}

