/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionHealthCheckHttpRequest;
import com.google.cloud.compute.v1.GetRegionHealthCheckHttpRequest;
import com.google.cloud.compute.v1.HealthCheck;
import com.google.cloud.compute.v1.HealthCheckList;
import com.google.cloud.compute.v1.InsertRegionHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ListRegionHealthChecksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionHealthCheckHttpRequest;
import com.google.cloud.compute.v1.RegionHealthCheckClient;
import com.google.cloud.compute.v1.UpdateRegionHealthCheckHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonRegionHealthCheckStub;
import com.google.cloud.compute.v1.stub.RegionHealthCheckStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RegionHealthCheckStubSettings
extends StubSettings<RegionHealthCheckStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteRegionHealthCheckHttpRequest, Operation> deleteRegionHealthCheckSettings;
    private final UnaryCallSettings<GetRegionHealthCheckHttpRequest, HealthCheck> getRegionHealthCheckSettings;
    private final UnaryCallSettings<InsertRegionHealthCheckHttpRequest, Operation> insertRegionHealthCheckSettings;
    private final PagedCallSettings<ListRegionHealthChecksHttpRequest, HealthCheckList, RegionHealthCheckClient.ListRegionHealthChecksPagedResponse> listRegionHealthChecksSettings;
    private final UnaryCallSettings<PatchRegionHealthCheckHttpRequest, Operation> patchRegionHealthCheckSettings;
    private final UnaryCallSettings<UpdateRegionHealthCheckHttpRequest, Operation> updateRegionHealthCheckSettings;
    private static final PagedListDescriptor<ListRegionHealthChecksHttpRequest, HealthCheckList, HealthCheck> LIST_REGION_HEALTH_CHECKS_PAGE_STR_DESC = new PagedListDescriptor<ListRegionHealthChecksHttpRequest, HealthCheckList, HealthCheck>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionHealthChecksHttpRequest injectToken(ListRegionHealthChecksHttpRequest payload, String token) {
            return ListRegionHealthChecksHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListRegionHealthChecksHttpRequest injectPageSize(ListRegionHealthChecksHttpRequest payload, int pageSize) {
            return ListRegionHealthChecksHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionHealthChecksHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(HealthCheckList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<HealthCheck> extractResources(HealthCheckList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListRegionHealthChecksHttpRequest, HealthCheckList, RegionHealthCheckClient.ListRegionHealthChecksPagedResponse> LIST_REGION_HEALTH_CHECKS_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionHealthChecksHttpRequest, HealthCheckList, RegionHealthCheckClient.ListRegionHealthChecksPagedResponse>(){

        public ApiFuture<RegionHealthCheckClient.ListRegionHealthChecksPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionHealthChecksHttpRequest, HealthCheckList> callable, ListRegionHealthChecksHttpRequest request, ApiCallContext context, ApiFuture<HealthCheckList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REGION_HEALTH_CHECKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionHealthCheckClient.ListRegionHealthChecksPagedResponse.createAsync((PageContext<ListRegionHealthChecksHttpRequest, HealthCheckList, HealthCheck>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteRegionHealthCheckHttpRequest, Operation> deleteRegionHealthCheckSettings() {
        return this.deleteRegionHealthCheckSettings;
    }

    public UnaryCallSettings<GetRegionHealthCheckHttpRequest, HealthCheck> getRegionHealthCheckSettings() {
        return this.getRegionHealthCheckSettings;
    }

    public UnaryCallSettings<InsertRegionHealthCheckHttpRequest, Operation> insertRegionHealthCheckSettings() {
        return this.insertRegionHealthCheckSettings;
    }

    public PagedCallSettings<ListRegionHealthChecksHttpRequest, HealthCheckList, RegionHealthCheckClient.ListRegionHealthChecksPagedResponse> listRegionHealthChecksSettings() {
        return this.listRegionHealthChecksSettings;
    }

    public UnaryCallSettings<PatchRegionHealthCheckHttpRequest, Operation> patchRegionHealthCheckSettings() {
        return this.patchRegionHealthCheckSettings;
    }

    public UnaryCallSettings<UpdateRegionHealthCheckHttpRequest, Operation> updateRegionHealthCheckSettings() {
        return this.updateRegionHealthCheckSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionHealthCheckStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionHealthCheckStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionHealthCheckStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionHealthCheckStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionHealthCheckStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteRegionHealthCheckSettings = settingsBuilder.deleteRegionHealthCheckSettings().build();
        this.getRegionHealthCheckSettings = settingsBuilder.getRegionHealthCheckSettings().build();
        this.insertRegionHealthCheckSettings = settingsBuilder.insertRegionHealthCheckSettings().build();
        this.listRegionHealthChecksSettings = settingsBuilder.listRegionHealthChecksSettings().build();
        this.patchRegionHealthCheckSettings = settingsBuilder.patchRegionHealthCheckSettings().build();
        this.updateRegionHealthCheckSettings = settingsBuilder.updateRegionHealthCheckSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionHealthCheckStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteRegionHealthCheckHttpRequest, Operation> deleteRegionHealthCheckSettings;
        private final UnaryCallSettings.Builder<GetRegionHealthCheckHttpRequest, HealthCheck> getRegionHealthCheckSettings;
        private final UnaryCallSettings.Builder<InsertRegionHealthCheckHttpRequest, Operation> insertRegionHealthCheckSettings;
        private final PagedCallSettings.Builder<ListRegionHealthChecksHttpRequest, HealthCheckList, RegionHealthCheckClient.ListRegionHealthChecksPagedResponse> listRegionHealthChecksSettings;
        private final UnaryCallSettings.Builder<PatchRegionHealthCheckHttpRequest, Operation> patchRegionHealthCheckSettings;
        private final UnaryCallSettings.Builder<UpdateRegionHealthCheckHttpRequest, Operation> updateRegionHealthCheckSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteRegionHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRegionHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertRegionHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRegionHealthChecksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REGION_HEALTH_CHECKS_PAGE_STR_FACT);
            this.patchRegionHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRegionHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionHealthCheckSettings, this.getRegionHealthCheckSettings, this.insertRegionHealthCheckSettings, this.listRegionHealthChecksSettings, this.patchRegionHealthCheckSettings, this.updateRegionHealthCheckSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionHealthCheckStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionHealthCheckStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionHealthCheckStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionHealthCheckStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteRegionHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRegionHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertRegionHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRegionHealthChecksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchRegionHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateRegionHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RegionHealthCheckStubSettings settings) {
            super((StubSettings)settings);
            this.deleteRegionHealthCheckSettings = settings.deleteRegionHealthCheckSettings.toBuilder();
            this.getRegionHealthCheckSettings = settings.getRegionHealthCheckSettings.toBuilder();
            this.insertRegionHealthCheckSettings = settings.insertRegionHealthCheckSettings.toBuilder();
            this.listRegionHealthChecksSettings = settings.listRegionHealthChecksSettings.toBuilder();
            this.patchRegionHealthCheckSettings = settings.patchRegionHealthCheckSettings.toBuilder();
            this.updateRegionHealthCheckSettings = settings.updateRegionHealthCheckSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionHealthCheckSettings, this.getRegionHealthCheckSettings, this.insertRegionHealthCheckSettings, this.listRegionHealthChecksSettings, this.patchRegionHealthCheckSettings, this.updateRegionHealthCheckSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteRegionHealthCheckHttpRequest, Operation> deleteRegionHealthCheckSettings() {
            return this.deleteRegionHealthCheckSettings;
        }

        public UnaryCallSettings.Builder<GetRegionHealthCheckHttpRequest, HealthCheck> getRegionHealthCheckSettings() {
            return this.getRegionHealthCheckSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionHealthCheckHttpRequest, Operation> insertRegionHealthCheckSettings() {
            return this.insertRegionHealthCheckSettings;
        }

        public PagedCallSettings.Builder<ListRegionHealthChecksHttpRequest, HealthCheckList, RegionHealthCheckClient.ListRegionHealthChecksPagedResponse> listRegionHealthChecksSettings() {
            return this.listRegionHealthChecksSettings;
        }

        public UnaryCallSettings.Builder<PatchRegionHealthCheckHttpRequest, Operation> patchRegionHealthCheckSettings() {
            return this.patchRegionHealthCheckSettings;
        }

        public UnaryCallSettings.Builder<UpdateRegionHealthCheckHttpRequest, Operation> updateRegionHealthCheckSettings() {
            return this.updateRegionHealthCheckSettings;
        }

        public RegionHealthCheckStubSettings build() throws IOException {
            return new RegionHealthCheckStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

