/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListPacketMirroringsHttpRequest;
import com.google.cloud.compute.v1.DeletePacketMirroringHttpRequest;
import com.google.cloud.compute.v1.GetPacketMirroringHttpRequest;
import com.google.cloud.compute.v1.InsertPacketMirroringHttpRequest;
import com.google.cloud.compute.v1.ListPacketMirroringsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PacketMirroring;
import com.google.cloud.compute.v1.PacketMirroringAggregatedList;
import com.google.cloud.compute.v1.PacketMirroringClient;
import com.google.cloud.compute.v1.PacketMirroringList;
import com.google.cloud.compute.v1.PacketMirroringsScopedList;
import com.google.cloud.compute.v1.PatchPacketMirroringHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsPacketMirroringHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonPacketMirroringStub;
import com.google.cloud.compute.v1.stub.PacketMirroringStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class PacketMirroringStubSettings
extends StubSettings<PacketMirroringStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList, PacketMirroringClient.AggregatedListPacketMirroringsPagedResponse> aggregatedListPacketMirroringsSettings;
    private final UnaryCallSettings<DeletePacketMirroringHttpRequest, Operation> deletePacketMirroringSettings;
    private final UnaryCallSettings<GetPacketMirroringHttpRequest, PacketMirroring> getPacketMirroringSettings;
    private final UnaryCallSettings<InsertPacketMirroringHttpRequest, Operation> insertPacketMirroringSettings;
    private final PagedCallSettings<ListPacketMirroringsHttpRequest, PacketMirroringList, PacketMirroringClient.ListPacketMirroringsPagedResponse> listPacketMirroringsSettings;
    private final UnaryCallSettings<PatchPacketMirroringHttpRequest, Operation> patchPacketMirroringSettings;
    private final UnaryCallSettings<TestIamPermissionsPacketMirroringHttpRequest, TestPermissionsResponse> testIamPermissionsPacketMirroringSettings;
    private static final PagedListDescriptor<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList, PacketMirroringsScopedList> AGGREGATED_LIST_PACKET_MIRRORINGS_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList, PacketMirroringsScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListPacketMirroringsHttpRequest injectToken(AggregatedListPacketMirroringsHttpRequest payload, String token) {
            return AggregatedListPacketMirroringsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListPacketMirroringsHttpRequest injectPageSize(AggregatedListPacketMirroringsHttpRequest payload, int pageSize) {
            return AggregatedListPacketMirroringsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListPacketMirroringsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(PacketMirroringAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PacketMirroringsScopedList> extractResources(PacketMirroringAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListPacketMirroringsHttpRequest, PacketMirroringList, PacketMirroring> LIST_PACKET_MIRRORINGS_PAGE_STR_DESC = new PagedListDescriptor<ListPacketMirroringsHttpRequest, PacketMirroringList, PacketMirroring>(){

        public String emptyToken() {
            return "";
        }

        public ListPacketMirroringsHttpRequest injectToken(ListPacketMirroringsHttpRequest payload, String token) {
            return ListPacketMirroringsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListPacketMirroringsHttpRequest injectPageSize(ListPacketMirroringsHttpRequest payload, int pageSize) {
            return ListPacketMirroringsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListPacketMirroringsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(PacketMirroringList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PacketMirroring> extractResources(PacketMirroringList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList, PacketMirroringClient.AggregatedListPacketMirroringsPagedResponse> AGGREGATED_LIST_PACKET_MIRRORINGS_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList, PacketMirroringClient.AggregatedListPacketMirroringsPagedResponse>(){

        public ApiFuture<PacketMirroringClient.AggregatedListPacketMirroringsPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList> callable, AggregatedListPacketMirroringsHttpRequest request, ApiCallContext context, ApiFuture<PacketMirroringAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PACKET_MIRRORINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PacketMirroringClient.AggregatedListPacketMirroringsPagedResponse.createAsync((PageContext<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList, PacketMirroringsScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPacketMirroringsHttpRequest, PacketMirroringList, PacketMirroringClient.ListPacketMirroringsPagedResponse> LIST_PACKET_MIRRORINGS_PAGE_STR_FACT = new PagedListResponseFactory<ListPacketMirroringsHttpRequest, PacketMirroringList, PacketMirroringClient.ListPacketMirroringsPagedResponse>(){

        public ApiFuture<PacketMirroringClient.ListPacketMirroringsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPacketMirroringsHttpRequest, PacketMirroringList> callable, ListPacketMirroringsHttpRequest request, ApiCallContext context, ApiFuture<PacketMirroringList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PACKET_MIRRORINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PacketMirroringClient.ListPacketMirroringsPagedResponse.createAsync((PageContext<ListPacketMirroringsHttpRequest, PacketMirroringList, PacketMirroring>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList, PacketMirroringClient.AggregatedListPacketMirroringsPagedResponse> aggregatedListPacketMirroringsSettings() {
        return this.aggregatedListPacketMirroringsSettings;
    }

    public UnaryCallSettings<DeletePacketMirroringHttpRequest, Operation> deletePacketMirroringSettings() {
        return this.deletePacketMirroringSettings;
    }

    public UnaryCallSettings<GetPacketMirroringHttpRequest, PacketMirroring> getPacketMirroringSettings() {
        return this.getPacketMirroringSettings;
    }

    public UnaryCallSettings<InsertPacketMirroringHttpRequest, Operation> insertPacketMirroringSettings() {
        return this.insertPacketMirroringSettings;
    }

    public PagedCallSettings<ListPacketMirroringsHttpRequest, PacketMirroringList, PacketMirroringClient.ListPacketMirroringsPagedResponse> listPacketMirroringsSettings() {
        return this.listPacketMirroringsSettings;
    }

    public UnaryCallSettings<PatchPacketMirroringHttpRequest, Operation> patchPacketMirroringSettings() {
        return this.patchPacketMirroringSettings;
    }

    public UnaryCallSettings<TestIamPermissionsPacketMirroringHttpRequest, TestPermissionsResponse> testIamPermissionsPacketMirroringSettings() {
        return this.testIamPermissionsPacketMirroringSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public PacketMirroringStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPacketMirroringStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PacketMirroringStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PacketMirroringStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PacketMirroringStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListPacketMirroringsSettings = settingsBuilder.aggregatedListPacketMirroringsSettings().build();
        this.deletePacketMirroringSettings = settingsBuilder.deletePacketMirroringSettings().build();
        this.getPacketMirroringSettings = settingsBuilder.getPacketMirroringSettings().build();
        this.insertPacketMirroringSettings = settingsBuilder.insertPacketMirroringSettings().build();
        this.listPacketMirroringsSettings = settingsBuilder.listPacketMirroringsSettings().build();
        this.patchPacketMirroringSettings = settingsBuilder.patchPacketMirroringSettings().build();
        this.testIamPermissionsPacketMirroringSettings = settingsBuilder.testIamPermissionsPacketMirroringSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PacketMirroringStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList, PacketMirroringClient.AggregatedListPacketMirroringsPagedResponse> aggregatedListPacketMirroringsSettings;
        private final UnaryCallSettings.Builder<DeletePacketMirroringHttpRequest, Operation> deletePacketMirroringSettings;
        private final UnaryCallSettings.Builder<GetPacketMirroringHttpRequest, PacketMirroring> getPacketMirroringSettings;
        private final UnaryCallSettings.Builder<InsertPacketMirroringHttpRequest, Operation> insertPacketMirroringSettings;
        private final PagedCallSettings.Builder<ListPacketMirroringsHttpRequest, PacketMirroringList, PacketMirroringClient.ListPacketMirroringsPagedResponse> listPacketMirroringsSettings;
        private final UnaryCallSettings.Builder<PatchPacketMirroringHttpRequest, Operation> patchPacketMirroringSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsPacketMirroringHttpRequest, TestPermissionsResponse> testIamPermissionsPacketMirroringSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListPacketMirroringsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PACKET_MIRRORINGS_PAGE_STR_FACT);
            this.deletePacketMirroringSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getPacketMirroringSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertPacketMirroringSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPacketMirroringsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PACKET_MIRRORINGS_PAGE_STR_FACT);
            this.patchPacketMirroringSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsPacketMirroringSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListPacketMirroringsSettings, this.deletePacketMirroringSettings, this.getPacketMirroringSettings, this.insertPacketMirroringSettings, this.listPacketMirroringsSettings, this.patchPacketMirroringSettings, this.testIamPermissionsPacketMirroringSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PacketMirroringStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PacketMirroringStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PacketMirroringStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(PacketMirroringStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListPacketMirroringsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deletePacketMirroringSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getPacketMirroringSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertPacketMirroringSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listPacketMirroringsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchPacketMirroringSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsPacketMirroringSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(PacketMirroringStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListPacketMirroringsSettings = settings.aggregatedListPacketMirroringsSettings.toBuilder();
            this.deletePacketMirroringSettings = settings.deletePacketMirroringSettings.toBuilder();
            this.getPacketMirroringSettings = settings.getPacketMirroringSettings.toBuilder();
            this.insertPacketMirroringSettings = settings.insertPacketMirroringSettings.toBuilder();
            this.listPacketMirroringsSettings = settings.listPacketMirroringsSettings.toBuilder();
            this.patchPacketMirroringSettings = settings.patchPacketMirroringSettings.toBuilder();
            this.testIamPermissionsPacketMirroringSettings = settings.testIamPermissionsPacketMirroringSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListPacketMirroringsSettings, this.deletePacketMirroringSettings, this.getPacketMirroringSettings, this.insertPacketMirroringSettings, this.listPacketMirroringsSettings, this.patchPacketMirroringSettings, this.testIamPermissionsPacketMirroringSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList, PacketMirroringClient.AggregatedListPacketMirroringsPagedResponse> aggregatedListPacketMirroringsSettings() {
            return this.aggregatedListPacketMirroringsSettings;
        }

        public UnaryCallSettings.Builder<DeletePacketMirroringHttpRequest, Operation> deletePacketMirroringSettings() {
            return this.deletePacketMirroringSettings;
        }

        public UnaryCallSettings.Builder<GetPacketMirroringHttpRequest, PacketMirroring> getPacketMirroringSettings() {
            return this.getPacketMirroringSettings;
        }

        public UnaryCallSettings.Builder<InsertPacketMirroringHttpRequest, Operation> insertPacketMirroringSettings() {
            return this.insertPacketMirroringSettings;
        }

        public PagedCallSettings.Builder<ListPacketMirroringsHttpRequest, PacketMirroringList, PacketMirroringClient.ListPacketMirroringsPagedResponse> listPacketMirroringsSettings() {
            return this.listPacketMirroringsSettings;
        }

        public UnaryCallSettings.Builder<PatchPacketMirroringHttpRequest, Operation> patchPacketMirroringSettings() {
            return this.patchPacketMirroringSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsPacketMirroringHttpRequest, TestPermissionsResponse> testIamPermissionsPacketMirroringSettings() {
            return this.testIamPermissionsPacketMirroringSettings;
        }

        public PacketMirroringStubSettings build() throws IOException {
            return new PacketMirroringStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

