/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.HealthCheckReference;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class TargetPoolsRemoveHealthCheckRequest
implements ApiMessage {
    private final List<HealthCheckReference> healthChecks;
    private static final TargetPoolsRemoveHealthCheckRequest DEFAULT_INSTANCE = new TargetPoolsRemoveHealthCheckRequest();

    private TargetPoolsRemoveHealthCheckRequest() {
        this.healthChecks = null;
    }

    private TargetPoolsRemoveHealthCheckRequest(List<HealthCheckReference> healthChecks) {
        this.healthChecks = healthChecks;
    }

    public Object getFieldValue(String fieldName) {
        if ("healthChecks".equals(fieldName)) {
            return this.healthChecks;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<HealthCheckReference> getHealthChecksList() {
        return this.healthChecks;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TargetPoolsRemoveHealthCheckRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static TargetPoolsRemoveHealthCheckRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "TargetPoolsRemoveHealthCheckRequest{healthChecks=" + this.healthChecks + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TargetPoolsRemoveHealthCheckRequest) {
            TargetPoolsRemoveHealthCheckRequest that = (TargetPoolsRemoveHealthCheckRequest)o;
            return Objects.equals(this.healthChecks, that.getHealthChecksList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.healthChecks);
    }

    public static class Builder {
        private List<HealthCheckReference> healthChecks;

        Builder() {
        }

        public Builder mergeFrom(TargetPoolsRemoveHealthCheckRequest other) {
            if (other == TargetPoolsRemoveHealthCheckRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getHealthChecksList() != null) {
                this.healthChecks = other.healthChecks;
            }
            return this;
        }

        Builder(TargetPoolsRemoveHealthCheckRequest source) {
            this.healthChecks = source.healthChecks;
        }

        public List<HealthCheckReference> getHealthChecksList() {
            return this.healthChecks;
        }

        public Builder addAllHealthChecks(List<HealthCheckReference> healthChecks) {
            if (this.healthChecks == null) {
                this.healthChecks = new LinkedList<HealthCheckReference>();
            }
            this.healthChecks.addAll(healthChecks);
            return this;
        }

        public Builder addHealthChecks(HealthCheckReference healthChecks) {
            if (this.healthChecks == null) {
                this.healthChecks = new LinkedList<HealthCheckReference>();
            }
            this.healthChecks.add(healthChecks);
            return this;
        }

        public TargetPoolsRemoveHealthCheckRequest build() {
            return new TargetPoolsRemoveHealthCheckRequest(this.healthChecks);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllHealthChecks(this.healthChecks);
            return newBuilder;
        }
    }
}

