/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class SchedulingNodeAffinity
implements ApiMessage {
    private final String key;
    private final String operator;
    private final List<String> values;
    private static final SchedulingNodeAffinity DEFAULT_INSTANCE = new SchedulingNodeAffinity();

    private SchedulingNodeAffinity() {
        this.key = null;
        this.operator = null;
        this.values = null;
    }

    private SchedulingNodeAffinity(String key, String operator, List<String> values) {
        this.key = key;
        this.operator = operator;
        this.values = values;
    }

    public Object getFieldValue(String fieldName) {
        if ("key".equals(fieldName)) {
            return this.key;
        }
        if ("operator".equals(fieldName)) {
            return this.operator;
        }
        if ("values".equals(fieldName)) {
            return this.values;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public String getOperator() {
        return this.operator;
    }

    public List<String> getValuesList() {
        return this.values;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SchedulingNodeAffinity prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static SchedulingNodeAffinity getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "SchedulingNodeAffinity{key=" + this.key + ", operator=" + this.operator + ", values=" + this.values + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SchedulingNodeAffinity) {
            SchedulingNodeAffinity that = (SchedulingNodeAffinity)o;
            return Objects.equals(this.key, that.getKey()) && Objects.equals(this.operator, that.getOperator()) && Objects.equals(this.values, that.getValuesList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.operator, this.values);
    }

    public static class Builder {
        private String key;
        private String operator;
        private List<String> values;

        Builder() {
        }

        public Builder mergeFrom(SchedulingNodeAffinity other) {
            if (other == SchedulingNodeAffinity.getDefaultInstance()) {
                return this;
            }
            if (other.getKey() != null) {
                this.key = other.key;
            }
            if (other.getOperator() != null) {
                this.operator = other.operator;
            }
            if (other.getValuesList() != null) {
                this.values = other.values;
            }
            return this;
        }

        Builder(SchedulingNodeAffinity source) {
            this.key = source.key;
            this.operator = source.operator;
            this.values = source.values;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public String getOperator() {
            return this.operator;
        }

        public Builder setOperator(String operator) {
            this.operator = operator;
            return this;
        }

        public List<String> getValuesList() {
            return this.values;
        }

        public Builder addAllValues(List<String> values) {
            if (this.values == null) {
                this.values = new LinkedList<String>();
            }
            this.values.addAll(values);
            return this;
        }

        public Builder addValues(String values) {
            if (this.values == null) {
                this.values = new LinkedList<String>();
            }
            this.values.add(values);
            return this;
        }

        public SchedulingNodeAffinity build() {
            return new SchedulingNodeAffinity(this.key, this.operator, this.values);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setKey(this.key);
            newBuilder.setOperator(this.operator);
            newBuilder.addAllValues(this.values);
            return newBuilder;
        }
    }
}

