/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class RouterAdvertisedIpRange
implements ApiMessage {
    private final String description;
    private final String range;
    private static final RouterAdvertisedIpRange DEFAULT_INSTANCE = new RouterAdvertisedIpRange();

    private RouterAdvertisedIpRange() {
        this.description = null;
        this.range = null;
    }

    private RouterAdvertisedIpRange(String description, String range) {
        this.description = description;
        this.range = range;
    }

    public Object getFieldValue(String fieldName) {
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("range".equals(fieldName)) {
            return this.range;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRange() {
        return this.range;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(RouterAdvertisedIpRange prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static RouterAdvertisedIpRange getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "RouterAdvertisedIpRange{description=" + this.description + ", range=" + this.range + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RouterAdvertisedIpRange) {
            RouterAdvertisedIpRange that = (RouterAdvertisedIpRange)o;
            return Objects.equals(this.description, that.getDescription()) && Objects.equals(this.range, that.getRange());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.description, this.range);
    }

    public static class Builder {
        private String description;
        private String range;

        Builder() {
        }

        public Builder mergeFrom(RouterAdvertisedIpRange other) {
            if (other == RouterAdvertisedIpRange.getDefaultInstance()) {
                return this;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getRange() != null) {
                this.range = other.range;
            }
            return this;
        }

        Builder(RouterAdvertisedIpRange source) {
            this.description = source.description;
            this.range = source.range;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getRange() {
            return this.range;
        }

        public Builder setRange(String range) {
            this.range = range;
            return this;
        }

        public RouterAdvertisedIpRange build() {
            return new RouterAdvertisedIpRange(this.description, this.range);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setDescription(this.description);
            newBuilder.setRange(this.range);
            return newBuilder;
        }
    }
}

