/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.ManagedInstance;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceGroupManagersListManagedInstancesResponse
implements ApiMessage {
    private final List<ManagedInstance> managedInstances;
    private final String nextPageToken;
    private static final InstanceGroupManagersListManagedInstancesResponse DEFAULT_INSTANCE = new InstanceGroupManagersListManagedInstancesResponse();

    private InstanceGroupManagersListManagedInstancesResponse() {
        this.managedInstances = null;
        this.nextPageToken = null;
    }

    private InstanceGroupManagersListManagedInstancesResponse(List<ManagedInstance> managedInstances, String nextPageToken) {
        this.managedInstances = managedInstances;
        this.nextPageToken = nextPageToken;
    }

    public Object getFieldValue(String fieldName) {
        if ("managedInstances".equals(fieldName)) {
            return this.managedInstances;
        }
        if ("nextPageToken".equals(fieldName)) {
            return this.nextPageToken;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<ManagedInstance> getManagedInstancesList() {
        return this.managedInstances;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceGroupManagersListManagedInstancesResponse prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceGroupManagersListManagedInstancesResponse getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceGroupManagersListManagedInstancesResponse{managedInstances=" + this.managedInstances + ", nextPageToken=" + this.nextPageToken + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceGroupManagersListManagedInstancesResponse) {
            InstanceGroupManagersListManagedInstancesResponse that = (InstanceGroupManagersListManagedInstancesResponse)o;
            return Objects.equals(this.managedInstances, that.getManagedInstancesList()) && Objects.equals(this.nextPageToken, that.getNextPageToken());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.managedInstances, this.nextPageToken);
    }

    public static class Builder {
        private List<ManagedInstance> managedInstances;
        private String nextPageToken;

        Builder() {
        }

        public Builder mergeFrom(InstanceGroupManagersListManagedInstancesResponse other) {
            if (other == InstanceGroupManagersListManagedInstancesResponse.getDefaultInstance()) {
                return this;
            }
            if (other.getManagedInstancesList() != null) {
                this.managedInstances = other.managedInstances;
            }
            if (other.getNextPageToken() != null) {
                this.nextPageToken = other.nextPageToken;
            }
            return this;
        }

        Builder(InstanceGroupManagersListManagedInstancesResponse source) {
            this.managedInstances = source.managedInstances;
            this.nextPageToken = source.nextPageToken;
        }

        public List<ManagedInstance> getManagedInstancesList() {
            return this.managedInstances;
        }

        public Builder addAllManagedInstances(List<ManagedInstance> managedInstances) {
            if (this.managedInstances == null) {
                this.managedInstances = new LinkedList<ManagedInstance>();
            }
            this.managedInstances.addAll(managedInstances);
            return this;
        }

        public Builder addManagedInstances(ManagedInstance managedInstances) {
            if (this.managedInstances == null) {
                this.managedInstances = new LinkedList<ManagedInstance>();
            }
            this.managedInstances.add(managedInstances);
            return this;
        }

        public String getNextPageToken() {
            return this.nextPageToken;
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public InstanceGroupManagersListManagedInstancesResponse build() {
            return new InstanceGroupManagersListManagedInstancesResponse(this.managedInstances, this.nextPageToken);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllManagedInstances(this.managedInstances);
            newBuilder.setNextPageToken(this.nextPageToken);
            return newBuilder;
        }
    }
}

