/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.BackendService;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InsertBackendServiceHttpRequest
implements ApiMessage {
    private final String access_token;
    private final BackendService backendServiceResource;
    private final String callback;
    private final String fields;
    private final String key;
    private final String prettyPrint;
    private final String project;
    private final String quotaUser;
    private final String requestId;
    private final String userIp;
    private static final InsertBackendServiceHttpRequest DEFAULT_INSTANCE = new InsertBackendServiceHttpRequest();

    private InsertBackendServiceHttpRequest() {
        this.access_token = null;
        this.backendServiceResource = null;
        this.callback = null;
        this.fields = null;
        this.key = null;
        this.prettyPrint = null;
        this.project = null;
        this.quotaUser = null;
        this.requestId = null;
        this.userIp = null;
    }

    private InsertBackendServiceHttpRequest(String access_token, BackendService backendServiceResource, String callback, String fields, String key, String prettyPrint, String project, String quotaUser, String requestId, String userIp) {
        this.access_token = access_token;
        this.backendServiceResource = backendServiceResource;
        this.callback = callback;
        this.fields = fields;
        this.key = key;
        this.prettyPrint = prettyPrint;
        this.project = project;
        this.quotaUser = quotaUser;
        this.requestId = requestId;
        this.userIp = userIp;
    }

    public Object getFieldValue(String fieldName) {
        if ("access_token".equals(fieldName)) {
            return this.access_token;
        }
        if ("backendServiceResource".equals(fieldName)) {
            return this.backendServiceResource;
        }
        if ("callback".equals(fieldName)) {
            return this.callback;
        }
        if ("fields".equals(fieldName)) {
            return this.fields;
        }
        if ("key".equals(fieldName)) {
            return this.key;
        }
        if ("prettyPrint".equals(fieldName)) {
            return this.prettyPrint;
        }
        if ("project".equals(fieldName)) {
            return this.project;
        }
        if ("quotaUser".equals(fieldName)) {
            return this.quotaUser;
        }
        if ("requestId".equals(fieldName)) {
            return this.requestId;
        }
        if ("userIp".equals(fieldName)) {
            return this.userIp;
        }
        return null;
    }

    @Nullable
    public BackendService getApiMessageRequestBody() {
        return this.backendServiceResource;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAccessToken() {
        return this.access_token;
    }

    public BackendService getBackendServiceResource() {
        return this.backendServiceResource;
    }

    public String getCallback() {
        return this.callback;
    }

    public String getFields() {
        return this.fields;
    }

    public String getKey() {
        return this.key;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public String getProject() {
        return this.project;
    }

    public String getQuotaUser() {
        return this.quotaUser;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InsertBackendServiceHttpRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InsertBackendServiceHttpRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InsertBackendServiceHttpRequest{access_token=" + this.access_token + ", backendServiceResource=" + this.backendServiceResource + ", callback=" + this.callback + ", fields=" + this.fields + ", key=" + this.key + ", prettyPrint=" + this.prettyPrint + ", project=" + this.project + ", quotaUser=" + this.quotaUser + ", requestId=" + this.requestId + ", userIp=" + this.userIp + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InsertBackendServiceHttpRequest) {
            InsertBackendServiceHttpRequest that = (InsertBackendServiceHttpRequest)o;
            return Objects.equals(this.access_token, that.getAccessToken()) && Objects.equals(this.backendServiceResource, that.getBackendServiceResource()) && Objects.equals(this.callback, that.getCallback()) && Objects.equals(this.fields, that.getFields()) && Objects.equals(this.key, that.getKey()) && Objects.equals(this.prettyPrint, that.getPrettyPrint()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.quotaUser, that.getQuotaUser()) && Objects.equals(this.requestId, that.getRequestId()) && Objects.equals(this.userIp, that.getUserIp());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.access_token, this.backendServiceResource, this.callback, this.fields, this.key, this.prettyPrint, this.project, this.quotaUser, this.requestId, this.userIp);
    }

    public static class Builder {
        private String access_token;
        private BackendService backendServiceResource;
        private String callback;
        private String fields;
        private String key;
        private String prettyPrint;
        private String project;
        private String quotaUser;
        private String requestId;
        private String userIp;

        Builder() {
        }

        public Builder mergeFrom(InsertBackendServiceHttpRequest other) {
            if (other == InsertBackendServiceHttpRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getAccessToken() != null) {
                this.access_token = other.access_token;
            }
            if (other.getBackendServiceResource() != null) {
                this.backendServiceResource = other.backendServiceResource;
            }
            if (other.getCallback() != null) {
                this.callback = other.callback;
            }
            if (other.getFields() != null) {
                this.fields = other.fields;
            }
            if (other.getKey() != null) {
                this.key = other.key;
            }
            if (other.getPrettyPrint() != null) {
                this.prettyPrint = other.prettyPrint;
            }
            if (other.getProject() != null) {
                this.project = other.project;
            }
            if (other.getQuotaUser() != null) {
                this.quotaUser = other.quotaUser;
            }
            if (other.getRequestId() != null) {
                this.requestId = other.requestId;
            }
            if (other.getUserIp() != null) {
                this.userIp = other.userIp;
            }
            return this;
        }

        Builder(InsertBackendServiceHttpRequest source) {
            this.access_token = source.access_token;
            this.backendServiceResource = source.backendServiceResource;
            this.callback = source.callback;
            this.fields = source.fields;
            this.key = source.key;
            this.prettyPrint = source.prettyPrint;
            this.project = source.project;
            this.quotaUser = source.quotaUser;
            this.requestId = source.requestId;
            this.userIp = source.userIp;
        }

        public String getAccessToken() {
            return this.access_token;
        }

        public Builder setAccessToken(String access_token) {
            this.access_token = access_token;
            return this;
        }

        public BackendService getBackendServiceResource() {
            return this.backendServiceResource;
        }

        public Builder setBackendServiceResource(BackendService backendServiceResource) {
            this.backendServiceResource = backendServiceResource;
            return this;
        }

        public String getCallback() {
            return this.callback;
        }

        public Builder setCallback(String callback) {
            this.callback = callback;
            return this;
        }

        public String getFields() {
            return this.fields;
        }

        public Builder setFields(String fields) {
            this.fields = fields;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public String getPrettyPrint() {
            return this.prettyPrint;
        }

        public Builder setPrettyPrint(String prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public String getQuotaUser() {
            return this.quotaUser;
        }

        public Builder setQuotaUser(String quotaUser) {
            this.quotaUser = quotaUser;
            return this;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public Builder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public String getUserIp() {
            return this.userIp;
        }

        public Builder setUserIp(String userIp) {
            this.userIp = userIp;
            return this;
        }

        public InsertBackendServiceHttpRequest build() {
            String missing = "";
            if (this.project == null) {
                missing = missing + " project";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new InsertBackendServiceHttpRequest(this.access_token, this.backendServiceResource, this.callback, this.fields, this.key, this.prettyPrint, this.project, this.quotaUser, this.requestId, this.userIp);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAccessToken(this.access_token);
            newBuilder.setBackendServiceResource(this.backendServiceResource);
            newBuilder.setCallback(this.callback);
            newBuilder.setFields(this.fields);
            newBuilder.setKey(this.key);
            newBuilder.setPrettyPrint(this.prettyPrint);
            newBuilder.setProject(this.project);
            newBuilder.setQuotaUser(this.quotaUser);
            newBuilder.setRequestId(this.requestId);
            newBuilder.setUserIp(this.userIp);
            return newBuilder;
        }
    }
}

