/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class HttpRetryPolicy
implements ApiMessage {
    private final Integer numRetries;
    private final Duration perTryTimeout;
    private final List<String> retryConditions;
    private static final HttpRetryPolicy DEFAULT_INSTANCE = new HttpRetryPolicy();

    private HttpRetryPolicy() {
        this.numRetries = null;
        this.perTryTimeout = null;
        this.retryConditions = null;
    }

    private HttpRetryPolicy(Integer numRetries, Duration perTryTimeout, List<String> retryConditions) {
        this.numRetries = numRetries;
        this.perTryTimeout = perTryTimeout;
        this.retryConditions = retryConditions;
    }

    public Object getFieldValue(String fieldName) {
        if ("numRetries".equals(fieldName)) {
            return this.numRetries;
        }
        if ("perTryTimeout".equals(fieldName)) {
            return this.perTryTimeout;
        }
        if ("retryConditions".equals(fieldName)) {
            return this.retryConditions;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Integer getNumRetries() {
        return this.numRetries;
    }

    public Duration getPerTryTimeout() {
        return this.perTryTimeout;
    }

    public List<String> getRetryConditionsList() {
        return this.retryConditions;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HttpRetryPolicy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static HttpRetryPolicy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "HttpRetryPolicy{numRetries=" + this.numRetries + ", perTryTimeout=" + this.perTryTimeout + ", retryConditions=" + this.retryConditions + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpRetryPolicy) {
            HttpRetryPolicy that = (HttpRetryPolicy)o;
            return Objects.equals(this.numRetries, that.getNumRetries()) && Objects.equals(this.perTryTimeout, that.getPerTryTimeout()) && Objects.equals(this.retryConditions, that.getRetryConditionsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.numRetries, this.perTryTimeout, this.retryConditions);
    }

    public static class Builder {
        private Integer numRetries;
        private Duration perTryTimeout;
        private List<String> retryConditions;

        Builder() {
        }

        public Builder mergeFrom(HttpRetryPolicy other) {
            if (other == HttpRetryPolicy.getDefaultInstance()) {
                return this;
            }
            if (other.getNumRetries() != null) {
                this.numRetries = other.numRetries;
            }
            if (other.getPerTryTimeout() != null) {
                this.perTryTimeout = other.perTryTimeout;
            }
            if (other.getRetryConditionsList() != null) {
                this.retryConditions = other.retryConditions;
            }
            return this;
        }

        Builder(HttpRetryPolicy source) {
            this.numRetries = source.numRetries;
            this.perTryTimeout = source.perTryTimeout;
            this.retryConditions = source.retryConditions;
        }

        public Integer getNumRetries() {
            return this.numRetries;
        }

        public Builder setNumRetries(Integer numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        public Duration getPerTryTimeout() {
            return this.perTryTimeout;
        }

        public Builder setPerTryTimeout(Duration perTryTimeout) {
            this.perTryTimeout = perTryTimeout;
            return this;
        }

        public List<String> getRetryConditionsList() {
            return this.retryConditions;
        }

        public Builder addAllRetryConditions(List<String> retryConditions) {
            if (this.retryConditions == null) {
                this.retryConditions = new LinkedList<String>();
            }
            this.retryConditions.addAll(retryConditions);
            return this;
        }

        public Builder addRetryConditions(String retryConditions) {
            if (this.retryConditions == null) {
                this.retryConditions = new LinkedList<String>();
            }
            this.retryConditions.add(retryConditions);
            return this;
        }

        public HttpRetryPolicy build() {
            return new HttpRetryPolicy(this.numRetries, this.perTryTimeout, this.retryConditions);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setNumRetries(this.numRetries);
            newBuilder.setPerTryTimeout(this.perTryTimeout);
            newBuilder.addAllRetryConditions(this.retryConditions);
            return newBuilder;
        }
    }
}

