/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.DiskType;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class DiskTypesScopedList
implements ApiMessage {
    private final List<DiskType> diskTypes;
    private final Warning warning;
    private static final DiskTypesScopedList DEFAULT_INSTANCE = new DiskTypesScopedList();

    private DiskTypesScopedList() {
        this.diskTypes = null;
        this.warning = null;
    }

    private DiskTypesScopedList(List<DiskType> diskTypes, Warning warning) {
        this.diskTypes = diskTypes;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("diskTypes".equals(fieldName)) {
            return this.diskTypes;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<DiskType> getDiskTypesList() {
        return this.diskTypes;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(DiskTypesScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static DiskTypesScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "DiskTypesScopedList{diskTypes=" + this.diskTypes + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DiskTypesScopedList) {
            DiskTypesScopedList that = (DiskTypesScopedList)o;
            return Objects.equals(this.diskTypes, that.getDiskTypesList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.diskTypes, this.warning);
    }

    public static class Builder {
        private List<DiskType> diskTypes;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(DiskTypesScopedList other) {
            if (other == DiskTypesScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getDiskTypesList() != null) {
                this.diskTypes = other.diskTypes;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(DiskTypesScopedList source) {
            this.diskTypes = source.diskTypes;
            this.warning = source.warning;
        }

        public List<DiskType> getDiskTypesList() {
            return this.diskTypes;
        }

        public Builder addAllDiskTypes(List<DiskType> diskTypes) {
            if (this.diskTypes == null) {
                this.diskTypes = new LinkedList<DiskType>();
            }
            this.diskTypes.addAll(diskTypes);
            return this;
        }

        public Builder addDiskTypes(DiskType diskTypes) {
            if (this.diskTypes == null) {
                this.diskTypes = new LinkedList<DiskType>();
            }
            this.diskTypes.add(diskTypes);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public DiskTypesScopedList build() {
            return new DiskTypesScopedList(this.diskTypes, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllDiskTypes(this.diskTypes);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

