/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.AcceleratorConfig;
import com.google.cloud.compute.v1.AttachedDisk;
import com.google.cloud.compute.v1.Metadata;
import com.google.cloud.compute.v1.NetworkInterface;
import com.google.cloud.compute.v1.ReservationAffinity;
import com.google.cloud.compute.v1.Scheduling;
import com.google.cloud.compute.v1.ServiceAccount;
import com.google.cloud.compute.v1.ShieldedInstanceConfig;
import com.google.cloud.compute.v1.Tags;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceProperties
implements ApiMessage {
    private final Boolean canIpForward;
    private final String description;
    private final List<AttachedDisk> disks;
    private final List<AcceleratorConfig> guestAccelerators;
    private final Map<String, String> labels;
    private final String machineType;
    private final Metadata metadata;
    private final String minCpuPlatform;
    private final List<NetworkInterface> networkInterfaces;
    private final String privateIpv6GoogleAccess;
    private final ReservationAffinity reservationAffinity;
    private final List<String> resourcePolicies;
    private final Scheduling scheduling;
    private final List<ServiceAccount> serviceAccounts;
    private final ShieldedInstanceConfig shieldedInstanceConfig;
    private final Tags tags;
    private static final InstanceProperties DEFAULT_INSTANCE = new InstanceProperties();

    private InstanceProperties() {
        this.canIpForward = null;
        this.description = null;
        this.disks = null;
        this.guestAccelerators = null;
        this.labels = null;
        this.machineType = null;
        this.metadata = null;
        this.minCpuPlatform = null;
        this.networkInterfaces = null;
        this.privateIpv6GoogleAccess = null;
        this.reservationAffinity = null;
        this.resourcePolicies = null;
        this.scheduling = null;
        this.serviceAccounts = null;
        this.shieldedInstanceConfig = null;
        this.tags = null;
    }

    private InstanceProperties(Boolean canIpForward, String description, List<AttachedDisk> disks, List<AcceleratorConfig> guestAccelerators, Map<String, String> labels, String machineType, Metadata metadata, String minCpuPlatform, List<NetworkInterface> networkInterfaces, String privateIpv6GoogleAccess, ReservationAffinity reservationAffinity, List<String> resourcePolicies, Scheduling scheduling, List<ServiceAccount> serviceAccounts, ShieldedInstanceConfig shieldedInstanceConfig, Tags tags) {
        this.canIpForward = canIpForward;
        this.description = description;
        this.disks = disks;
        this.guestAccelerators = guestAccelerators;
        this.labels = labels;
        this.machineType = machineType;
        this.metadata = metadata;
        this.minCpuPlatform = minCpuPlatform;
        this.networkInterfaces = networkInterfaces;
        this.privateIpv6GoogleAccess = privateIpv6GoogleAccess;
        this.reservationAffinity = reservationAffinity;
        this.resourcePolicies = resourcePolicies;
        this.scheduling = scheduling;
        this.serviceAccounts = serviceAccounts;
        this.shieldedInstanceConfig = shieldedInstanceConfig;
        this.tags = tags;
    }

    public Object getFieldValue(String fieldName) {
        if ("canIpForward".equals(fieldName)) {
            return this.canIpForward;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("disks".equals(fieldName)) {
            return this.disks;
        }
        if ("guestAccelerators".equals(fieldName)) {
            return this.guestAccelerators;
        }
        if ("labels".equals(fieldName)) {
            return this.labels;
        }
        if ("machineType".equals(fieldName)) {
            return this.machineType;
        }
        if ("metadata".equals(fieldName)) {
            return this.metadata;
        }
        if ("minCpuPlatform".equals(fieldName)) {
            return this.minCpuPlatform;
        }
        if ("networkInterfaces".equals(fieldName)) {
            return this.networkInterfaces;
        }
        if ("privateIpv6GoogleAccess".equals(fieldName)) {
            return this.privateIpv6GoogleAccess;
        }
        if ("reservationAffinity".equals(fieldName)) {
            return this.reservationAffinity;
        }
        if ("resourcePolicies".equals(fieldName)) {
            return this.resourcePolicies;
        }
        if ("scheduling".equals(fieldName)) {
            return this.scheduling;
        }
        if ("serviceAccounts".equals(fieldName)) {
            return this.serviceAccounts;
        }
        if ("shieldedInstanceConfig".equals(fieldName)) {
            return this.shieldedInstanceConfig;
        }
        if ("tags".equals(fieldName)) {
            return this.tags;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Boolean getCanIpForward() {
        return this.canIpForward;
    }

    public String getDescription() {
        return this.description;
    }

    public List<AttachedDisk> getDisksList() {
        return this.disks;
    }

    public List<AcceleratorConfig> getGuestAcceleratorsList() {
        return this.guestAccelerators;
    }

    public Map<String, String> getLabelsMap() {
        return this.labels;
    }

    public String getMachineType() {
        return this.machineType;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public String getMinCpuPlatform() {
        return this.minCpuPlatform;
    }

    public List<NetworkInterface> getNetworkInterfacesList() {
        return this.networkInterfaces;
    }

    public String getPrivateIpv6GoogleAccess() {
        return this.privateIpv6GoogleAccess;
    }

    public ReservationAffinity getReservationAffinity() {
        return this.reservationAffinity;
    }

    public List<String> getResourcePoliciesList() {
        return this.resourcePolicies;
    }

    public Scheduling getScheduling() {
        return this.scheduling;
    }

    public List<ServiceAccount> getServiceAccountsList() {
        return this.serviceAccounts;
    }

    public ShieldedInstanceConfig getShieldedInstanceConfig() {
        return this.shieldedInstanceConfig;
    }

    public Tags getTags() {
        return this.tags;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceProperties prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceProperties getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceProperties{canIpForward=" + this.canIpForward + ", description=" + this.description + ", disks=" + this.disks + ", guestAccelerators=" + this.guestAccelerators + ", labels=" + this.labels + ", machineType=" + this.machineType + ", metadata=" + this.metadata + ", minCpuPlatform=" + this.minCpuPlatform + ", networkInterfaces=" + this.networkInterfaces + ", privateIpv6GoogleAccess=" + this.privateIpv6GoogleAccess + ", reservationAffinity=" + this.reservationAffinity + ", resourcePolicies=" + this.resourcePolicies + ", scheduling=" + this.scheduling + ", serviceAccounts=" + this.serviceAccounts + ", shieldedInstanceConfig=" + this.shieldedInstanceConfig + ", tags=" + this.tags + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceProperties) {
            InstanceProperties that = (InstanceProperties)o;
            return Objects.equals(this.canIpForward, that.getCanIpForward()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.disks, that.getDisksList()) && Objects.equals(this.guestAccelerators, that.getGuestAcceleratorsList()) && Objects.equals(this.labels, that.getLabelsMap()) && Objects.equals(this.machineType, that.getMachineType()) && Objects.equals(this.metadata, that.getMetadata()) && Objects.equals(this.minCpuPlatform, that.getMinCpuPlatform()) && Objects.equals(this.networkInterfaces, that.getNetworkInterfacesList()) && Objects.equals(this.privateIpv6GoogleAccess, that.getPrivateIpv6GoogleAccess()) && Objects.equals(this.reservationAffinity, that.getReservationAffinity()) && Objects.equals(this.resourcePolicies, that.getResourcePoliciesList()) && Objects.equals(this.scheduling, that.getScheduling()) && Objects.equals(this.serviceAccounts, that.getServiceAccountsList()) && Objects.equals(this.shieldedInstanceConfig, that.getShieldedInstanceConfig()) && Objects.equals(this.tags, that.getTags());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.canIpForward, this.description, this.disks, this.guestAccelerators, this.labels, this.machineType, this.metadata, this.minCpuPlatform, this.networkInterfaces, this.privateIpv6GoogleAccess, this.reservationAffinity, this.resourcePolicies, this.scheduling, this.serviceAccounts, this.shieldedInstanceConfig, this.tags);
    }

    public static class Builder {
        private Boolean canIpForward;
        private String description;
        private List<AttachedDisk> disks;
        private List<AcceleratorConfig> guestAccelerators;
        private Map<String, String> labels;
        private String machineType;
        private Metadata metadata;
        private String minCpuPlatform;
        private List<NetworkInterface> networkInterfaces;
        private String privateIpv6GoogleAccess;
        private ReservationAffinity reservationAffinity;
        private List<String> resourcePolicies;
        private Scheduling scheduling;
        private List<ServiceAccount> serviceAccounts;
        private ShieldedInstanceConfig shieldedInstanceConfig;
        private Tags tags;

        Builder() {
        }

        public Builder mergeFrom(InstanceProperties other) {
            if (other == InstanceProperties.getDefaultInstance()) {
                return this;
            }
            if (other.getCanIpForward() != null) {
                this.canIpForward = other.canIpForward;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getDisksList() != null) {
                this.disks = other.disks;
            }
            if (other.getGuestAcceleratorsList() != null) {
                this.guestAccelerators = other.guestAccelerators;
            }
            if (other.getLabelsMap() != null) {
                this.labels = other.labels;
            }
            if (other.getMachineType() != null) {
                this.machineType = other.machineType;
            }
            if (other.getMetadata() != null) {
                this.metadata = other.metadata;
            }
            if (other.getMinCpuPlatform() != null) {
                this.minCpuPlatform = other.minCpuPlatform;
            }
            if (other.getNetworkInterfacesList() != null) {
                this.networkInterfaces = other.networkInterfaces;
            }
            if (other.getPrivateIpv6GoogleAccess() != null) {
                this.privateIpv6GoogleAccess = other.privateIpv6GoogleAccess;
            }
            if (other.getReservationAffinity() != null) {
                this.reservationAffinity = other.reservationAffinity;
            }
            if (other.getResourcePoliciesList() != null) {
                this.resourcePolicies = other.resourcePolicies;
            }
            if (other.getScheduling() != null) {
                this.scheduling = other.scheduling;
            }
            if (other.getServiceAccountsList() != null) {
                this.serviceAccounts = other.serviceAccounts;
            }
            if (other.getShieldedInstanceConfig() != null) {
                this.shieldedInstanceConfig = other.shieldedInstanceConfig;
            }
            if (other.getTags() != null) {
                this.tags = other.tags;
            }
            return this;
        }

        Builder(InstanceProperties source) {
            this.canIpForward = source.canIpForward;
            this.description = source.description;
            this.disks = source.disks;
            this.guestAccelerators = source.guestAccelerators;
            this.labels = source.labels;
            this.machineType = source.machineType;
            this.metadata = source.metadata;
            this.minCpuPlatform = source.minCpuPlatform;
            this.networkInterfaces = source.networkInterfaces;
            this.privateIpv6GoogleAccess = source.privateIpv6GoogleAccess;
            this.reservationAffinity = source.reservationAffinity;
            this.resourcePolicies = source.resourcePolicies;
            this.scheduling = source.scheduling;
            this.serviceAccounts = source.serviceAccounts;
            this.shieldedInstanceConfig = source.shieldedInstanceConfig;
            this.tags = source.tags;
        }

        public Boolean getCanIpForward() {
            return this.canIpForward;
        }

        public Builder setCanIpForward(Boolean canIpForward) {
            this.canIpForward = canIpForward;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public List<AttachedDisk> getDisksList() {
            return this.disks;
        }

        public Builder addAllDisks(List<AttachedDisk> disks) {
            if (this.disks == null) {
                this.disks = new LinkedList<AttachedDisk>();
            }
            this.disks.addAll(disks);
            return this;
        }

        public Builder addDisks(AttachedDisk disks) {
            if (this.disks == null) {
                this.disks = new LinkedList<AttachedDisk>();
            }
            this.disks.add(disks);
            return this;
        }

        public List<AcceleratorConfig> getGuestAcceleratorsList() {
            return this.guestAccelerators;
        }

        public Builder addAllGuestAccelerators(List<AcceleratorConfig> guestAccelerators) {
            if (this.guestAccelerators == null) {
                this.guestAccelerators = new LinkedList<AcceleratorConfig>();
            }
            this.guestAccelerators.addAll(guestAccelerators);
            return this;
        }

        public Builder addGuestAccelerators(AcceleratorConfig guestAccelerators) {
            if (this.guestAccelerators == null) {
                this.guestAccelerators = new LinkedList<AcceleratorConfig>();
            }
            this.guestAccelerators.add(guestAccelerators);
            return this;
        }

        public Map<String, String> getLabelsMap() {
            return this.labels;
        }

        public Builder putAllLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public String getMachineType() {
            return this.machineType;
        }

        public Builder setMachineType(String machineType) {
            this.machineType = machineType;
            return this;
        }

        public Metadata getMetadata() {
            return this.metadata;
        }

        public Builder setMetadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public String getMinCpuPlatform() {
            return this.minCpuPlatform;
        }

        public Builder setMinCpuPlatform(String minCpuPlatform) {
            this.minCpuPlatform = minCpuPlatform;
            return this;
        }

        public List<NetworkInterface> getNetworkInterfacesList() {
            return this.networkInterfaces;
        }

        public Builder addAllNetworkInterfaces(List<NetworkInterface> networkInterfaces) {
            if (this.networkInterfaces == null) {
                this.networkInterfaces = new LinkedList<NetworkInterface>();
            }
            this.networkInterfaces.addAll(networkInterfaces);
            return this;
        }

        public Builder addNetworkInterfaces(NetworkInterface networkInterfaces) {
            if (this.networkInterfaces == null) {
                this.networkInterfaces = new LinkedList<NetworkInterface>();
            }
            this.networkInterfaces.add(networkInterfaces);
            return this;
        }

        public String getPrivateIpv6GoogleAccess() {
            return this.privateIpv6GoogleAccess;
        }

        public Builder setPrivateIpv6GoogleAccess(String privateIpv6GoogleAccess) {
            this.privateIpv6GoogleAccess = privateIpv6GoogleAccess;
            return this;
        }

        public ReservationAffinity getReservationAffinity() {
            return this.reservationAffinity;
        }

        public Builder setReservationAffinity(ReservationAffinity reservationAffinity) {
            this.reservationAffinity = reservationAffinity;
            return this;
        }

        public List<String> getResourcePoliciesList() {
            return this.resourcePolicies;
        }

        public Builder addAllResourcePolicies(List<String> resourcePolicies) {
            if (this.resourcePolicies == null) {
                this.resourcePolicies = new LinkedList<String>();
            }
            this.resourcePolicies.addAll(resourcePolicies);
            return this;
        }

        public Builder addResourcePolicies(String resourcePolicies) {
            if (this.resourcePolicies == null) {
                this.resourcePolicies = new LinkedList<String>();
            }
            this.resourcePolicies.add(resourcePolicies);
            return this;
        }

        public Scheduling getScheduling() {
            return this.scheduling;
        }

        public Builder setScheduling(Scheduling scheduling) {
            this.scheduling = scheduling;
            return this;
        }

        public List<ServiceAccount> getServiceAccountsList() {
            return this.serviceAccounts;
        }

        public Builder addAllServiceAccounts(List<ServiceAccount> serviceAccounts) {
            if (this.serviceAccounts == null) {
                this.serviceAccounts = new LinkedList<ServiceAccount>();
            }
            this.serviceAccounts.addAll(serviceAccounts);
            return this;
        }

        public Builder addServiceAccounts(ServiceAccount serviceAccounts) {
            if (this.serviceAccounts == null) {
                this.serviceAccounts = new LinkedList<ServiceAccount>();
            }
            this.serviceAccounts.add(serviceAccounts);
            return this;
        }

        public ShieldedInstanceConfig getShieldedInstanceConfig() {
            return this.shieldedInstanceConfig;
        }

        public Builder setShieldedInstanceConfig(ShieldedInstanceConfig shieldedInstanceConfig) {
            this.shieldedInstanceConfig = shieldedInstanceConfig;
            return this;
        }

        public Tags getTags() {
            return this.tags;
        }

        public Builder setTags(Tags tags) {
            this.tags = tags;
            return this;
        }

        public InstanceProperties build() {
            return new InstanceProperties(this.canIpForward, this.description, this.disks, this.guestAccelerators, this.labels, this.machineType, this.metadata, this.minCpuPlatform, this.networkInterfaces, this.privateIpv6GoogleAccess, this.reservationAffinity, this.resourcePolicies, this.scheduling, this.serviceAccounts, this.shieldedInstanceConfig, this.tags);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCanIpForward(this.canIpForward);
            newBuilder.setDescription(this.description);
            newBuilder.addAllDisks(this.disks);
            newBuilder.addAllGuestAccelerators(this.guestAccelerators);
            newBuilder.putAllLabels(this.labels);
            newBuilder.setMachineType(this.machineType);
            newBuilder.setMetadata(this.metadata);
            newBuilder.setMinCpuPlatform(this.minCpuPlatform);
            newBuilder.addAllNetworkInterfaces(this.networkInterfaces);
            newBuilder.setPrivateIpv6GoogleAccess(this.privateIpv6GoogleAccess);
            newBuilder.setReservationAffinity(this.reservationAffinity);
            newBuilder.addAllResourcePolicies(this.resourcePolicies);
            newBuilder.setScheduling(this.scheduling);
            newBuilder.addAllServiceAccounts(this.serviceAccounts);
            newBuilder.setShieldedInstanceConfig(this.shieldedInstanceConfig);
            newBuilder.setTags(this.tags);
            return newBuilder;
        }
    }
}

