/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.DeleteRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.GetRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.InsertRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.ListRegionUrlMapsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionUrlMapName;
import com.google.cloud.compute.v1.RegionUrlMapClient;
import com.google.cloud.compute.v1.UpdateRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.UrlMap;
import com.google.cloud.compute.v1.UrlMapList;
import com.google.cloud.compute.v1.UrlMapsValidateResponse;
import com.google.cloud.compute.v1.ValidateRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonRegionUrlMapCallableFactory;
import com.google.cloud.compute.v1.stub.RegionUrlMapStub;
import com.google.cloud.compute.v1.stub.RegionUrlMapStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonRegionUrlMapStub
extends RegionUrlMapStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteRegionUrlMapHttpRequest, Operation> deleteRegionUrlMapMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionUrlMaps.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/urlMaps/{urlMap}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionUrlMapName.newFactory()).setResourceNameField("urlMap").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetRegionUrlMapHttpRequest, UrlMap> getRegionUrlMapMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionUrlMaps.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/urlMaps/{urlMap}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectRegionUrlMapName.newFactory()).setResourceNameField("urlMap").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)UrlMap.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertRegionUrlMapHttpRequest, Operation> insertRegionUrlMapMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionUrlMaps.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/urlMaps")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionName.newFactory()).setResourceNameField("region").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListRegionUrlMapsHttpRequest, UrlMapList> listRegionUrlMapsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionUrlMaps.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/urlMaps")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectRegionName.newFactory()).setResourceNameField("region").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)UrlMapList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<PatchRegionUrlMapHttpRequest, Operation> patchRegionUrlMapMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionUrlMaps.patch").setHttpMethod("PATCH").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/urlMaps/{urlMap}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionUrlMapName.newFactory()).setResourceNameField("urlMap").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<UpdateRegionUrlMapHttpRequest, Operation> updateRegionUrlMapMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionUrlMaps.update").setHttpMethod("PUT").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/urlMaps/{urlMap}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionUrlMapName.newFactory()).setResourceNameField("urlMap").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ValidateRegionUrlMapHttpRequest, UrlMapsValidateResponse> validateRegionUrlMapMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionUrlMaps.validate").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/urlMaps/{urlMap}/validate")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectRegionUrlMapName.newFactory()).setResourceNameField("urlMap").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)UrlMapsValidateResponse.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteRegionUrlMapHttpRequest, Operation> deleteRegionUrlMapCallable;
    private final UnaryCallable<GetRegionUrlMapHttpRequest, UrlMap> getRegionUrlMapCallable;
    private final UnaryCallable<InsertRegionUrlMapHttpRequest, Operation> insertRegionUrlMapCallable;
    private final UnaryCallable<ListRegionUrlMapsHttpRequest, UrlMapList> listRegionUrlMapsCallable;
    private final UnaryCallable<ListRegionUrlMapsHttpRequest, RegionUrlMapClient.ListRegionUrlMapsPagedResponse> listRegionUrlMapsPagedCallable;
    private final UnaryCallable<PatchRegionUrlMapHttpRequest, Operation> patchRegionUrlMapCallable;
    private final UnaryCallable<UpdateRegionUrlMapHttpRequest, Operation> updateRegionUrlMapCallable;
    private final UnaryCallable<ValidateRegionUrlMapHttpRequest, UrlMapsValidateResponse> validateRegionUrlMapCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonRegionUrlMapStub create(RegionUrlMapStubSettings settings) throws IOException {
        return new HttpJsonRegionUrlMapStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRegionUrlMapStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRegionUrlMapStub(RegionUrlMapStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonRegionUrlMapStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRegionUrlMapStub(RegionUrlMapStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRegionUrlMapStub(RegionUrlMapStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRegionUrlMapCallableFactory());
    }

    protected HttpJsonRegionUrlMapStub(RegionUrlMapStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteRegionUrlMapTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteRegionUrlMapMethodDescriptor).build();
        HttpJsonCallSettings getRegionUrlMapTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRegionUrlMapMethodDescriptor).build();
        HttpJsonCallSettings insertRegionUrlMapTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertRegionUrlMapMethodDescriptor).build();
        HttpJsonCallSettings listRegionUrlMapsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRegionUrlMapsMethodDescriptor).build();
        HttpJsonCallSettings patchRegionUrlMapTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchRegionUrlMapMethodDescriptor).build();
        HttpJsonCallSettings updateRegionUrlMapTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateRegionUrlMapMethodDescriptor).build();
        HttpJsonCallSettings validateRegionUrlMapTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(validateRegionUrlMapMethodDescriptor).build();
        this.deleteRegionUrlMapCallable = callableFactory.createUnaryCallable(deleteRegionUrlMapTransportSettings, settings.deleteRegionUrlMapSettings(), clientContext);
        this.getRegionUrlMapCallable = callableFactory.createUnaryCallable(getRegionUrlMapTransportSettings, settings.getRegionUrlMapSettings(), clientContext);
        this.insertRegionUrlMapCallable = callableFactory.createUnaryCallable(insertRegionUrlMapTransportSettings, settings.insertRegionUrlMapSettings(), clientContext);
        this.listRegionUrlMapsCallable = callableFactory.createUnaryCallable(listRegionUrlMapsTransportSettings, settings.listRegionUrlMapsSettings(), clientContext);
        this.listRegionUrlMapsPagedCallable = callableFactory.createPagedCallable(listRegionUrlMapsTransportSettings, settings.listRegionUrlMapsSettings(), clientContext);
        this.patchRegionUrlMapCallable = callableFactory.createUnaryCallable(patchRegionUrlMapTransportSettings, settings.patchRegionUrlMapSettings(), clientContext);
        this.updateRegionUrlMapCallable = callableFactory.createUnaryCallable(updateRegionUrlMapTransportSettings, settings.updateRegionUrlMapSettings(), clientContext);
        this.validateRegionUrlMapCallable = callableFactory.createUnaryCallable(validateRegionUrlMapTransportSettings, settings.validateRegionUrlMapSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteRegionUrlMapHttpRequest, Operation> deleteRegionUrlMapCallable() {
        return this.deleteRegionUrlMapCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetRegionUrlMapHttpRequest, UrlMap> getRegionUrlMapCallable() {
        return this.getRegionUrlMapCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertRegionUrlMapHttpRequest, Operation> insertRegionUrlMapCallable() {
        return this.insertRegionUrlMapCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListRegionUrlMapsHttpRequest, RegionUrlMapClient.ListRegionUrlMapsPagedResponse> listRegionUrlMapsPagedCallable() {
        return this.listRegionUrlMapsPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListRegionUrlMapsHttpRequest, UrlMapList> listRegionUrlMapsCallable() {
        return this.listRegionUrlMapsCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<PatchRegionUrlMapHttpRequest, Operation> patchRegionUrlMapCallable() {
        return this.patchRegionUrlMapCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<UpdateRegionUrlMapHttpRequest, Operation> updateRegionUrlMapCallable() {
        return this.updateRegionUrlMapCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ValidateRegionUrlMapHttpRequest, UrlMapsValidateResponse> validateRegionUrlMapCallable() {
        return this.validateRegionUrlMapCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

