/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.MetadataFilterLabelMatch;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class MetadataFilter
implements ApiMessage {
    private final List<MetadataFilterLabelMatch> filterLabels;
    private final String filterMatchCriteria;
    private static final MetadataFilter DEFAULT_INSTANCE = new MetadataFilter();

    private MetadataFilter() {
        this.filterLabels = null;
        this.filterMatchCriteria = null;
    }

    private MetadataFilter(List<MetadataFilterLabelMatch> filterLabels, String filterMatchCriteria) {
        this.filterLabels = filterLabels;
        this.filterMatchCriteria = filterMatchCriteria;
    }

    public Object getFieldValue(String fieldName) {
        if ("filterLabels".equals(fieldName)) {
            return this.filterLabels;
        }
        if ("filterMatchCriteria".equals(fieldName)) {
            return this.filterMatchCriteria;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<MetadataFilterLabelMatch> getFilterLabelsList() {
        return this.filterLabels;
    }

    public String getFilterMatchCriteria() {
        return this.filterMatchCriteria;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(MetadataFilter prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static MetadataFilter getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "MetadataFilter{filterLabels=" + this.filterLabels + ", filterMatchCriteria=" + this.filterMatchCriteria + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MetadataFilter) {
            MetadataFilter that = (MetadataFilter)o;
            return Objects.equals(this.filterLabels, that.getFilterLabelsList()) && Objects.equals(this.filterMatchCriteria, that.getFilterMatchCriteria());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.filterLabels, this.filterMatchCriteria);
    }

    public static class Builder {
        private List<MetadataFilterLabelMatch> filterLabels;
        private String filterMatchCriteria;

        Builder() {
        }

        public Builder mergeFrom(MetadataFilter other) {
            if (other == MetadataFilter.getDefaultInstance()) {
                return this;
            }
            if (other.getFilterLabelsList() != null) {
                this.filterLabels = other.filterLabels;
            }
            if (other.getFilterMatchCriteria() != null) {
                this.filterMatchCriteria = other.filterMatchCriteria;
            }
            return this;
        }

        Builder(MetadataFilter source) {
            this.filterLabels = source.filterLabels;
            this.filterMatchCriteria = source.filterMatchCriteria;
        }

        public List<MetadataFilterLabelMatch> getFilterLabelsList() {
            return this.filterLabels;
        }

        public Builder addAllFilterLabels(List<MetadataFilterLabelMatch> filterLabels) {
            if (this.filterLabels == null) {
                this.filterLabels = new LinkedList<MetadataFilterLabelMatch>();
            }
            this.filterLabels.addAll(filterLabels);
            return this;
        }

        public Builder addFilterLabels(MetadataFilterLabelMatch filterLabels) {
            if (this.filterLabels == null) {
                this.filterLabels = new LinkedList<MetadataFilterLabelMatch>();
            }
            this.filterLabels.add(filterLabels);
            return this;
        }

        public String getFilterMatchCriteria() {
            return this.filterMatchCriteria;
        }

        public Builder setFilterMatchCriteria(String filterMatchCriteria) {
            this.filterMatchCriteria = filterMatchCriteria;
            return this;
        }

        public MetadataFilter build() {
            return new MetadataFilter(this.filterLabels, this.filterMatchCriteria);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllFilterLabels(this.filterLabels);
            newBuilder.setFilterMatchCriteria(this.filterMatchCriteria);
            return newBuilder;
        }
    }
}

