/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class HttpHeaderOption
implements ApiMessage {
    private final String headerName;
    private final String headerValue;
    private final Boolean replace;
    private static final HttpHeaderOption DEFAULT_INSTANCE = new HttpHeaderOption();

    private HttpHeaderOption() {
        this.headerName = null;
        this.headerValue = null;
        this.replace = null;
    }

    private HttpHeaderOption(String headerName, String headerValue, Boolean replace) {
        this.headerName = headerName;
        this.headerValue = headerValue;
        this.replace = replace;
    }

    public Object getFieldValue(String fieldName) {
        if ("headerName".equals(fieldName)) {
            return this.headerName;
        }
        if ("headerValue".equals(fieldName)) {
            return this.headerValue;
        }
        if ("replace".equals(fieldName)) {
            return this.replace;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String getHeaderValue() {
        return this.headerValue;
    }

    public Boolean getReplace() {
        return this.replace;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HttpHeaderOption prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static HttpHeaderOption getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "HttpHeaderOption{headerName=" + this.headerName + ", headerValue=" + this.headerValue + ", replace=" + this.replace + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpHeaderOption) {
            HttpHeaderOption that = (HttpHeaderOption)o;
            return Objects.equals(this.headerName, that.getHeaderName()) && Objects.equals(this.headerValue, that.getHeaderValue()) && Objects.equals(this.replace, that.getReplace());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.headerName, this.headerValue, this.replace);
    }

    public static class Builder {
        private String headerName;
        private String headerValue;
        private Boolean replace;

        Builder() {
        }

        public Builder mergeFrom(HttpHeaderOption other) {
            if (other == HttpHeaderOption.getDefaultInstance()) {
                return this;
            }
            if (other.getHeaderName() != null) {
                this.headerName = other.headerName;
            }
            if (other.getHeaderValue() != null) {
                this.headerValue = other.headerValue;
            }
            if (other.getReplace() != null) {
                this.replace = other.replace;
            }
            return this;
        }

        Builder(HttpHeaderOption source) {
            this.headerName = source.headerName;
            this.headerValue = source.headerValue;
            this.replace = source.replace;
        }

        public String getHeaderName() {
            return this.headerName;
        }

        public Builder setHeaderName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public String getHeaderValue() {
            return this.headerValue;
        }

        public Builder setHeaderValue(String headerValue) {
            this.headerValue = headerValue;
            return this;
        }

        public Boolean getReplace() {
            return this.replace;
        }

        public Builder setReplace(Boolean replace) {
            this.replace = replace;
            return this;
        }

        public HttpHeaderOption build() {
            return new HttpHeaderOption(this.headerName, this.headerValue, this.replace);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setHeaderName(this.headerName);
            newBuilder.setHeaderValue(this.headerValue);
            newBuilder.setReplace(this.replace);
            return newBuilder;
        }
    }
}

