/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DisableXpnHostProjectHttpRequest;
import com.google.cloud.compute.v1.DisableXpnResourceProjectHttpRequest;
import com.google.cloud.compute.v1.EnableXpnHostProjectHttpRequest;
import com.google.cloud.compute.v1.EnableXpnResourceProjectHttpRequest;
import com.google.cloud.compute.v1.GetProjectHttpRequest;
import com.google.cloud.compute.v1.GetXpnHostProjectHttpRequest;
import com.google.cloud.compute.v1.GetXpnResourcesProjectsHttpRequest;
import com.google.cloud.compute.v1.ListXpnHostsProjectsHttpRequest;
import com.google.cloud.compute.v1.MoveDiskProjectHttpRequest;
import com.google.cloud.compute.v1.MoveInstanceProjectHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Project;
import com.google.cloud.compute.v1.ProjectClient;
import com.google.cloud.compute.v1.ProjectsGetXpnResources;
import com.google.cloud.compute.v1.SetCommonInstanceMetadataProjectHttpRequest;
import com.google.cloud.compute.v1.SetDefaultNetworkTierProjectHttpRequest;
import com.google.cloud.compute.v1.SetUsageExportBucketProjectHttpRequest;
import com.google.cloud.compute.v1.XpnHostList;
import com.google.cloud.compute.v1.XpnResourceId;
import com.google.cloud.compute.v1.stub.HttpJsonProjectStub;
import com.google.cloud.compute.v1.stub.ProjectStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ProjectStubSettings
extends StubSettings<ProjectStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DisableXpnHostProjectHttpRequest, Operation> disableXpnHostProjectSettings;
    private final UnaryCallSettings<DisableXpnResourceProjectHttpRequest, Operation> disableXpnResourceProjectSettings;
    private final UnaryCallSettings<EnableXpnHostProjectHttpRequest, Operation> enableXpnHostProjectSettings;
    private final UnaryCallSettings<EnableXpnResourceProjectHttpRequest, Operation> enableXpnResourceProjectSettings;
    private final UnaryCallSettings<GetProjectHttpRequest, Project> getProjectSettings;
    private final UnaryCallSettings<GetXpnHostProjectHttpRequest, Project> getXpnHostProjectSettings;
    private final PagedCallSettings<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources, ProjectClient.GetXpnResourcesProjectsPagedResponse> getXpnResourcesProjectsSettings;
    private final PagedCallSettings<ListXpnHostsProjectsHttpRequest, XpnHostList, ProjectClient.ListXpnHostsProjectsPagedResponse> listXpnHostsProjectsSettings;
    private final UnaryCallSettings<MoveDiskProjectHttpRequest, Operation> moveDiskProjectSettings;
    private final UnaryCallSettings<MoveInstanceProjectHttpRequest, Operation> moveInstanceProjectSettings;
    private final UnaryCallSettings<SetCommonInstanceMetadataProjectHttpRequest, Operation> setCommonInstanceMetadataProjectSettings;
    private final UnaryCallSettings<SetDefaultNetworkTierProjectHttpRequest, Operation> setDefaultNetworkTierProjectSettings;
    private final UnaryCallSettings<SetUsageExportBucketProjectHttpRequest, Operation> setUsageExportBucketProjectSettings;
    private static final PagedListDescriptor<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources, XpnResourceId> GET_XPN_RESOURCES_PROJECTS_PAGE_STR_DESC = new PagedListDescriptor<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources, XpnResourceId>(){

        public String emptyToken() {
            return "";
        }

        public GetXpnResourcesProjectsHttpRequest injectToken(GetXpnResourcesProjectsHttpRequest payload, String token) {
            return GetXpnResourcesProjectsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public GetXpnResourcesProjectsHttpRequest injectPageSize(GetXpnResourcesProjectsHttpRequest payload, int pageSize) {
            return GetXpnResourcesProjectsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(GetXpnResourcesProjectsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ProjectsGetXpnResources payload) {
            return payload.getNextPageToken();
        }

        public Iterable<XpnResourceId> extractResources(ProjectsGetXpnResources payload) {
            return payload.getResourcesList() != null ? payload.getResourcesList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListXpnHostsProjectsHttpRequest, XpnHostList, Project> LIST_XPN_HOSTS_PROJECTS_PAGE_STR_DESC = new PagedListDescriptor<ListXpnHostsProjectsHttpRequest, XpnHostList, Project>(){

        public String emptyToken() {
            return "";
        }

        public ListXpnHostsProjectsHttpRequest injectToken(ListXpnHostsProjectsHttpRequest payload, String token) {
            return ListXpnHostsProjectsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListXpnHostsProjectsHttpRequest injectPageSize(ListXpnHostsProjectsHttpRequest payload, int pageSize) {
            return ListXpnHostsProjectsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListXpnHostsProjectsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(XpnHostList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Project> extractResources(XpnHostList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources, ProjectClient.GetXpnResourcesProjectsPagedResponse> GET_XPN_RESOURCES_PROJECTS_PAGE_STR_FACT = new PagedListResponseFactory<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources, ProjectClient.GetXpnResourcesProjectsPagedResponse>(){

        public ApiFuture<ProjectClient.GetXpnResourcesProjectsPagedResponse> getFuturePagedResponse(UnaryCallable<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources> callable, GetXpnResourcesProjectsHttpRequest request, ApiCallContext context, ApiFuture<ProjectsGetXpnResources> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)GET_XPN_RESOURCES_PROJECTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ProjectClient.GetXpnResourcesProjectsPagedResponse.createAsync((PageContext<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources, XpnResourceId>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListXpnHostsProjectsHttpRequest, XpnHostList, ProjectClient.ListXpnHostsProjectsPagedResponse> LIST_XPN_HOSTS_PROJECTS_PAGE_STR_FACT = new PagedListResponseFactory<ListXpnHostsProjectsHttpRequest, XpnHostList, ProjectClient.ListXpnHostsProjectsPagedResponse>(){

        public ApiFuture<ProjectClient.ListXpnHostsProjectsPagedResponse> getFuturePagedResponse(UnaryCallable<ListXpnHostsProjectsHttpRequest, XpnHostList> callable, ListXpnHostsProjectsHttpRequest request, ApiCallContext context, ApiFuture<XpnHostList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_XPN_HOSTS_PROJECTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ProjectClient.ListXpnHostsProjectsPagedResponse.createAsync((PageContext<ListXpnHostsProjectsHttpRequest, XpnHostList, Project>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DisableXpnHostProjectHttpRequest, Operation> disableXpnHostProjectSettings() {
        return this.disableXpnHostProjectSettings;
    }

    public UnaryCallSettings<DisableXpnResourceProjectHttpRequest, Operation> disableXpnResourceProjectSettings() {
        return this.disableXpnResourceProjectSettings;
    }

    public UnaryCallSettings<EnableXpnHostProjectHttpRequest, Operation> enableXpnHostProjectSettings() {
        return this.enableXpnHostProjectSettings;
    }

    public UnaryCallSettings<EnableXpnResourceProjectHttpRequest, Operation> enableXpnResourceProjectSettings() {
        return this.enableXpnResourceProjectSettings;
    }

    public UnaryCallSettings<GetProjectHttpRequest, Project> getProjectSettings() {
        return this.getProjectSettings;
    }

    public UnaryCallSettings<GetXpnHostProjectHttpRequest, Project> getXpnHostProjectSettings() {
        return this.getXpnHostProjectSettings;
    }

    public PagedCallSettings<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources, ProjectClient.GetXpnResourcesProjectsPagedResponse> getXpnResourcesProjectsSettings() {
        return this.getXpnResourcesProjectsSettings;
    }

    public PagedCallSettings<ListXpnHostsProjectsHttpRequest, XpnHostList, ProjectClient.ListXpnHostsProjectsPagedResponse> listXpnHostsProjectsSettings() {
        return this.listXpnHostsProjectsSettings;
    }

    public UnaryCallSettings<MoveDiskProjectHttpRequest, Operation> moveDiskProjectSettings() {
        return this.moveDiskProjectSettings;
    }

    public UnaryCallSettings<MoveInstanceProjectHttpRequest, Operation> moveInstanceProjectSettings() {
        return this.moveInstanceProjectSettings;
    }

    public UnaryCallSettings<SetCommonInstanceMetadataProjectHttpRequest, Operation> setCommonInstanceMetadataProjectSettings() {
        return this.setCommonInstanceMetadataProjectSettings;
    }

    public UnaryCallSettings<SetDefaultNetworkTierProjectHttpRequest, Operation> setDefaultNetworkTierProjectSettings() {
        return this.setDefaultNetworkTierProjectSettings;
    }

    public UnaryCallSettings<SetUsageExportBucketProjectHttpRequest, Operation> setUsageExportBucketProjectSettings() {
        return this.setUsageExportBucketProjectSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ProjectStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonProjectStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ProjectStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ProjectStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ProjectStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.disableXpnHostProjectSettings = settingsBuilder.disableXpnHostProjectSettings().build();
        this.disableXpnResourceProjectSettings = settingsBuilder.disableXpnResourceProjectSettings().build();
        this.enableXpnHostProjectSettings = settingsBuilder.enableXpnHostProjectSettings().build();
        this.enableXpnResourceProjectSettings = settingsBuilder.enableXpnResourceProjectSettings().build();
        this.getProjectSettings = settingsBuilder.getProjectSettings().build();
        this.getXpnHostProjectSettings = settingsBuilder.getXpnHostProjectSettings().build();
        this.getXpnResourcesProjectsSettings = settingsBuilder.getXpnResourcesProjectsSettings().build();
        this.listXpnHostsProjectsSettings = settingsBuilder.listXpnHostsProjectsSettings().build();
        this.moveDiskProjectSettings = settingsBuilder.moveDiskProjectSettings().build();
        this.moveInstanceProjectSettings = settingsBuilder.moveInstanceProjectSettings().build();
        this.setCommonInstanceMetadataProjectSettings = settingsBuilder.setCommonInstanceMetadataProjectSettings().build();
        this.setDefaultNetworkTierProjectSettings = settingsBuilder.setDefaultNetworkTierProjectSettings().build();
        this.setUsageExportBucketProjectSettings = settingsBuilder.setUsageExportBucketProjectSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ProjectStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DisableXpnHostProjectHttpRequest, Operation> disableXpnHostProjectSettings;
        private final UnaryCallSettings.Builder<DisableXpnResourceProjectHttpRequest, Operation> disableXpnResourceProjectSettings;
        private final UnaryCallSettings.Builder<EnableXpnHostProjectHttpRequest, Operation> enableXpnHostProjectSettings;
        private final UnaryCallSettings.Builder<EnableXpnResourceProjectHttpRequest, Operation> enableXpnResourceProjectSettings;
        private final UnaryCallSettings.Builder<GetProjectHttpRequest, Project> getProjectSettings;
        private final UnaryCallSettings.Builder<GetXpnHostProjectHttpRequest, Project> getXpnHostProjectSettings;
        private final PagedCallSettings.Builder<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources, ProjectClient.GetXpnResourcesProjectsPagedResponse> getXpnResourcesProjectsSettings;
        private final PagedCallSettings.Builder<ListXpnHostsProjectsHttpRequest, XpnHostList, ProjectClient.ListXpnHostsProjectsPagedResponse> listXpnHostsProjectsSettings;
        private final UnaryCallSettings.Builder<MoveDiskProjectHttpRequest, Operation> moveDiskProjectSettings;
        private final UnaryCallSettings.Builder<MoveInstanceProjectHttpRequest, Operation> moveInstanceProjectSettings;
        private final UnaryCallSettings.Builder<SetCommonInstanceMetadataProjectHttpRequest, Operation> setCommonInstanceMetadataProjectSettings;
        private final UnaryCallSettings.Builder<SetDefaultNetworkTierProjectHttpRequest, Operation> setDefaultNetworkTierProjectSettings;
        private final UnaryCallSettings.Builder<SetUsageExportBucketProjectHttpRequest, Operation> setUsageExportBucketProjectSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.disableXpnHostProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.disableXpnResourceProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.enableXpnHostProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.enableXpnResourceProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getXpnHostProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getXpnResourcesProjectsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)GET_XPN_RESOURCES_PROJECTS_PAGE_STR_FACT);
            this.listXpnHostsProjectsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_XPN_HOSTS_PROJECTS_PAGE_STR_FACT);
            this.moveDiskProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.moveInstanceProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setCommonInstanceMetadataProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setDefaultNetworkTierProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setUsageExportBucketProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.disableXpnHostProjectSettings, this.disableXpnResourceProjectSettings, this.enableXpnHostProjectSettings, this.enableXpnResourceProjectSettings, this.getProjectSettings, this.getXpnHostProjectSettings, this.getXpnResourcesProjectsSettings, this.listXpnHostsProjectsSettings, this.moveDiskProjectSettings, this.moveInstanceProjectSettings, this.setCommonInstanceMetadataProjectSettings, this.setDefaultNetworkTierProjectSettings, (Object[])new UnaryCallSettings.Builder[]{this.setUsageExportBucketProjectSettings});
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ProjectStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ProjectStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ProjectStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ProjectStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.disableXpnHostProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.disableXpnResourceProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.enableXpnHostProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.enableXpnResourceProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getXpnHostProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getXpnResourcesProjectsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listXpnHostsProjectsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.moveDiskProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.moveInstanceProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setCommonInstanceMetadataProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setDefaultNetworkTierProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setUsageExportBucketProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(ProjectStubSettings settings) {
            super((StubSettings)settings);
            this.disableXpnHostProjectSettings = settings.disableXpnHostProjectSettings.toBuilder();
            this.disableXpnResourceProjectSettings = settings.disableXpnResourceProjectSettings.toBuilder();
            this.enableXpnHostProjectSettings = settings.enableXpnHostProjectSettings.toBuilder();
            this.enableXpnResourceProjectSettings = settings.enableXpnResourceProjectSettings.toBuilder();
            this.getProjectSettings = settings.getProjectSettings.toBuilder();
            this.getXpnHostProjectSettings = settings.getXpnHostProjectSettings.toBuilder();
            this.getXpnResourcesProjectsSettings = settings.getXpnResourcesProjectsSettings.toBuilder();
            this.listXpnHostsProjectsSettings = settings.listXpnHostsProjectsSettings.toBuilder();
            this.moveDiskProjectSettings = settings.moveDiskProjectSettings.toBuilder();
            this.moveInstanceProjectSettings = settings.moveInstanceProjectSettings.toBuilder();
            this.setCommonInstanceMetadataProjectSettings = settings.setCommonInstanceMetadataProjectSettings.toBuilder();
            this.setDefaultNetworkTierProjectSettings = settings.setDefaultNetworkTierProjectSettings.toBuilder();
            this.setUsageExportBucketProjectSettings = settings.setUsageExportBucketProjectSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.disableXpnHostProjectSettings, this.disableXpnResourceProjectSettings, this.enableXpnHostProjectSettings, this.enableXpnResourceProjectSettings, this.getProjectSettings, this.getXpnHostProjectSettings, this.getXpnResourcesProjectsSettings, this.listXpnHostsProjectsSettings, this.moveDiskProjectSettings, this.moveInstanceProjectSettings, this.setCommonInstanceMetadataProjectSettings, this.setDefaultNetworkTierProjectSettings, (Object[])new UnaryCallSettings.Builder[]{this.setUsageExportBucketProjectSettings});
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DisableXpnHostProjectHttpRequest, Operation> disableXpnHostProjectSettings() {
            return this.disableXpnHostProjectSettings;
        }

        public UnaryCallSettings.Builder<DisableXpnResourceProjectHttpRequest, Operation> disableXpnResourceProjectSettings() {
            return this.disableXpnResourceProjectSettings;
        }

        public UnaryCallSettings.Builder<EnableXpnHostProjectHttpRequest, Operation> enableXpnHostProjectSettings() {
            return this.enableXpnHostProjectSettings;
        }

        public UnaryCallSettings.Builder<EnableXpnResourceProjectHttpRequest, Operation> enableXpnResourceProjectSettings() {
            return this.enableXpnResourceProjectSettings;
        }

        public UnaryCallSettings.Builder<GetProjectHttpRequest, Project> getProjectSettings() {
            return this.getProjectSettings;
        }

        public UnaryCallSettings.Builder<GetXpnHostProjectHttpRequest, Project> getXpnHostProjectSettings() {
            return this.getXpnHostProjectSettings;
        }

        public PagedCallSettings.Builder<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources, ProjectClient.GetXpnResourcesProjectsPagedResponse> getXpnResourcesProjectsSettings() {
            return this.getXpnResourcesProjectsSettings;
        }

        public PagedCallSettings.Builder<ListXpnHostsProjectsHttpRequest, XpnHostList, ProjectClient.ListXpnHostsProjectsPagedResponse> listXpnHostsProjectsSettings() {
            return this.listXpnHostsProjectsSettings;
        }

        public UnaryCallSettings.Builder<MoveDiskProjectHttpRequest, Operation> moveDiskProjectSettings() {
            return this.moveDiskProjectSettings;
        }

        public UnaryCallSettings.Builder<MoveInstanceProjectHttpRequest, Operation> moveInstanceProjectSettings() {
            return this.moveInstanceProjectSettings;
        }

        public UnaryCallSettings.Builder<SetCommonInstanceMetadataProjectHttpRequest, Operation> setCommonInstanceMetadataProjectSettings() {
            return this.setCommonInstanceMetadataProjectSettings;
        }

        public UnaryCallSettings.Builder<SetDefaultNetworkTierProjectHttpRequest, Operation> setDefaultNetworkTierProjectSettings() {
            return this.setDefaultNetworkTierProjectSettings;
        }

        public UnaryCallSettings.Builder<SetUsageExportBucketProjectHttpRequest, Operation> setUsageExportBucketProjectSettings() {
            return this.setUsageExportBucketProjectSettings;
        }

        public ProjectStubSettings build() throws IOException {
            return new ProjectStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

