/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AttachNetworkEndpointsGlobalNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.DeleteGlobalNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.DetachNetworkEndpointsGlobalNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.GetGlobalNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.GlobalNetworkEndpointGroupClient;
import com.google.cloud.compute.v1.InsertGlobalNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.ListGlobalNetworkEndpointGroupsHttpRequest;
import com.google.cloud.compute.v1.ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest;
import com.google.cloud.compute.v1.NetworkEndpointGroup;
import com.google.cloud.compute.v1.NetworkEndpointGroupList;
import com.google.cloud.compute.v1.NetworkEndpointGroupsListNetworkEndpoints;
import com.google.cloud.compute.v1.NetworkEndpointWithHealthStatus;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.stub.GlobalNetworkEndpointGroupStub;
import com.google.cloud.compute.v1.stub.HttpJsonGlobalNetworkEndpointGroupStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class GlobalNetworkEndpointGroupStubSettings
extends StubSettings<GlobalNetworkEndpointGroupStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<AttachNetworkEndpointsGlobalNetworkEndpointGroupHttpRequest, Operation> attachNetworkEndpointsGlobalNetworkEndpointGroupSettings;
    private final UnaryCallSettings<DeleteGlobalNetworkEndpointGroupHttpRequest, Operation> deleteGlobalNetworkEndpointGroupSettings;
    private final UnaryCallSettings<DetachNetworkEndpointsGlobalNetworkEndpointGroupHttpRequest, Operation> detachNetworkEndpointsGlobalNetworkEndpointGroupSettings;
    private final UnaryCallSettings<GetGlobalNetworkEndpointGroupHttpRequest, NetworkEndpointGroup> getGlobalNetworkEndpointGroupSettings;
    private final UnaryCallSettings<InsertGlobalNetworkEndpointGroupHttpRequest, Operation> insertGlobalNetworkEndpointGroupSettings;
    private final PagedCallSettings<ListGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, GlobalNetworkEndpointGroupClient.ListGlobalNetworkEndpointGroupsPagedResponse> listGlobalNetworkEndpointGroupsSettings;
    private final PagedCallSettings<ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, GlobalNetworkEndpointGroupClient.ListNetworkEndpointsGlobalNetworkEndpointGroupsPagedResponse> listNetworkEndpointsGlobalNetworkEndpointGroupsSettings;
    private static final PagedListDescriptor<ListGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup> LIST_GLOBAL_NETWORK_ENDPOINT_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListGlobalNetworkEndpointGroupsHttpRequest injectToken(ListGlobalNetworkEndpointGroupsHttpRequest payload, String token) {
            return ListGlobalNetworkEndpointGroupsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListGlobalNetworkEndpointGroupsHttpRequest injectPageSize(ListGlobalNetworkEndpointGroupsHttpRequest payload, int pageSize) {
            return ListGlobalNetworkEndpointGroupsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListGlobalNetworkEndpointGroupsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NetworkEndpointGroupList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NetworkEndpointGroup> extractResources(NetworkEndpointGroupList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus> LIST_NETWORK_ENDPOINTS_GLOBAL_NETWORK_ENDPOINT_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus>(){

        public String emptyToken() {
            return "";
        }

        public ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest injectToken(ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest payload, String token) {
            return ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest injectPageSize(ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest payload, int pageSize) {
            return ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NetworkEndpointGroupsListNetworkEndpoints payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NetworkEndpointWithHealthStatus> extractResources(NetworkEndpointGroupsListNetworkEndpoints payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, GlobalNetworkEndpointGroupClient.ListGlobalNetworkEndpointGroupsPagedResponse> LIST_GLOBAL_NETWORK_ENDPOINT_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, GlobalNetworkEndpointGroupClient.ListGlobalNetworkEndpointGroupsPagedResponse>(){

        public ApiFuture<GlobalNetworkEndpointGroupClient.ListGlobalNetworkEndpointGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList> callable, ListGlobalNetworkEndpointGroupsHttpRequest request, ApiCallContext context, ApiFuture<NetworkEndpointGroupList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GLOBAL_NETWORK_ENDPOINT_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GlobalNetworkEndpointGroupClient.ListGlobalNetworkEndpointGroupsPagedResponse.createAsync((PageContext<ListGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, GlobalNetworkEndpointGroupClient.ListNetworkEndpointsGlobalNetworkEndpointGroupsPagedResponse> LIST_NETWORK_ENDPOINTS_GLOBAL_NETWORK_ENDPOINT_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, GlobalNetworkEndpointGroupClient.ListNetworkEndpointsGlobalNetworkEndpointGroupsPagedResponse>(){

        public ApiFuture<GlobalNetworkEndpointGroupClient.ListNetworkEndpointsGlobalNetworkEndpointGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints> callable, ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest request, ApiCallContext context, ApiFuture<NetworkEndpointGroupsListNetworkEndpoints> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NETWORK_ENDPOINTS_GLOBAL_NETWORK_ENDPOINT_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GlobalNetworkEndpointGroupClient.ListNetworkEndpointsGlobalNetworkEndpointGroupsPagedResponse.createAsync((PageContext<ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AttachNetworkEndpointsGlobalNetworkEndpointGroupHttpRequest, Operation> attachNetworkEndpointsGlobalNetworkEndpointGroupSettings() {
        return this.attachNetworkEndpointsGlobalNetworkEndpointGroupSettings;
    }

    public UnaryCallSettings<DeleteGlobalNetworkEndpointGroupHttpRequest, Operation> deleteGlobalNetworkEndpointGroupSettings() {
        return this.deleteGlobalNetworkEndpointGroupSettings;
    }

    public UnaryCallSettings<DetachNetworkEndpointsGlobalNetworkEndpointGroupHttpRequest, Operation> detachNetworkEndpointsGlobalNetworkEndpointGroupSettings() {
        return this.detachNetworkEndpointsGlobalNetworkEndpointGroupSettings;
    }

    public UnaryCallSettings<GetGlobalNetworkEndpointGroupHttpRequest, NetworkEndpointGroup> getGlobalNetworkEndpointGroupSettings() {
        return this.getGlobalNetworkEndpointGroupSettings;
    }

    public UnaryCallSettings<InsertGlobalNetworkEndpointGroupHttpRequest, Operation> insertGlobalNetworkEndpointGroupSettings() {
        return this.insertGlobalNetworkEndpointGroupSettings;
    }

    public PagedCallSettings<ListGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, GlobalNetworkEndpointGroupClient.ListGlobalNetworkEndpointGroupsPagedResponse> listGlobalNetworkEndpointGroupsSettings() {
        return this.listGlobalNetworkEndpointGroupsSettings;
    }

    public PagedCallSettings<ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, GlobalNetworkEndpointGroupClient.ListNetworkEndpointsGlobalNetworkEndpointGroupsPagedResponse> listNetworkEndpointsGlobalNetworkEndpointGroupsSettings() {
        return this.listNetworkEndpointsGlobalNetworkEndpointGroupsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GlobalNetworkEndpointGroupStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonGlobalNetworkEndpointGroupStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GlobalNetworkEndpointGroupStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GlobalNetworkEndpointGroupStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GlobalNetworkEndpointGroupStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.attachNetworkEndpointsGlobalNetworkEndpointGroupSettings = settingsBuilder.attachNetworkEndpointsGlobalNetworkEndpointGroupSettings().build();
        this.deleteGlobalNetworkEndpointGroupSettings = settingsBuilder.deleteGlobalNetworkEndpointGroupSettings().build();
        this.detachNetworkEndpointsGlobalNetworkEndpointGroupSettings = settingsBuilder.detachNetworkEndpointsGlobalNetworkEndpointGroupSettings().build();
        this.getGlobalNetworkEndpointGroupSettings = settingsBuilder.getGlobalNetworkEndpointGroupSettings().build();
        this.insertGlobalNetworkEndpointGroupSettings = settingsBuilder.insertGlobalNetworkEndpointGroupSettings().build();
        this.listGlobalNetworkEndpointGroupsSettings = settingsBuilder.listGlobalNetworkEndpointGroupsSettings().build();
        this.listNetworkEndpointsGlobalNetworkEndpointGroupsSettings = settingsBuilder.listNetworkEndpointsGlobalNetworkEndpointGroupsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GlobalNetworkEndpointGroupStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AttachNetworkEndpointsGlobalNetworkEndpointGroupHttpRequest, Operation> attachNetworkEndpointsGlobalNetworkEndpointGroupSettings;
        private final UnaryCallSettings.Builder<DeleteGlobalNetworkEndpointGroupHttpRequest, Operation> deleteGlobalNetworkEndpointGroupSettings;
        private final UnaryCallSettings.Builder<DetachNetworkEndpointsGlobalNetworkEndpointGroupHttpRequest, Operation> detachNetworkEndpointsGlobalNetworkEndpointGroupSettings;
        private final UnaryCallSettings.Builder<GetGlobalNetworkEndpointGroupHttpRequest, NetworkEndpointGroup> getGlobalNetworkEndpointGroupSettings;
        private final UnaryCallSettings.Builder<InsertGlobalNetworkEndpointGroupHttpRequest, Operation> insertGlobalNetworkEndpointGroupSettings;
        private final PagedCallSettings.Builder<ListGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, GlobalNetworkEndpointGroupClient.ListGlobalNetworkEndpointGroupsPagedResponse> listGlobalNetworkEndpointGroupsSettings;
        private final PagedCallSettings.Builder<ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, GlobalNetworkEndpointGroupClient.ListNetworkEndpointsGlobalNetworkEndpointGroupsPagedResponse> listNetworkEndpointsGlobalNetworkEndpointGroupsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.attachNetworkEndpointsGlobalNetworkEndpointGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGlobalNetworkEndpointGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.detachNetworkEndpointsGlobalNetworkEndpointGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getGlobalNetworkEndpointGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertGlobalNetworkEndpointGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listGlobalNetworkEndpointGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GLOBAL_NETWORK_ENDPOINT_GROUPS_PAGE_STR_FACT);
            this.listNetworkEndpointsGlobalNetworkEndpointGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NETWORK_ENDPOINTS_GLOBAL_NETWORK_ENDPOINT_GROUPS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.attachNetworkEndpointsGlobalNetworkEndpointGroupSettings, this.deleteGlobalNetworkEndpointGroupSettings, this.detachNetworkEndpointsGlobalNetworkEndpointGroupSettings, this.getGlobalNetworkEndpointGroupSettings, this.insertGlobalNetworkEndpointGroupSettings, this.listGlobalNetworkEndpointGroupsSettings, this.listNetworkEndpointsGlobalNetworkEndpointGroupsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GlobalNetworkEndpointGroupStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GlobalNetworkEndpointGroupStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GlobalNetworkEndpointGroupStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(GlobalNetworkEndpointGroupStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.attachNetworkEndpointsGlobalNetworkEndpointGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteGlobalNetworkEndpointGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.detachNetworkEndpointsGlobalNetworkEndpointGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getGlobalNetworkEndpointGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertGlobalNetworkEndpointGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listGlobalNetworkEndpointGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listNetworkEndpointsGlobalNetworkEndpointGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(GlobalNetworkEndpointGroupStubSettings settings) {
            super((StubSettings)settings);
            this.attachNetworkEndpointsGlobalNetworkEndpointGroupSettings = settings.attachNetworkEndpointsGlobalNetworkEndpointGroupSettings.toBuilder();
            this.deleteGlobalNetworkEndpointGroupSettings = settings.deleteGlobalNetworkEndpointGroupSettings.toBuilder();
            this.detachNetworkEndpointsGlobalNetworkEndpointGroupSettings = settings.detachNetworkEndpointsGlobalNetworkEndpointGroupSettings.toBuilder();
            this.getGlobalNetworkEndpointGroupSettings = settings.getGlobalNetworkEndpointGroupSettings.toBuilder();
            this.insertGlobalNetworkEndpointGroupSettings = settings.insertGlobalNetworkEndpointGroupSettings.toBuilder();
            this.listGlobalNetworkEndpointGroupsSettings = settings.listGlobalNetworkEndpointGroupsSettings.toBuilder();
            this.listNetworkEndpointsGlobalNetworkEndpointGroupsSettings = settings.listNetworkEndpointsGlobalNetworkEndpointGroupsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.attachNetworkEndpointsGlobalNetworkEndpointGroupSettings, this.deleteGlobalNetworkEndpointGroupSettings, this.detachNetworkEndpointsGlobalNetworkEndpointGroupSettings, this.getGlobalNetworkEndpointGroupSettings, this.insertGlobalNetworkEndpointGroupSettings, this.listGlobalNetworkEndpointGroupsSettings, this.listNetworkEndpointsGlobalNetworkEndpointGroupsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AttachNetworkEndpointsGlobalNetworkEndpointGroupHttpRequest, Operation> attachNetworkEndpointsGlobalNetworkEndpointGroupSettings() {
            return this.attachNetworkEndpointsGlobalNetworkEndpointGroupSettings;
        }

        public UnaryCallSettings.Builder<DeleteGlobalNetworkEndpointGroupHttpRequest, Operation> deleteGlobalNetworkEndpointGroupSettings() {
            return this.deleteGlobalNetworkEndpointGroupSettings;
        }

        public UnaryCallSettings.Builder<DetachNetworkEndpointsGlobalNetworkEndpointGroupHttpRequest, Operation> detachNetworkEndpointsGlobalNetworkEndpointGroupSettings() {
            return this.detachNetworkEndpointsGlobalNetworkEndpointGroupSettings;
        }

        public UnaryCallSettings.Builder<GetGlobalNetworkEndpointGroupHttpRequest, NetworkEndpointGroup> getGlobalNetworkEndpointGroupSettings() {
            return this.getGlobalNetworkEndpointGroupSettings;
        }

        public UnaryCallSettings.Builder<InsertGlobalNetworkEndpointGroupHttpRequest, Operation> insertGlobalNetworkEndpointGroupSettings() {
            return this.insertGlobalNetworkEndpointGroupSettings;
        }

        public PagedCallSettings.Builder<ListGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, GlobalNetworkEndpointGroupClient.ListGlobalNetworkEndpointGroupsPagedResponse> listGlobalNetworkEndpointGroupsSettings() {
            return this.listGlobalNetworkEndpointGroupsSettings;
        }

        public PagedCallSettings.Builder<ListNetworkEndpointsGlobalNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, GlobalNetworkEndpointGroupClient.ListNetworkEndpointsGlobalNetworkEndpointGroupsPagedResponse> listNetworkEndpointsGlobalNetworkEndpointGroupsSettings() {
            return this.listNetworkEndpointsGlobalNetworkEndpointGroupsSettings;
        }

        public GlobalNetworkEndpointGroupStubSettings build() throws IOException {
            return new GlobalNetworkEndpointGroupStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

