/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteZoneOperationHttpRequest;
import com.google.cloud.compute.v1.GetZoneOperationHttpRequest;
import com.google.cloud.compute.v1.ListZoneOperationsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OperationList;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.ProjectZoneOperationName;
import com.google.cloud.compute.v1.WaitZoneOperationHttpRequest;
import com.google.cloud.compute.v1.ZoneOperationSettings;
import com.google.cloud.compute.v1.stub.ZoneOperationStub;
import com.google.cloud.compute.v1.stub.ZoneOperationStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ZoneOperationClient
implements BackgroundResource {
    private final ZoneOperationSettings settings;
    private final ZoneOperationStub stub;

    public static final ZoneOperationClient create() throws IOException {
        return ZoneOperationClient.create(ZoneOperationSettings.newBuilder().build());
    }

    public static final ZoneOperationClient create(ZoneOperationSettings settings) throws IOException {
        return new ZoneOperationClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ZoneOperationClient create(ZoneOperationStub stub) {
        return new ZoneOperationClient(stub);
    }

    protected ZoneOperationClient(ZoneOperationSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ZoneOperationStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ZoneOperationClient(ZoneOperationStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ZoneOperationSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ZoneOperationStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final void deleteZoneOperation(ProjectZoneOperationName operation) {
        DeleteZoneOperationHttpRequest request = DeleteZoneOperationHttpRequest.newBuilder().setOperation(operation == null ? null : operation.toString()).build();
        this.deleteZoneOperation(request);
    }

    @BetaApi
    public final void deleteZoneOperation(String operation) {
        DeleteZoneOperationHttpRequest request = DeleteZoneOperationHttpRequest.newBuilder().setOperation(operation).build();
        this.deleteZoneOperation(request);
    }

    @BetaApi
    public final void deleteZoneOperation(DeleteZoneOperationHttpRequest request) {
        this.deleteZoneOperationCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteZoneOperationHttpRequest, Void> deleteZoneOperationCallable() {
        return this.stub.deleteZoneOperationCallable();
    }

    @BetaApi
    public final Operation getZoneOperation(ProjectZoneOperationName operation) {
        GetZoneOperationHttpRequest request = GetZoneOperationHttpRequest.newBuilder().setOperation(operation == null ? null : operation.toString()).build();
        return this.getZoneOperation(request);
    }

    @BetaApi
    public final Operation getZoneOperation(String operation) {
        GetZoneOperationHttpRequest request = GetZoneOperationHttpRequest.newBuilder().setOperation(operation).build();
        return this.getZoneOperation(request);
    }

    @BetaApi
    public final Operation getZoneOperation(GetZoneOperationHttpRequest request) {
        return (Operation)this.getZoneOperationCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetZoneOperationHttpRequest, Operation> getZoneOperationCallable() {
        return this.stub.getZoneOperationCallable();
    }

    @BetaApi
    public final ListZoneOperationsPagedResponse listZoneOperations(ProjectZoneName zone) {
        ListZoneOperationsHttpRequest request = ListZoneOperationsHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).build();
        return this.listZoneOperations(request);
    }

    @BetaApi
    public final ListZoneOperationsPagedResponse listZoneOperations(String zone) {
        ListZoneOperationsHttpRequest request = ListZoneOperationsHttpRequest.newBuilder().setZone(zone).build();
        return this.listZoneOperations(request);
    }

    @BetaApi
    public final ListZoneOperationsPagedResponse listZoneOperations(ListZoneOperationsHttpRequest request) {
        return (ListZoneOperationsPagedResponse)((Object)this.listZoneOperationsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListZoneOperationsHttpRequest, ListZoneOperationsPagedResponse> listZoneOperationsPagedCallable() {
        return this.stub.listZoneOperationsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListZoneOperationsHttpRequest, OperationList> listZoneOperationsCallable() {
        return this.stub.listZoneOperationsCallable();
    }

    @BetaApi
    public final Operation waitZoneOperation(ProjectZoneOperationName operation) {
        WaitZoneOperationHttpRequest request = WaitZoneOperationHttpRequest.newBuilder().setOperation(operation == null ? null : operation.toString()).build();
        return this.waitZoneOperation(request);
    }

    @BetaApi
    public final Operation waitZoneOperation(String operation) {
        WaitZoneOperationHttpRequest request = WaitZoneOperationHttpRequest.newBuilder().setOperation(operation).build();
        return this.waitZoneOperation(request);
    }

    @BetaApi
    public final Operation waitZoneOperation(WaitZoneOperationHttpRequest request) {
        return (Operation)this.waitZoneOperationCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<WaitZoneOperationHttpRequest, Operation> waitZoneOperationCallable() {
        return this.stub.waitZoneOperationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListZoneOperationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListZoneOperationsHttpRequest, OperationList, Operation, ListZoneOperationsPage, ListZoneOperationsFixedSizeCollection> {
        private ListZoneOperationsFixedSizeCollection(List<ListZoneOperationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListZoneOperationsFixedSizeCollection createEmptyCollection() {
            return new ListZoneOperationsFixedSizeCollection(null, 0);
        }

        protected ListZoneOperationsFixedSizeCollection createCollection(List<ListZoneOperationsPage> pages, int collectionSize) {
            return new ListZoneOperationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListZoneOperationsPage
    extends AbstractPage<ListZoneOperationsHttpRequest, OperationList, Operation, ListZoneOperationsPage> {
        private ListZoneOperationsPage(PageContext<ListZoneOperationsHttpRequest, OperationList, Operation> context, OperationList response) {
            super(context, (Object)response);
        }

        private static ListZoneOperationsPage createEmptyPage() {
            return new ListZoneOperationsPage(null, null);
        }

        protected ListZoneOperationsPage createPage(PageContext<ListZoneOperationsHttpRequest, OperationList, Operation> context, OperationList response) {
            return new ListZoneOperationsPage(context, response);
        }

        public ApiFuture<ListZoneOperationsPage> createPageAsync(PageContext<ListZoneOperationsHttpRequest, OperationList, Operation> context, ApiFuture<OperationList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListZoneOperationsPagedResponse
    extends AbstractPagedListResponse<ListZoneOperationsHttpRequest, OperationList, Operation, ListZoneOperationsPage, ListZoneOperationsFixedSizeCollection> {
        public static ApiFuture<ListZoneOperationsPagedResponse> createAsync(PageContext<ListZoneOperationsHttpRequest, OperationList, Operation> context, ApiFuture<OperationList> futureResponse) {
            ApiFuture<ListZoneOperationsPage> futurePage = ListZoneOperationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListZoneOperationsPage, ListZoneOperationsPagedResponse>(){

                public ListZoneOperationsPagedResponse apply(ListZoneOperationsPage input) {
                    return new ListZoneOperationsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListZoneOperationsPagedResponse(ListZoneOperationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListZoneOperationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

