/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.GetRegionNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.InsertRegionNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.ListRegionNetworkEndpointGroupsHttpRequest;
import com.google.cloud.compute.v1.NetworkEndpointGroup;
import com.google.cloud.compute.v1.NetworkEndpointGroupList;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionNetworkEndpointGroupName;
import com.google.cloud.compute.v1.RegionNetworkEndpointGroupSettings;
import com.google.cloud.compute.v1.stub.RegionNetworkEndpointGroupStub;
import com.google.cloud.compute.v1.stub.RegionNetworkEndpointGroupStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionNetworkEndpointGroupClient
implements BackgroundResource {
    private final RegionNetworkEndpointGroupSettings settings;
    private final RegionNetworkEndpointGroupStub stub;

    public static final RegionNetworkEndpointGroupClient create() throws IOException {
        return RegionNetworkEndpointGroupClient.create(RegionNetworkEndpointGroupSettings.newBuilder().build());
    }

    public static final RegionNetworkEndpointGroupClient create(RegionNetworkEndpointGroupSettings settings) throws IOException {
        return new RegionNetworkEndpointGroupClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionNetworkEndpointGroupClient create(RegionNetworkEndpointGroupStub stub) {
        return new RegionNetworkEndpointGroupClient(stub);
    }

    protected RegionNetworkEndpointGroupClient(RegionNetworkEndpointGroupSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionNetworkEndpointGroupStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionNetworkEndpointGroupClient(RegionNetworkEndpointGroupStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionNetworkEndpointGroupSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionNetworkEndpointGroupStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteRegionNetworkEndpointGroup(ProjectRegionNetworkEndpointGroupName networkEndpointGroup) {
        DeleteRegionNetworkEndpointGroupHttpRequest request = DeleteRegionNetworkEndpointGroupHttpRequest.newBuilder().setNetworkEndpointGroup(networkEndpointGroup == null ? null : networkEndpointGroup.toString()).build();
        return this.deleteRegionNetworkEndpointGroup(request);
    }

    @BetaApi
    public final Operation deleteRegionNetworkEndpointGroup(String networkEndpointGroup) {
        DeleteRegionNetworkEndpointGroupHttpRequest request = DeleteRegionNetworkEndpointGroupHttpRequest.newBuilder().setNetworkEndpointGroup(networkEndpointGroup).build();
        return this.deleteRegionNetworkEndpointGroup(request);
    }

    @BetaApi
    public final Operation deleteRegionNetworkEndpointGroup(DeleteRegionNetworkEndpointGroupHttpRequest request) {
        return (Operation)this.deleteRegionNetworkEndpointGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteRegionNetworkEndpointGroupHttpRequest, Operation> deleteRegionNetworkEndpointGroupCallable() {
        return this.stub.deleteRegionNetworkEndpointGroupCallable();
    }

    @BetaApi
    public final NetworkEndpointGroup getRegionNetworkEndpointGroup(ProjectRegionNetworkEndpointGroupName networkEndpointGroup) {
        GetRegionNetworkEndpointGroupHttpRequest request = GetRegionNetworkEndpointGroupHttpRequest.newBuilder().setNetworkEndpointGroup(networkEndpointGroup == null ? null : networkEndpointGroup.toString()).build();
        return this.getRegionNetworkEndpointGroup(request);
    }

    @BetaApi
    public final NetworkEndpointGroup getRegionNetworkEndpointGroup(String networkEndpointGroup) {
        GetRegionNetworkEndpointGroupHttpRequest request = GetRegionNetworkEndpointGroupHttpRequest.newBuilder().setNetworkEndpointGroup(networkEndpointGroup).build();
        return this.getRegionNetworkEndpointGroup(request);
    }

    @BetaApi
    public final NetworkEndpointGroup getRegionNetworkEndpointGroup(GetRegionNetworkEndpointGroupHttpRequest request) {
        return (NetworkEndpointGroup)this.getRegionNetworkEndpointGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRegionNetworkEndpointGroupHttpRequest, NetworkEndpointGroup> getRegionNetworkEndpointGroupCallable() {
        return this.stub.getRegionNetworkEndpointGroupCallable();
    }

    @BetaApi
    public final Operation insertRegionNetworkEndpointGroup(ProjectRegionName region, NetworkEndpointGroup networkEndpointGroupResource) {
        InsertRegionNetworkEndpointGroupHttpRequest request = InsertRegionNetworkEndpointGroupHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setNetworkEndpointGroupResource(networkEndpointGroupResource).build();
        return this.insertRegionNetworkEndpointGroup(request);
    }

    @BetaApi
    public final Operation insertRegionNetworkEndpointGroup(String region, NetworkEndpointGroup networkEndpointGroupResource) {
        InsertRegionNetworkEndpointGroupHttpRequest request = InsertRegionNetworkEndpointGroupHttpRequest.newBuilder().setRegion(region).setNetworkEndpointGroupResource(networkEndpointGroupResource).build();
        return this.insertRegionNetworkEndpointGroup(request);
    }

    @BetaApi
    public final Operation insertRegionNetworkEndpointGroup(InsertRegionNetworkEndpointGroupHttpRequest request) {
        return (Operation)this.insertRegionNetworkEndpointGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertRegionNetworkEndpointGroupHttpRequest, Operation> insertRegionNetworkEndpointGroupCallable() {
        return this.stub.insertRegionNetworkEndpointGroupCallable();
    }

    @BetaApi
    public final ListRegionNetworkEndpointGroupsPagedResponse listRegionNetworkEndpointGroups(ProjectRegionName region) {
        ListRegionNetworkEndpointGroupsHttpRequest request = ListRegionNetworkEndpointGroupsHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listRegionNetworkEndpointGroups(request);
    }

    @BetaApi
    public final ListRegionNetworkEndpointGroupsPagedResponse listRegionNetworkEndpointGroups(String region) {
        ListRegionNetworkEndpointGroupsHttpRequest request = ListRegionNetworkEndpointGroupsHttpRequest.newBuilder().setRegion(region).build();
        return this.listRegionNetworkEndpointGroups(request);
    }

    @BetaApi
    public final ListRegionNetworkEndpointGroupsPagedResponse listRegionNetworkEndpointGroups(ListRegionNetworkEndpointGroupsHttpRequest request) {
        return (ListRegionNetworkEndpointGroupsPagedResponse)((Object)this.listRegionNetworkEndpointGroupsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRegionNetworkEndpointGroupsHttpRequest, ListRegionNetworkEndpointGroupsPagedResponse> listRegionNetworkEndpointGroupsPagedCallable() {
        return this.stub.listRegionNetworkEndpointGroupsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList> listRegionNetworkEndpointGroupsCallable() {
        return this.stub.listRegionNetworkEndpointGroupsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRegionNetworkEndpointGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup, ListRegionNetworkEndpointGroupsPage, ListRegionNetworkEndpointGroupsFixedSizeCollection> {
        private ListRegionNetworkEndpointGroupsFixedSizeCollection(List<ListRegionNetworkEndpointGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRegionNetworkEndpointGroupsFixedSizeCollection createEmptyCollection() {
            return new ListRegionNetworkEndpointGroupsFixedSizeCollection(null, 0);
        }

        protected ListRegionNetworkEndpointGroupsFixedSizeCollection createCollection(List<ListRegionNetworkEndpointGroupsPage> pages, int collectionSize) {
            return new ListRegionNetworkEndpointGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRegionNetworkEndpointGroupsPage
    extends AbstractPage<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup, ListRegionNetworkEndpointGroupsPage> {
        private ListRegionNetworkEndpointGroupsPage(PageContext<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, NetworkEndpointGroupList response) {
            super(context, (Object)response);
        }

        private static ListRegionNetworkEndpointGroupsPage createEmptyPage() {
            return new ListRegionNetworkEndpointGroupsPage(null, null);
        }

        protected ListRegionNetworkEndpointGroupsPage createPage(PageContext<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, NetworkEndpointGroupList response) {
            return new ListRegionNetworkEndpointGroupsPage(context, response);
        }

        public ApiFuture<ListRegionNetworkEndpointGroupsPage> createPageAsync(PageContext<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, ApiFuture<NetworkEndpointGroupList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRegionNetworkEndpointGroupsPagedResponse
    extends AbstractPagedListResponse<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup, ListRegionNetworkEndpointGroupsPage, ListRegionNetworkEndpointGroupsFixedSizeCollection> {
        public static ApiFuture<ListRegionNetworkEndpointGroupsPagedResponse> createAsync(PageContext<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, ApiFuture<NetworkEndpointGroupList> futureResponse) {
            ApiFuture<ListRegionNetworkEndpointGroupsPage> futurePage = ListRegionNetworkEndpointGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRegionNetworkEndpointGroupsPage, ListRegionNetworkEndpointGroupsPagedResponse>(){

                public ListRegionNetworkEndpointGroupsPagedResponse apply(ListRegionNetworkEndpointGroupsPage input) {
                    return new ListRegionNetworkEndpointGroupsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListRegionNetworkEndpointGroupsPagedResponse(ListRegionNetworkEndpointGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRegionNetworkEndpointGroupsFixedSizeCollection.createEmptyCollection());
        }
    }
}

