/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.PreservedStatePreservedDisk;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class PreservedState
implements ApiMessage {
    private final Map<String, PreservedStatePreservedDisk> disks;
    private final Map<String, String> metadata;
    private static final PreservedState DEFAULT_INSTANCE = new PreservedState();

    private PreservedState() {
        this.disks = null;
        this.metadata = null;
    }

    private PreservedState(Map<String, PreservedStatePreservedDisk> disks, Map<String, String> metadata) {
        this.disks = disks;
        this.metadata = metadata;
    }

    public Object getFieldValue(String fieldName) {
        if ("disks".equals(fieldName)) {
            return this.disks;
        }
        if ("metadata".equals(fieldName)) {
            return this.metadata;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Map<String, PreservedStatePreservedDisk> getDisksMap() {
        return this.disks;
    }

    public Map<String, String> getMetadataMap() {
        return this.metadata;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(PreservedState prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static PreservedState getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "PreservedState{disks=" + this.disks + ", metadata=" + this.metadata + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PreservedState) {
            PreservedState that = (PreservedState)o;
            return Objects.equals(this.disks, that.getDisksMap()) && Objects.equals(this.metadata, that.getMetadataMap());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.disks, this.metadata);
    }

    public static class Builder {
        private Map<String, PreservedStatePreservedDisk> disks;
        private Map<String, String> metadata;

        Builder() {
        }

        public Builder mergeFrom(PreservedState other) {
            if (other == PreservedState.getDefaultInstance()) {
                return this;
            }
            if (other.getDisksMap() != null) {
                this.disks = other.disks;
            }
            if (other.getMetadataMap() != null) {
                this.metadata = other.metadata;
            }
            return this;
        }

        Builder(PreservedState source) {
            this.disks = source.disks;
            this.metadata = source.metadata;
        }

        public Map<String, PreservedStatePreservedDisk> getDisksMap() {
            return this.disks;
        }

        public Builder putAllDisks(Map<String, PreservedStatePreservedDisk> disks) {
            this.disks = disks;
            return this;
        }

        public Map<String, String> getMetadataMap() {
            return this.metadata;
        }

        public Builder putAllMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public PreservedState build() {
            return new PreservedState(this.disks, this.metadata);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.putAllDisks(this.disks);
            newBuilder.putAllMetadata(this.metadata);
            return newBuilder;
        }
    }
}

