/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class AuditLogConfig
implements ApiMessage {
    private final List<String> exemptedMembers;
    private final Boolean ignoreChildExemptions;
    private final String logType;
    private static final AuditLogConfig DEFAULT_INSTANCE = new AuditLogConfig();

    private AuditLogConfig() {
        this.exemptedMembers = null;
        this.ignoreChildExemptions = null;
        this.logType = null;
    }

    private AuditLogConfig(List<String> exemptedMembers, Boolean ignoreChildExemptions, String logType) {
        this.exemptedMembers = exemptedMembers;
        this.ignoreChildExemptions = ignoreChildExemptions;
        this.logType = logType;
    }

    public Object getFieldValue(String fieldName) {
        if ("exemptedMembers".equals(fieldName)) {
            return this.exemptedMembers;
        }
        if ("ignoreChildExemptions".equals(fieldName)) {
            return this.ignoreChildExemptions;
        }
        if ("logType".equals(fieldName)) {
            return this.logType;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<String> getExemptedMembersList() {
        return this.exemptedMembers;
    }

    public Boolean getIgnoreChildExemptions() {
        return this.ignoreChildExemptions;
    }

    public String getLogType() {
        return this.logType;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AuditLogConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static AuditLogConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "AuditLogConfig{exemptedMembers=" + this.exemptedMembers + ", ignoreChildExemptions=" + this.ignoreChildExemptions + ", logType=" + this.logType + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AuditLogConfig) {
            AuditLogConfig that = (AuditLogConfig)o;
            return Objects.equals(this.exemptedMembers, that.getExemptedMembersList()) && Objects.equals(this.ignoreChildExemptions, that.getIgnoreChildExemptions()) && Objects.equals(this.logType, that.getLogType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.exemptedMembers, this.ignoreChildExemptions, this.logType);
    }

    public static class Builder {
        private List<String> exemptedMembers;
        private Boolean ignoreChildExemptions;
        private String logType;

        Builder() {
        }

        public Builder mergeFrom(AuditLogConfig other) {
            if (other == AuditLogConfig.getDefaultInstance()) {
                return this;
            }
            if (other.getExemptedMembersList() != null) {
                this.exemptedMembers = other.exemptedMembers;
            }
            if (other.getIgnoreChildExemptions() != null) {
                this.ignoreChildExemptions = other.ignoreChildExemptions;
            }
            if (other.getLogType() != null) {
                this.logType = other.logType;
            }
            return this;
        }

        Builder(AuditLogConfig source) {
            this.exemptedMembers = source.exemptedMembers;
            this.ignoreChildExemptions = source.ignoreChildExemptions;
            this.logType = source.logType;
        }

        public List<String> getExemptedMembersList() {
            return this.exemptedMembers;
        }

        public Builder addAllExemptedMembers(List<String> exemptedMembers) {
            if (this.exemptedMembers == null) {
                this.exemptedMembers = new LinkedList<String>();
            }
            this.exemptedMembers.addAll(exemptedMembers);
            return this;
        }

        public Builder addExemptedMembers(String exemptedMembers) {
            if (this.exemptedMembers == null) {
                this.exemptedMembers = new LinkedList<String>();
            }
            this.exemptedMembers.add(exemptedMembers);
            return this;
        }

        public Boolean getIgnoreChildExemptions() {
            return this.ignoreChildExemptions;
        }

        public Builder setIgnoreChildExemptions(Boolean ignoreChildExemptions) {
            this.ignoreChildExemptions = ignoreChildExemptions;
            return this;
        }

        public String getLogType() {
            return this.logType;
        }

        public Builder setLogType(String logType) {
            this.logType = logType;
            return this;
        }

        public AuditLogConfig build() {
            return new AuditLogConfig(this.exemptedMembers, this.ignoreChildExemptions, this.logType);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllExemptedMembers(this.exemptedMembers);
            newBuilder.setIgnoreChildExemptions(this.ignoreChildExemptions);
            newBuilder.setLogType(this.logType);
            return newBuilder;
        }
    }
}

