/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.SslCertificateManagedSslCertificate;
import com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class SslCertificate
implements ApiMessage {
    private final String certificate;
    private final String creationTimestamp;
    private final String description;
    private final String expireTime;
    private final String id;
    private final String kind;
    private final SslCertificateManagedSslCertificate managed;
    private final String name;
    private final String privateKey;
    private final String region;
    private final String selfLink;
    private final SslCertificateSelfManagedSslCertificate selfManaged;
    private final List<String> subjectAlternativeNames;
    private final String type;
    private static final SslCertificate DEFAULT_INSTANCE = new SslCertificate();

    private SslCertificate() {
        this.certificate = null;
        this.creationTimestamp = null;
        this.description = null;
        this.expireTime = null;
        this.id = null;
        this.kind = null;
        this.managed = null;
        this.name = null;
        this.privateKey = null;
        this.region = null;
        this.selfLink = null;
        this.selfManaged = null;
        this.subjectAlternativeNames = null;
        this.type = null;
    }

    private SslCertificate(String certificate, String creationTimestamp, String description, String expireTime, String id, String kind, SslCertificateManagedSslCertificate managed, String name, String privateKey, String region, String selfLink, SslCertificateSelfManagedSslCertificate selfManaged, List<String> subjectAlternativeNames, String type) {
        this.certificate = certificate;
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.expireTime = expireTime;
        this.id = id;
        this.kind = kind;
        this.managed = managed;
        this.name = name;
        this.privateKey = privateKey;
        this.region = region;
        this.selfLink = selfLink;
        this.selfManaged = selfManaged;
        this.subjectAlternativeNames = subjectAlternativeNames;
        this.type = type;
    }

    public Object getFieldValue(String fieldName) {
        if ("certificate".equals(fieldName)) {
            return this.certificate;
        }
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("expireTime".equals(fieldName)) {
            return this.expireTime;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("managed".equals(fieldName)) {
            return this.managed;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("privateKey".equals(fieldName)) {
            return this.privateKey;
        }
        if ("region".equals(fieldName)) {
            return this.region;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("selfManaged".equals(fieldName)) {
            return this.selfManaged;
        }
        if ("subjectAlternativeNames".equals(fieldName)) {
            return this.subjectAlternativeNames;
        }
        if ("type".equals(fieldName)) {
            return this.type;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExpireTime() {
        return this.expireTime;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public SslCertificateManagedSslCertificate getManaged() {
        return this.managed;
    }

    public String getName() {
        return this.name;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public SslCertificateSelfManagedSslCertificate getSelfManaged() {
        return this.selfManaged;
    }

    public List<String> getSubjectAlternativeNamesList() {
        return this.subjectAlternativeNames;
    }

    public String getType() {
        return this.type;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SslCertificate prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static SslCertificate getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "SslCertificate{certificate=" + this.certificate + ", creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", expireTime=" + this.expireTime + ", id=" + this.id + ", kind=" + this.kind + ", managed=" + this.managed + ", name=" + this.name + ", privateKey=" + this.privateKey + ", region=" + this.region + ", selfLink=" + this.selfLink + ", selfManaged=" + this.selfManaged + ", subjectAlternativeNames=" + this.subjectAlternativeNames + ", type=" + this.type + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SslCertificate) {
            SslCertificate that = (SslCertificate)o;
            return Objects.equals(this.certificate, that.getCertificate()) && Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.expireTime, that.getExpireTime()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.managed, that.getManaged()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.privateKey, that.getPrivateKey()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.selfManaged, that.getSelfManaged()) && Objects.equals(this.subjectAlternativeNames, that.getSubjectAlternativeNamesList()) && Objects.equals(this.type, that.getType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.certificate, this.creationTimestamp, this.description, this.expireTime, this.id, this.kind, this.managed, this.name, this.privateKey, this.region, this.selfLink, this.selfManaged, this.subjectAlternativeNames, this.type);
    }

    public static class Builder {
        private String certificate;
        private String creationTimestamp;
        private String description;
        private String expireTime;
        private String id;
        private String kind;
        private SslCertificateManagedSslCertificate managed;
        private String name;
        private String privateKey;
        private String region;
        private String selfLink;
        private SslCertificateSelfManagedSslCertificate selfManaged;
        private List<String> subjectAlternativeNames;
        private String type;

        Builder() {
        }

        public Builder mergeFrom(SslCertificate other) {
            if (other == SslCertificate.getDefaultInstance()) {
                return this;
            }
            if (other.getCertificate() != null) {
                this.certificate = other.certificate;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getExpireTime() != null) {
                this.expireTime = other.expireTime;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getManaged() != null) {
                this.managed = other.managed;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getPrivateKey() != null) {
                this.privateKey = other.privateKey;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getSelfManaged() != null) {
                this.selfManaged = other.selfManaged;
            }
            if (other.getSubjectAlternativeNamesList() != null) {
                this.subjectAlternativeNames = other.subjectAlternativeNames;
            }
            if (other.getType() != null) {
                this.type = other.type;
            }
            return this;
        }

        Builder(SslCertificate source) {
            this.certificate = source.certificate;
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.expireTime = source.expireTime;
            this.id = source.id;
            this.kind = source.kind;
            this.managed = source.managed;
            this.name = source.name;
            this.privateKey = source.privateKey;
            this.region = source.region;
            this.selfLink = source.selfLink;
            this.selfManaged = source.selfManaged;
            this.subjectAlternativeNames = source.subjectAlternativeNames;
            this.type = source.type;
        }

        public String getCertificate() {
            return this.certificate;
        }

        public Builder setCertificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getExpireTime() {
            return this.expireTime;
        }

        public Builder setExpireTime(String expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public SslCertificateManagedSslCertificate getManaged() {
            return this.managed;
        }

        public Builder setManaged(SslCertificateManagedSslCertificate managed) {
            this.managed = managed;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public Builder setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public SslCertificateSelfManagedSslCertificate getSelfManaged() {
            return this.selfManaged;
        }

        public Builder setSelfManaged(SslCertificateSelfManagedSslCertificate selfManaged) {
            this.selfManaged = selfManaged;
            return this;
        }

        public List<String> getSubjectAlternativeNamesList() {
            return this.subjectAlternativeNames;
        }

        public Builder addAllSubjectAlternativeNames(List<String> subjectAlternativeNames) {
            if (this.subjectAlternativeNames == null) {
                this.subjectAlternativeNames = new LinkedList<String>();
            }
            this.subjectAlternativeNames.addAll(subjectAlternativeNames);
            return this;
        }

        public Builder addSubjectAlternativeNames(String subjectAlternativeNames) {
            if (this.subjectAlternativeNames == null) {
                this.subjectAlternativeNames = new LinkedList<String>();
            }
            this.subjectAlternativeNames.add(subjectAlternativeNames);
            return this;
        }

        public String getType() {
            return this.type;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public SslCertificate build() {
            return new SslCertificate(this.certificate, this.creationTimestamp, this.description, this.expireTime, this.id, this.kind, this.managed, this.name, this.privateKey, this.region, this.selfLink, this.selfManaged, this.subjectAlternativeNames, this.type);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCertificate(this.certificate);
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setExpireTime(this.expireTime);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setManaged(this.managed);
            newBuilder.setName(this.name);
            newBuilder.setPrivateKey(this.privateKey);
            newBuilder.setRegion(this.region);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setSelfManaged(this.selfManaged);
            newBuilder.addAllSubjectAlternativeNames(this.subjectAlternativeNames);
            newBuilder.setType(this.type);
            return newBuilder;
        }
    }
}

