/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.DeleteSnapshotHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicySnapshotHttpRequest;
import com.google.cloud.compute.v1.GetSnapshotHttpRequest;
import com.google.cloud.compute.v1.ListSnapshotsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ProjectGlobalSnapshotName;
import com.google.cloud.compute.v1.ProjectGlobalSnapshotResourceName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.SetIamPolicySnapshotHttpRequest;
import com.google.cloud.compute.v1.SetLabelsSnapshotHttpRequest;
import com.google.cloud.compute.v1.Snapshot;
import com.google.cloud.compute.v1.SnapshotClient;
import com.google.cloud.compute.v1.SnapshotList;
import com.google.cloud.compute.v1.TestIamPermissionsSnapshotHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonSnapshotCallableFactory;
import com.google.cloud.compute.v1.stub.SnapshotStub;
import com.google.cloud.compute.v1.stub.SnapshotStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonSnapshotStub
extends SnapshotStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteSnapshotHttpRequest, Operation> deleteSnapshotMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.snapshots.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/snapshots/{snapshot}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalSnapshotName.newFactory()).setResourceNameField("snapshot").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetSnapshotHttpRequest, Snapshot> getSnapshotMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.snapshots.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/snapshots/{snapshot}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalSnapshotName.newFactory()).setResourceNameField("snapshot").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Snapshot.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetIamPolicySnapshotHttpRequest, Policy> getIamPolicySnapshotMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.snapshots.getIamPolicy").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/snapshots/{resource}/getIamPolicy")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"optionsRequestedPolicyVersion"})).setResourceNameFactory(ProjectGlobalSnapshotResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Policy.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListSnapshotsHttpRequest, SnapshotList> listSnapshotsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.snapshots.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/snapshots")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)SnapshotList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<SetIamPolicySnapshotHttpRequest, Policy> setIamPolicySnapshotMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.snapshots.setIamPolicy").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/snapshots/{resource}/setIamPolicy")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalSnapshotResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Policy.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<SetLabelsSnapshotHttpRequest, Operation> setLabelsSnapshotMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.snapshots.setLabels").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/snapshots/{resource}/setLabels")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalSnapshotResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<TestIamPermissionsSnapshotHttpRequest, TestPermissionsResponse> testIamPermissionsSnapshotMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.snapshots.testIamPermissions").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/snapshots/{resource}/testIamPermissions")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalSnapshotResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)TestPermissionsResponse.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteSnapshotHttpRequest, Operation> deleteSnapshotCallable;
    private final UnaryCallable<GetSnapshotHttpRequest, Snapshot> getSnapshotCallable;
    private final UnaryCallable<GetIamPolicySnapshotHttpRequest, Policy> getIamPolicySnapshotCallable;
    private final UnaryCallable<ListSnapshotsHttpRequest, SnapshotList> listSnapshotsCallable;
    private final UnaryCallable<ListSnapshotsHttpRequest, SnapshotClient.ListSnapshotsPagedResponse> listSnapshotsPagedCallable;
    private final UnaryCallable<SetIamPolicySnapshotHttpRequest, Policy> setIamPolicySnapshotCallable;
    private final UnaryCallable<SetLabelsSnapshotHttpRequest, Operation> setLabelsSnapshotCallable;
    private final UnaryCallable<TestIamPermissionsSnapshotHttpRequest, TestPermissionsResponse> testIamPermissionsSnapshotCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonSnapshotStub create(SnapshotStubSettings settings) throws IOException {
        return new HttpJsonSnapshotStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonSnapshotStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonSnapshotStub(SnapshotStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonSnapshotStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonSnapshotStub(SnapshotStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonSnapshotStub(SnapshotStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonSnapshotCallableFactory());
    }

    protected HttpJsonSnapshotStub(SnapshotStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteSnapshotTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteSnapshotMethodDescriptor).build();
        HttpJsonCallSettings getSnapshotTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getSnapshotMethodDescriptor).build();
        HttpJsonCallSettings getIamPolicySnapshotTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicySnapshotMethodDescriptor).build();
        HttpJsonCallSettings listSnapshotsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listSnapshotsMethodDescriptor).build();
        HttpJsonCallSettings setIamPolicySnapshotTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicySnapshotMethodDescriptor).build();
        HttpJsonCallSettings setLabelsSnapshotTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setLabelsSnapshotMethodDescriptor).build();
        HttpJsonCallSettings testIamPermissionsSnapshotTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsSnapshotMethodDescriptor).build();
        this.deleteSnapshotCallable = callableFactory.createUnaryCallable(deleteSnapshotTransportSettings, settings.deleteSnapshotSettings(), clientContext);
        this.getSnapshotCallable = callableFactory.createUnaryCallable(getSnapshotTransportSettings, settings.getSnapshotSettings(), clientContext);
        this.getIamPolicySnapshotCallable = callableFactory.createUnaryCallable(getIamPolicySnapshotTransportSettings, settings.getIamPolicySnapshotSettings(), clientContext);
        this.listSnapshotsCallable = callableFactory.createUnaryCallable(listSnapshotsTransportSettings, settings.listSnapshotsSettings(), clientContext);
        this.listSnapshotsPagedCallable = callableFactory.createPagedCallable(listSnapshotsTransportSettings, settings.listSnapshotsSettings(), clientContext);
        this.setIamPolicySnapshotCallable = callableFactory.createUnaryCallable(setIamPolicySnapshotTransportSettings, settings.setIamPolicySnapshotSettings(), clientContext);
        this.setLabelsSnapshotCallable = callableFactory.createUnaryCallable(setLabelsSnapshotTransportSettings, settings.setLabelsSnapshotSettings(), clientContext);
        this.testIamPermissionsSnapshotCallable = callableFactory.createUnaryCallable(testIamPermissionsSnapshotTransportSettings, settings.testIamPermissionsSnapshotSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteSnapshotHttpRequest, Operation> deleteSnapshotCallable() {
        return this.deleteSnapshotCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetSnapshotHttpRequest, Snapshot> getSnapshotCallable() {
        return this.getSnapshotCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetIamPolicySnapshotHttpRequest, Policy> getIamPolicySnapshotCallable() {
        return this.getIamPolicySnapshotCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListSnapshotsHttpRequest, SnapshotClient.ListSnapshotsPagedResponse> listSnapshotsPagedCallable() {
        return this.listSnapshotsPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListSnapshotsHttpRequest, SnapshotList> listSnapshotsCallable() {
        return this.listSnapshotsCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<SetIamPolicySnapshotHttpRequest, Policy> setIamPolicySnapshotCallable() {
        return this.setIamPolicySnapshotCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<SetLabelsSnapshotHttpRequest, Operation> setLabelsSnapshotCallable() {
        return this.setLabelsSnapshotCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<TestIamPermissionsSnapshotHttpRequest, TestPermissionsResponse> testIamPermissionsSnapshotCallable() {
        return this.testIamPermissionsSnapshotCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

