/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class CustomerEncryptionKey
implements ApiMessage {
    private final String kmsKeyName;
    private final String kmsKeyServiceAccount;
    private final String rawKey;
    private final String sha256;
    private static final CustomerEncryptionKey DEFAULT_INSTANCE = new CustomerEncryptionKey();

    private CustomerEncryptionKey() {
        this.kmsKeyName = null;
        this.kmsKeyServiceAccount = null;
        this.rawKey = null;
        this.sha256 = null;
    }

    private CustomerEncryptionKey(String kmsKeyName, String kmsKeyServiceAccount, String rawKey, String sha256) {
        this.kmsKeyName = kmsKeyName;
        this.kmsKeyServiceAccount = kmsKeyServiceAccount;
        this.rawKey = rawKey;
        this.sha256 = sha256;
    }

    public Object getFieldValue(String fieldName) {
        if ("kmsKeyName".equals(fieldName)) {
            return this.kmsKeyName;
        }
        if ("kmsKeyServiceAccount".equals(fieldName)) {
            return this.kmsKeyServiceAccount;
        }
        if ("rawKey".equals(fieldName)) {
            return this.rawKey;
        }
        if ("sha256".equals(fieldName)) {
            return this.sha256;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getKmsKeyName() {
        return this.kmsKeyName;
    }

    public String getKmsKeyServiceAccount() {
        return this.kmsKeyServiceAccount;
    }

    public String getRawKey() {
        return this.rawKey;
    }

    public String getSha256() {
        return this.sha256;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(CustomerEncryptionKey prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static CustomerEncryptionKey getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "CustomerEncryptionKey{kmsKeyName=" + this.kmsKeyName + ", kmsKeyServiceAccount=" + this.kmsKeyServiceAccount + ", rawKey=" + this.rawKey + ", sha256=" + this.sha256 + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CustomerEncryptionKey) {
            CustomerEncryptionKey that = (CustomerEncryptionKey)o;
            return Objects.equals(this.kmsKeyName, that.getKmsKeyName()) && Objects.equals(this.kmsKeyServiceAccount, that.getKmsKeyServiceAccount()) && Objects.equals(this.rawKey, that.getRawKey()) && Objects.equals(this.sha256, that.getSha256());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.kmsKeyName, this.kmsKeyServiceAccount, this.rawKey, this.sha256);
    }

    public static class Builder {
        private String kmsKeyName;
        private String kmsKeyServiceAccount;
        private String rawKey;
        private String sha256;

        Builder() {
        }

        public Builder mergeFrom(CustomerEncryptionKey other) {
            if (other == CustomerEncryptionKey.getDefaultInstance()) {
                return this;
            }
            if (other.getKmsKeyName() != null) {
                this.kmsKeyName = other.kmsKeyName;
            }
            if (other.getKmsKeyServiceAccount() != null) {
                this.kmsKeyServiceAccount = other.kmsKeyServiceAccount;
            }
            if (other.getRawKey() != null) {
                this.rawKey = other.rawKey;
            }
            if (other.getSha256() != null) {
                this.sha256 = other.sha256;
            }
            return this;
        }

        Builder(CustomerEncryptionKey source) {
            this.kmsKeyName = source.kmsKeyName;
            this.kmsKeyServiceAccount = source.kmsKeyServiceAccount;
            this.rawKey = source.rawKey;
            this.sha256 = source.sha256;
        }

        public String getKmsKeyName() {
            return this.kmsKeyName;
        }

        public Builder setKmsKeyName(String kmsKeyName) {
            this.kmsKeyName = kmsKeyName;
            return this;
        }

        public String getKmsKeyServiceAccount() {
            return this.kmsKeyServiceAccount;
        }

        public Builder setKmsKeyServiceAccount(String kmsKeyServiceAccount) {
            this.kmsKeyServiceAccount = kmsKeyServiceAccount;
            return this;
        }

        public String getRawKey() {
            return this.rawKey;
        }

        public Builder setRawKey(String rawKey) {
            this.rawKey = rawKey;
            return this;
        }

        public String getSha256() {
            return this.sha256;
        }

        public Builder setSha256(String sha256) {
            this.sha256 = sha256;
            return this;
        }

        public CustomerEncryptionKey build() {
            return new CustomerEncryptionKey(this.kmsKeyName, this.kmsKeyServiceAccount, this.rawKey, this.sha256);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setKmsKeyName(this.kmsKeyName);
            newBuilder.setKmsKeyServiceAccount(this.kmsKeyServiceAccount);
            newBuilder.setRawKey(this.rawKey);
            newBuilder.setSha256(this.sha256);
            return newBuilder;
        }
    }
}

