/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetZoneHttpRequest;
import com.google.cloud.compute.v1.ListZonesHttpRequest;
import com.google.cloud.compute.v1.Zone;
import com.google.cloud.compute.v1.ZoneClient;
import com.google.cloud.compute.v1.ZoneList;
import com.google.cloud.compute.v1.stub.HttpJsonZoneStub;
import com.google.cloud.compute.v1.stub.ZoneStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ZoneStubSettings
extends StubSettings<ZoneStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<GetZoneHttpRequest, Zone> getZoneSettings;
    private final PagedCallSettings<ListZonesHttpRequest, ZoneList, ZoneClient.ListZonesPagedResponse> listZonesSettings;
    private static final PagedListDescriptor<ListZonesHttpRequest, ZoneList, Zone> LIST_ZONES_PAGE_STR_DESC = new PagedListDescriptor<ListZonesHttpRequest, ZoneList, Zone>(){

        public String emptyToken() {
            return "";
        }

        public ListZonesHttpRequest injectToken(ListZonesHttpRequest payload, String token) {
            return ListZonesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListZonesHttpRequest injectPageSize(ListZonesHttpRequest payload, int pageSize) {
            return ListZonesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListZonesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ZoneList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Zone> extractResources(ZoneList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListZonesHttpRequest, ZoneList, ZoneClient.ListZonesPagedResponse> LIST_ZONES_PAGE_STR_FACT = new PagedListResponseFactory<ListZonesHttpRequest, ZoneList, ZoneClient.ListZonesPagedResponse>(){

        public ApiFuture<ZoneClient.ListZonesPagedResponse> getFuturePagedResponse(UnaryCallable<ListZonesHttpRequest, ZoneList> callable, ListZonesHttpRequest request, ApiCallContext context, ApiFuture<ZoneList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ZONES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ZoneClient.ListZonesPagedResponse.createAsync((PageContext<ListZonesHttpRequest, ZoneList, Zone>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetZoneHttpRequest, Zone> getZoneSettings() {
        return this.getZoneSettings;
    }

    public PagedCallSettings<ListZonesHttpRequest, ZoneList, ZoneClient.ListZonesPagedResponse> listZonesSettings() {
        return this.listZonesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ZoneStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonZoneStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ZoneStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ZoneStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ZoneStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getZoneSettings = settingsBuilder.getZoneSettings().build();
        this.listZonesSettings = settingsBuilder.listZonesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ZoneStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetZoneHttpRequest, Zone> getZoneSettings;
        private final PagedCallSettings.Builder<ListZonesHttpRequest, ZoneList, ZoneClient.ListZonesPagedResponse> listZonesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getZoneSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listZonesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ZONES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getZoneSettings, this.listZonesSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ZoneStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ZoneStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ZoneStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ZoneStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getZoneSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listZonesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(ZoneStubSettings settings) {
            super((StubSettings)settings);
            this.getZoneSettings = settings.getZoneSettings.toBuilder();
            this.listZonesSettings = settings.listZonesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getZoneSettings, this.listZonesSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetZoneHttpRequest, Zone> getZoneSettings() {
            return this.getZoneSettings;
        }

        public PagedCallSettings.Builder<ListZonesHttpRequest, ZoneList, ZoneClient.ListZonesPagedResponse> listZonesSettings() {
            return this.listZonesSettings;
        }

        public ZoneStubSettings build() throws IOException {
            return new ZoneStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

