/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteTargetTcpProxyHttpRequest;
import com.google.cloud.compute.v1.GetTargetTcpProxyHttpRequest;
import com.google.cloud.compute.v1.InsertTargetTcpProxyHttpRequest;
import com.google.cloud.compute.v1.ListTargetTcpProxiesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetBackendServiceTargetTcpProxyHttpRequest;
import com.google.cloud.compute.v1.SetProxyHeaderTargetTcpProxyHttpRequest;
import com.google.cloud.compute.v1.TargetTcpProxy;
import com.google.cloud.compute.v1.TargetTcpProxyClient;
import com.google.cloud.compute.v1.TargetTcpProxyList;
import com.google.cloud.compute.v1.stub.HttpJsonTargetTcpProxyStub;
import com.google.cloud.compute.v1.stub.TargetTcpProxyStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class TargetTcpProxyStubSettings
extends StubSettings<TargetTcpProxyStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteTargetTcpProxyHttpRequest, Operation> deleteTargetTcpProxySettings;
    private final UnaryCallSettings<GetTargetTcpProxyHttpRequest, TargetTcpProxy> getTargetTcpProxySettings;
    private final UnaryCallSettings<InsertTargetTcpProxyHttpRequest, Operation> insertTargetTcpProxySettings;
    private final PagedCallSettings<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList, TargetTcpProxyClient.ListTargetTcpProxiesPagedResponse> listTargetTcpProxiesSettings;
    private final UnaryCallSettings<SetBackendServiceTargetTcpProxyHttpRequest, Operation> setBackendServiceTargetTcpProxySettings;
    private final UnaryCallSettings<SetProxyHeaderTargetTcpProxyHttpRequest, Operation> setProxyHeaderTargetTcpProxySettings;
    private static final PagedListDescriptor<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList, TargetTcpProxy> LIST_TARGET_TCP_PROXIES_PAGE_STR_DESC = new PagedListDescriptor<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList, TargetTcpProxy>(){

        public String emptyToken() {
            return "";
        }

        public ListTargetTcpProxiesHttpRequest injectToken(ListTargetTcpProxiesHttpRequest payload, String token) {
            return ListTargetTcpProxiesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListTargetTcpProxiesHttpRequest injectPageSize(ListTargetTcpProxiesHttpRequest payload, int pageSize) {
            return ListTargetTcpProxiesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListTargetTcpProxiesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetTcpProxyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetTcpProxy> extractResources(TargetTcpProxyList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList, TargetTcpProxyClient.ListTargetTcpProxiesPagedResponse> LIST_TARGET_TCP_PROXIES_PAGE_STR_FACT = new PagedListResponseFactory<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList, TargetTcpProxyClient.ListTargetTcpProxiesPagedResponse>(){

        public ApiFuture<TargetTcpProxyClient.ListTargetTcpProxiesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList> callable, ListTargetTcpProxiesHttpRequest request, ApiCallContext context, ApiFuture<TargetTcpProxyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TARGET_TCP_PROXIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetTcpProxyClient.ListTargetTcpProxiesPagedResponse.createAsync((PageContext<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList, TargetTcpProxy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteTargetTcpProxyHttpRequest, Operation> deleteTargetTcpProxySettings() {
        return this.deleteTargetTcpProxySettings;
    }

    public UnaryCallSettings<GetTargetTcpProxyHttpRequest, TargetTcpProxy> getTargetTcpProxySettings() {
        return this.getTargetTcpProxySettings;
    }

    public UnaryCallSettings<InsertTargetTcpProxyHttpRequest, Operation> insertTargetTcpProxySettings() {
        return this.insertTargetTcpProxySettings;
    }

    public PagedCallSettings<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList, TargetTcpProxyClient.ListTargetTcpProxiesPagedResponse> listTargetTcpProxiesSettings() {
        return this.listTargetTcpProxiesSettings;
    }

    public UnaryCallSettings<SetBackendServiceTargetTcpProxyHttpRequest, Operation> setBackendServiceTargetTcpProxySettings() {
        return this.setBackendServiceTargetTcpProxySettings;
    }

    public UnaryCallSettings<SetProxyHeaderTargetTcpProxyHttpRequest, Operation> setProxyHeaderTargetTcpProxySettings() {
        return this.setProxyHeaderTargetTcpProxySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetTcpProxyStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTargetTcpProxyStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TargetTcpProxyStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TargetTcpProxyStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TargetTcpProxyStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteTargetTcpProxySettings = settingsBuilder.deleteTargetTcpProxySettings().build();
        this.getTargetTcpProxySettings = settingsBuilder.getTargetTcpProxySettings().build();
        this.insertTargetTcpProxySettings = settingsBuilder.insertTargetTcpProxySettings().build();
        this.listTargetTcpProxiesSettings = settingsBuilder.listTargetTcpProxiesSettings().build();
        this.setBackendServiceTargetTcpProxySettings = settingsBuilder.setBackendServiceTargetTcpProxySettings().build();
        this.setProxyHeaderTargetTcpProxySettings = settingsBuilder.setProxyHeaderTargetTcpProxySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TargetTcpProxyStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteTargetTcpProxyHttpRequest, Operation> deleteTargetTcpProxySettings;
        private final UnaryCallSettings.Builder<GetTargetTcpProxyHttpRequest, TargetTcpProxy> getTargetTcpProxySettings;
        private final UnaryCallSettings.Builder<InsertTargetTcpProxyHttpRequest, Operation> insertTargetTcpProxySettings;
        private final PagedCallSettings.Builder<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList, TargetTcpProxyClient.ListTargetTcpProxiesPagedResponse> listTargetTcpProxiesSettings;
        private final UnaryCallSettings.Builder<SetBackendServiceTargetTcpProxyHttpRequest, Operation> setBackendServiceTargetTcpProxySettings;
        private final UnaryCallSettings.Builder<SetProxyHeaderTargetTcpProxyHttpRequest, Operation> setProxyHeaderTargetTcpProxySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteTargetTcpProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTargetTcpProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertTargetTcpProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTargetTcpProxiesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TARGET_TCP_PROXIES_PAGE_STR_FACT);
            this.setBackendServiceTargetTcpProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setProxyHeaderTargetTcpProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteTargetTcpProxySettings, this.getTargetTcpProxySettings, this.insertTargetTcpProxySettings, this.listTargetTcpProxiesSettings, this.setBackendServiceTargetTcpProxySettings, this.setProxyHeaderTargetTcpProxySettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TargetTcpProxyStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TargetTcpProxyStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TargetTcpProxyStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TargetTcpProxyStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteTargetTcpProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getTargetTcpProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertTargetTcpProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTargetTcpProxiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setBackendServiceTargetTcpProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setProxyHeaderTargetTcpProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(TargetTcpProxyStubSettings settings) {
            super((StubSettings)settings);
            this.deleteTargetTcpProxySettings = settings.deleteTargetTcpProxySettings.toBuilder();
            this.getTargetTcpProxySettings = settings.getTargetTcpProxySettings.toBuilder();
            this.insertTargetTcpProxySettings = settings.insertTargetTcpProxySettings.toBuilder();
            this.listTargetTcpProxiesSettings = settings.listTargetTcpProxiesSettings.toBuilder();
            this.setBackendServiceTargetTcpProxySettings = settings.setBackendServiceTargetTcpProxySettings.toBuilder();
            this.setProxyHeaderTargetTcpProxySettings = settings.setProxyHeaderTargetTcpProxySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteTargetTcpProxySettings, this.getTargetTcpProxySettings, this.insertTargetTcpProxySettings, this.listTargetTcpProxiesSettings, this.setBackendServiceTargetTcpProxySettings, this.setProxyHeaderTargetTcpProxySettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteTargetTcpProxyHttpRequest, Operation> deleteTargetTcpProxySettings() {
            return this.deleteTargetTcpProxySettings;
        }

        public UnaryCallSettings.Builder<GetTargetTcpProxyHttpRequest, TargetTcpProxy> getTargetTcpProxySettings() {
            return this.getTargetTcpProxySettings;
        }

        public UnaryCallSettings.Builder<InsertTargetTcpProxyHttpRequest, Operation> insertTargetTcpProxySettings() {
            return this.insertTargetTcpProxySettings;
        }

        public PagedCallSettings.Builder<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList, TargetTcpProxyClient.ListTargetTcpProxiesPagedResponse> listTargetTcpProxiesSettings() {
            return this.listTargetTcpProxiesSettings;
        }

        public UnaryCallSettings.Builder<SetBackendServiceTargetTcpProxyHttpRequest, Operation> setBackendServiceTargetTcpProxySettings() {
            return this.setBackendServiceTargetTcpProxySettings;
        }

        public UnaryCallSettings.Builder<SetProxyHeaderTargetTcpProxyHttpRequest, Operation> setProxyHeaderTargetTcpProxySettings() {
            return this.setProxyHeaderTargetTcpProxySettings;
        }

        public TargetTcpProxyStubSettings build() throws IOException {
            return new TargetTcpProxyStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

