/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.TargetHttpsProxy;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class TargetHttpsProxiesScopedList
implements ApiMessage {
    private final List<TargetHttpsProxy> targetHttpsProxies;
    private final Warning warning;
    private static final TargetHttpsProxiesScopedList DEFAULT_INSTANCE = new TargetHttpsProxiesScopedList();

    private TargetHttpsProxiesScopedList() {
        this.targetHttpsProxies = null;
        this.warning = null;
    }

    private TargetHttpsProxiesScopedList(List<TargetHttpsProxy> targetHttpsProxies, Warning warning) {
        this.targetHttpsProxies = targetHttpsProxies;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("targetHttpsProxies".equals(fieldName)) {
            return this.targetHttpsProxies;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<TargetHttpsProxy> getTargetHttpsProxiesList() {
        return this.targetHttpsProxies;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TargetHttpsProxiesScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static TargetHttpsProxiesScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "TargetHttpsProxiesScopedList{targetHttpsProxies=" + this.targetHttpsProxies + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TargetHttpsProxiesScopedList) {
            TargetHttpsProxiesScopedList that = (TargetHttpsProxiesScopedList)o;
            return Objects.equals(this.targetHttpsProxies, that.getTargetHttpsProxiesList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.targetHttpsProxies, this.warning);
    }

    public static class Builder {
        private List<TargetHttpsProxy> targetHttpsProxies;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(TargetHttpsProxiesScopedList other) {
            if (other == TargetHttpsProxiesScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getTargetHttpsProxiesList() != null) {
                this.targetHttpsProxies = other.targetHttpsProxies;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(TargetHttpsProxiesScopedList source) {
            this.targetHttpsProxies = source.targetHttpsProxies;
            this.warning = source.warning;
        }

        public List<TargetHttpsProxy> getTargetHttpsProxiesList() {
            return this.targetHttpsProxies;
        }

        public Builder addAllTargetHttpsProxies(List<TargetHttpsProxy> targetHttpsProxies) {
            if (this.targetHttpsProxies == null) {
                this.targetHttpsProxies = new LinkedList<TargetHttpsProxy>();
            }
            this.targetHttpsProxies.addAll(targetHttpsProxies);
            return this;
        }

        public Builder addTargetHttpsProxies(TargetHttpsProxy targetHttpsProxies) {
            if (this.targetHttpsProxies == null) {
                this.targetHttpsProxies = new LinkedList<TargetHttpsProxy>();
            }
            this.targetHttpsProxies.add(targetHttpsProxies);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public TargetHttpsProxiesScopedList build() {
            return new TargetHttpsProxiesScopedList(this.targetHttpsProxies, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllTargetHttpsProxies(this.targetHttpsProxies);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

